/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.Authenticator;
import java.io.IOException;
import java.security.AccessController;
import java.util.Base64;
import java.util.Properties;
import javax.baja.net.HttpConnection;
import javax.baja.security.BPassword;

public class BasicAuthenticator
extends Authenticator {
    private String realm;
    private boolean finalAuthorizationSet = false;

    protected BasicAuthenticator(String realm) {
        this.realm = realm;
    }

    public String getAuthenticationScheme() {
        return "HTTP-Basic";
    }

    @Override
    public boolean setAuthorization(HttpConnection conn, String uri) throws IOException {
        return this.setAuthorization(conn, uri, null);
    }

    @Override
    public boolean setAuthorization(HttpConnection conn, String uri, Properties properties) throws IOException {
        if (this.getUserAndPwd() == null) {
            return false;
        }
        StringBuilder response = new StringBuilder();
        String userPass = this.getUserAndPwd().getUsername() + ":" + AccessController.doPrivileged(() -> ((BPassword)this.getUserAndPwd().getPassword()).getValue());
        response.append("Basic ").append(Base64.getEncoder().encodeToString(userPass.getBytes()));
        conn.setRequestHeader("Authorization", response.toString());
        this.finalAuthorizationSet = true;
        return true;
    }

    @Override
    public boolean finalAuthorizationSet() {
        return this.finalAuthorizationSet;
    }

    @Override
    public String getAuthenticationFailureMessage() {
        return null;
    }

    @Override
    public boolean canReuseAuthorizationHeader() {
        return true;
    }

    public String getAuthenticationRealmName() {
        return this.realm;
    }
}

