/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.fox.sys.BFoxScheme;
import com.tridium.fox.sys.BFoxsScheme;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.QueryRequestStateMessage;
import com.tridium.platform.daemon.message.SaveStationMessage;
import com.tridium.platform.daemon.message.SetStationWatchPauseStateMessage;
import com.tridium.platform.daemon.message.StationThreadDumpMessage;
import com.tridium.platform.daemon.message.SyncStationModulesMessage;
import com.tridium.platform.daemon.message.UpdateStationCertAliasMessage;
import com.tridium.platform.daemon.message.UpdateStationTlsVersionMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BStationSurrogate
extends BAppSurrogate {
    public static final Property foxPort = BStationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property foxsPort = BStationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property httpPort = BStationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property httpsPort = BStationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property foxOrd = BStationSurrogate.newProperty((int)3, (BValue)BOrd.DEFAULT, null);
    public static final Property foxsOrd = BStationSurrogate.newProperty((int)3, (BValue)BOrd.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BStationSurrogate.class);

    public String getStationName() {
        return this.getAppName();
    }

    public void setStationName(String v) {
        this.setAppName(v);
    }

    public BStationStatus getStationStatus() {
        return this.getAppStatus();
    }

    public void setStationStatus(BStationStatus v) {
        this.setAppStatus(v);
    }

    public int getFoxPort() {
        return this.getInt(foxPort);
    }

    public void setFoxPort(int v) {
        this.setInt(foxPort, v, null);
    }

    public int getFoxsPort() {
        return this.getInt(foxsPort);
    }

    public void setFoxsPort(int v) {
        this.setInt(foxsPort, v, null);
    }

    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    public void setHttpPort(int v) {
        this.setInt(httpPort, v, null);
    }

    public int getHttpsPort() {
        return this.getInt(httpsPort);
    }

    public void setHttpsPort(int v) {
        this.setInt(httpsPort, v, null);
    }

    public BOrd getFoxOrd() {
        return (BOrd)this.get(foxOrd);
    }

    public void setFoxOrd(BOrd v) {
        this.set(foxOrd, (BValue)v, null);
    }

    public BOrd getFoxsOrd() {
        return (BOrd)this.get(foxsOrd);
    }

    public void setFoxsOrd(BOrd v) {
        this.set(foxsOrd, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BStationSurrogate() {
        throw new UnsupportedOperationException();
    }

    public BStationSurrogate(BDaemonSession session) {
        super(session);
    }

    public static BStationSurrogate make(BDaemonSession session, String stationName) throws Exception {
        BStationSurrogate result = new BStationSurrogate(session);
        result.setAppName(stationName);
        result.poll();
        return result;
    }

    public static BStationSurrogate[] makeAll(BDaemonSession session) throws Exception {
        return BStationSurrogate.array(BStationSurrogate.makeAll(TYPE, session));
    }

    public static boolean isAnyStationRunning(BDaemonSession session) throws Exception {
        return BStationSurrogate.isAnyAppRunning(TYPE, session);
    }

    public static boolean isAnyStationStarting(BDaemonSession session) throws Exception {
        return BStationSurrogate.isAnyAppStarting(TYPE, session);
    }

    public static boolean isAnyStationStopping(BDaemonSession session) throws Exception {
        return BStationSurrogate.isAnyAppStopping(TYPE, session);
    }

    @Override
    public void updateFields(XElem stationElement) {
        super.updateFields(stationElement);
        XElem elem = stationElement.elem("foxport");
        if (elem != null) {
            this.setFoxPort(elem.geti("value"));
            if (this.getFoxPort() == -1) {
                this.setFoxOrd(BOrd.DEFAULT);
            } else {
                this.setFoxOrd(BOrd.make((BOrd)this.session.getHost().getNavOrd(), (OrdQuery)BFoxScheme.INSTANCE.parse(elem.get("value"))));
            }
        } else {
            this.setFoxPort(-1);
            this.setFoxOrd(BOrd.DEFAULT);
        }
        elem = stationElement.elem("foxsport");
        if (elem != null) {
            this.setFoxsPort(elem.geti("value"));
            if (this.getFoxsPort() == -1) {
                this.setFoxsOrd(BOrd.DEFAULT);
            } else {
                this.setFoxsOrd(BOrd.make((BOrd)this.session.getHost().getNavOrd(), (OrdQuery)BFoxsScheme.INSTANCE.parse(elem.get("value"))));
            }
        } else {
            this.setFoxsPort(-1);
            this.setFoxsOrd(BOrd.DEFAULT);
        }
        elem = stationElement.elem("httpport");
        if (elem != null) {
            this.setHttpPort(elem.geti("value"));
        } else {
            this.setHttpPort(-1);
        }
        elem = stationElement.elem("httpsport");
        if (elem != null) {
            this.setHttpsPort(elem.geti("value"));
        } else {
            this.setHttpsPort(-1);
        }
    }

    public InputStream getStationOutput() throws ConnectException, AuthenticationException {
        return this.getAppOutput(true, false);
    }

    public InputStream getStationOutput(boolean follow) throws ConnectException, AuthenticationException {
        return this.getAppOutput(follow, false);
    }

    public InputStream getStationOutput(boolean follow, boolean updatesOnly) throws ConnectException, AuthenticationException {
        return this.getAppOutput(follow, updatesOnly);
    }

    public void dumpThreads() throws ConnectException, AuthenticationException {
        this.getDaemonSession().sendMessage(new StationThreadDumpMessage(this.getAppName()));
    }

    public void startStationAsync() throws ConnectException, AuthenticationException {
        this.startAppAsync();
    }

    public void startStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        this.startApp(cancelHint, listener);
    }

    public static BStationSurrogate[] stopAllStations(BDaemonSession session, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        return BStationSurrogate.array(BStationSurrogate.stopAllApps(session, TYPE, BStationSurrogate.makeAll(session), cancelHint, listener));
    }

    public static BStationSurrogate[] stopAllStations(BDaemonSession session, BStationSurrogate[] stations, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        return BStationSurrogate.array(BStationSurrogate.stopAllApps(session, TYPE, stations, cancelHint, listener));
    }

    public static void saveStation(BDaemonSession session, String stationName, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        try {
            BStationSurrogate.make(session, stationName).saveStation(cancelHint, listener);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static void saveStationAsync(BDaemonSession session, String stationName) throws ConnectException, AuthenticationException {
        try {
            BStationSurrogate.make(session, stationName).saveStationAsync();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void syncStationModulesAsync() throws ConnectException, AuthenticationException {
        try {
            this.getDaemonSession().sendMessage(new SyncStationModulesMessage(this.getStationName()));
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void saveStationAsync() throws ConnectException, AuthenticationException {
        try {
            this.getDaemonSession().sendMessage(new SaveStationMessage(this.getStationName()));
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void saveStation(ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        this.saveStation(cancelHint, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        CancelableDaemonSessionTask task;
        block14: {
            if (this.getAppStatus() != BStationStatus.running) {
                return;
            }
            task = null;
            try {
                if (listener != null) {
                    task = new CancelableDaemonSessionTask(lex, "StationSurrogate.saving.title", "StationSurrogate.saving.message", new Object[]{this.getAppName()}, cancelHint);
                    task.setCancelLabel(lex.getText("StationSurrogate.saving.cancel"));
                    listener.taskStarted(task);
                }
                JobResult jobResult = this.getJobResult(this.getAppName());
                if (log.isLoggable(Level.FINE)) {
                    log.fine("saveStation initial jobResult = " + jobResult);
                }
                long lastSaveMillis = jobResult == null ? 0L : jobResult.millis;
                this.saveStationAsync();
                jobResult = this.getJobResult(this.getAppName());
                while (!BStationSurrogate.newCompletedJob(jobResult, lastSaveMillis) && !BStationSurrogate.isCanceled(task)) {
                    Thread.sleep(1000L);
                    jobResult = this.getJobResult(this.getAppName());
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("saveStation jobResult = " + jobResult);
                }
                if (jobResult != null && jobResult.state != BJobState.success && !BStationSurrogate.isCanceled(task)) {
                    throw new BajaRuntimeException("Station save failed: " + jobResult.state);
                }
                if (listener == null || task == null) break block14;
            }
            catch (ConnectException ce) {
                try {
                    throw ce;
                    catch (AuthenticationException ae) {
                        throw ae;
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        throw new BajaRuntimeException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (listener != null && task != null) {
                        listener.taskFinished(task);
                    }
                    throw throwable;
                }
            }
            listener.taskFinished(task);
        }
        if (BStationSurrogate.isCanceled(task)) {
            throw new ICancelHint.CanceledException();
        }
    }

    public static void stopStation(BDaemonSession session, String stationName, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        try {
            BStationSurrogate.make(session, stationName).stopApp(cancelHint, listener);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static void stopStationAsync(BDaemonSession session, String stationName) throws ConnectException, AuthenticationException {
        try {
            BStationSurrogate.make(session, stationName).stopAppAsync();
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void stopStationAsync() throws ConnectException, AuthenticationException {
        this.stopAppAsync();
    }

    public void stopStation(ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        this.stopApp(cancelHint);
    }

    public void stopStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        this.stopApp(cancelHint, listener);
    }

    @Override
    public void stopApp(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        if (!this.isAppStopped()) {
            CancelableDaemonSessionTask task = null;
            try {
                if (this.getAppStatus() != BStationStatus.stopping) {
                    JobResult jobResult;
                    long lastSaveMillis;
                    if (listener != null) {
                        task = new CancelableDaemonSessionTask(lex, "StationSurrogate.stopping.title", "StationSurrogate.stopping.message", new Object[]{this.getAppName()}, cancelHint);
                        task.setCancelLabel(lex.getText("AppSurrogate.stopping.cancel"));
                        listener.taskStarted(task);
                    }
                    long l = lastSaveMillis = (jobResult = this.getJobResult(this.getAppName())) == null ? 0L : jobResult.millis;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("stopStation initial jobResult = " + jobResult);
                    }
                    this.stopAppAsync();
                    jobResult = this.getJobResult(this.getAppName());
                    this.poll();
                    while (!(this.isAppStopped() || BStationSurrogate.newCompletedJob(jobResult, lastSaveMillis) || BStationSurrogate.isCanceled(task))) {
                        Thread.sleep(1000L);
                        this.poll();
                        jobResult = this.getJobResult(this.getAppName());
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("stopStation jobResult = " + jobResult);
                    }
                    if (!this.isAppStopped() && jobResult != null && jobResult.state != BJobState.success && !BStationSurrogate.isCanceled(task)) {
                        throw new BajaRuntimeException("Station save failed: " + jobResult.state);
                    }
                    this.poll();
                    while (!this.isAppStopped() && !BStationSurrogate.isCanceled(task)) {
                        Thread.sleep(1000L);
                        this.poll();
                    }
                }
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (AuthenticationException ae) {
                throw ae;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            finally {
                if (listener != null && task != null) {
                    listener.taskFinished(task);
                }
            }
            if (BStationSurrogate.isCanceled(task)) {
                throw new ICancelHint.CanceledException();
            }
        }
    }

    public void restartStationAsync() throws ConnectException, AuthenticationException {
        this.restartAppAsync();
    }

    public void restartStationAsync(boolean kill) throws ConnectException, AuthenticationException {
        this.restartAppAsync(kill);
    }

    public void deleteStation(ICancelHint cancelHint) throws ConnectException, AuthenticationException {
        this.deleteApp(cancelHint, null);
    }

    public void deleteStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        this.deleteApp(cancelHint, listener);
    }

    @Override
    public void deleteApp(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        super.deleteApp(cancelHint, listener);
        DaemonFileUtil.transfer(this.getDaemonSession(), FileTransferMessage.makeDelete(new FilePath("~stations/" + this.getAppName()), this.getDaemonSession().getFileSpace()), cancelHint, listener);
    }

    public void killStationAsync() throws ConnectException, AuthenticationException {
        this.killAppAsync();
    }

    public void killStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        this.killApp(cancelHint, listener);
    }

    public void makeStationCopy(BDirectory localStationDir, DaemonSessionTaskListener listener) throws Exception {
        BDaemonDirectoryStore src = BDaemonDirectoryStore.make(this.getDaemonSession().getFileSpace(), new FilePath("~stations/" + this.getAppName()), true, false, false, new StoreCache());
        src.copyToLocalHost(localStationDir.getFilePath(), listener);
    }

    public void updateStationCertAlias(String alias) throws ConnectException {
        this.getDaemonSession().sendMessage(new UpdateStationCertAliasMessage(this.getAppName(), alias));
    }

    public void updateStationTlsVersion(String tlsVersion) throws ConnectException {
        this.getDaemonSession().sendMessage(new UpdateStationTlsVersionMessage(this.getAppName(), tlsVersion));
    }

    public static void setStationDirectoryWatchPauseState(BDaemonSession session, boolean pauseState) {
        try {
            if (new Version(session.getHostProperties().getDaemonVersion()).compareTo(new Version("4.10.0.73")) >= 0 && session.isConnected()) {
                session.sendMessage(new SetStationWatchPauseStateMessage(pauseState));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Failed to set station directory watch pause state", t);
        }
    }

    public boolean isStationRunning() {
        return this.isAppRunning();
    }

    public boolean isStationStarting() {
        return this.isAppStarting();
    }

    public boolean isStationStopping() {
        return this.isAppStopping();
    }

    public boolean isStationStopped() {
        return this.isAppStopped();
    }

    public static boolean newCompletedJob(JobResult result, long lastCompletion) {
        if (result == null) {
            return false;
        }
        if (result.state.isComplete()) {
            return result.millis > lastCompletion;
        }
        return false;
    }

    private JobResult getJobResult(String appName) throws Exception {
        XElem mainElem = XParser.make((InputStream)this.session.getInputStream(new QueryRequestStateMessage("baja:StationSaveJob@" + appName))).parse();
        if (mainElem.name().equals("request") && mainElem.get("state", null) != null) {
            return new JobResult(mainElem.get("state", null));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("getJobResult returns null for station " + this.getAppName());
        }
        return null;
    }

    private static BStationSurrogate[] array(BAppSurrogate[] apps) {
        BStationSurrogate[] result = new BStationSurrogate[apps.length];
        for (int i = 0; i < apps.length; ++i) {
            result[i] = (BStationSurrogate)apps[i];
        }
        return result;
    }

    private static class JobResult {
        public BJobState state;
        public long millis;

        public JobResult(String parse) {
            int ixAt;
            if (BAppSurrogate.log.isLoggable(Level.FINE)) {
                BAppSurrogate.log.fine("JobResult parse=" + parse);
            }
            if ((ixAt = parse.indexOf(64)) < 0) {
                this.state = BJobState.make((String)parse);
                this.millis = this.state == BJobState.unknown ? 0L : Clock.millis();
            } else {
                this.state = BJobState.make((String)parse.substring(0, ixAt));
                this.millis = Long.parseLong(parse.substring(ixAt + 1));
            }
        }

        public String toString() {
            return "JobResult(" + this.state.toString() + "," + this.millis + ")";
        }
    }
}

