/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.authn.AuthenticationClient;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonSSLRequiredException;
import java.util.StringTokenizer;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDaemonScheme
extends BOrdScheme {
    private static final String HTTPS_PREFIX = "https://";
    public static final BDaemonScheme INSTANCE = new BDaemonScheme();
    public static final int DEFAULT_PORT = 3011;
    public static final int DEFAULT_SSL_PORT = 5011;
    public static final Type TYPE = Sys.loadType(BDaemonScheme.class);

    private BDaemonScheme() {
        super("platform");
    }

    public OrdQuery parse(String queryBody) {
        return new DaemonQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        return this.resolve(base, query, null);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query, AuthenticationClient client) throws SyntaxException, UnresolvedException {
        if (!(base.get() instanceof BHost)) {
            throw new InvalidOrdBaseException();
        }
        BHost host = (BHost)base.get();
        DaemonQuery daemonQuery = (DaemonQuery)query;
        int port = daemonQuery.port;
        BDaemonSession session = null;
        try {
            session = BDaemonSession.make(host, port);
            if (client != null) {
                session.setAuthenticationClient(client);
            }
            session.connect();
        }
        catch (DaemonSSLRequiredException e) {
            BOrd target;
            if (session != null) {
                session.close();
            }
            if ((target = BDaemonScheme.convert(host, e.getNewLocation())) != null) {
                return target.resolve();
            }
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnresolvedException(query.toString(), (Throwable)e);
        }
        return new OrdTarget(base, (BObject)session);
    }

    public static BOrd convert(BHost host, String location) {
        if (location.startsWith(HTTPS_PREFIX)) {
            String hostname = location.substring(HTTPS_PREFIX.length());
            StringTokenizer st = new StringTokenizer(hostname, ":");
            String port = null;
            hostname = st.nextToken();
            if (st.hasMoreTokens()) {
                port = st.nextToken();
                return BDaemonScheme.createSSLOrd(host.getAbsoluteOrd(), port);
            }
        }
        return null;
    }

    private static BOrd createSSLOrd(BOrd host, String port) {
        int uriIdx = 0;
        uriIdx = port.indexOf("/");
        if (uriIdx > 0) {
            port = port.substring(0, uriIdx);
            StringBuffer sb = new StringBuffer();
            sb.append(host.toString()).append("|platformssl:");
            if (port != null && port.length() > 0) {
                sb.append(port);
            }
            String ord = sb.toString();
            return BOrd.make((String)ord);
        }
        return null;
    }

    public Type getType() {
        return TYPE;
    }

    public static class DaemonQuery
    implements OrdQuery {
        int port;

        protected DaemonQuery(String body) {
            body = body.trim();
            this.port = body.length() == 0 ? this.getDefaultPort() : Integer.parseInt(body);
        }

        protected DaemonQuery(int port) {
            this.port = port;
        }

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return true;
        }

        public void normalize(OrdQueryList list, int index) {
            list.shiftToHost(index);
        }

        public String getScheme() {
            return "platform";
        }

        public String getBody() {
            StringBuffer sb = new StringBuffer();
            if (this.port != this.getDefaultPort()) {
                sb.append(String.valueOf(this.port));
            }
            return sb.toString();
        }

        public String toString() {
            return "platform:" + this.getBody();
        }

        public int getDefaultPort() {
            return 3011;
        }

        public int getPort() {
            return this.port;
        }
    }
}

