/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.command;

import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.platform.command.BPlat;
import com.tridium.util.CommandLineArguments;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPlatformCommandScript
extends BAbstractPlatformCommand {
    public static final BPlatformCommandScript INSTANCE = new BPlatformCommandScript();
    public static final Type TYPE = Sys.loadType(BPlatformCommandScript.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getCommandName() {
        return "script";
    }

    @Override
    public String getCommandDescription() {
        return "run one or more platform commands in a script";
    }

    @Override
    public void usage() {
        BPlatformCommandScript.println("usage:", new Object[0]);
        BPlatformCommandScript.println("  plat script <flags>", new Object[0]);
        BPlatformCommandScript.println("optional flags:", new Object[0]);
        BPlatformCommandScript.println("  -f:<filePath> reads the script from the given file, instead", new Object[0]);
        BPlatformCommandScript.println("                of from standard input", new Object[0]);
        BPlatformCommandScript.println("  -echo         echo commands read from the script", new Object[0]);
        BPlatformCommandScript.println("  -usage        prints this message", new Object[0]);
        BPlatformCommandScript.println("  -?            same as -usage", new Object[0]);
        BPlatformCommandScript.println("  -help         same as -usage", new Object[0]);
        BPlatformCommandScript.println("  -locale:<x>   set the default locale (en_US)", new Object[0]);
        BPlatformCommandScript.println("  -@<option>    pass option to Java VM", new Object[0]);
        BPlatformCommandScript.println("  -buildreg     force rebuild of the registry", new Object[0]);
        BPlatformCommandScript.println("", new Object[0]);
    }

    public void help() {
        BPlatformCommandScript.println("Script commands:", new Object[0]);
        BPlatformCommandScript.println("  quit", new Object[0]);
        BPlatformCommandScript.println("    Quit this program", new Object[0]);
        BPlatformCommandScript.println("  help", new Object[0]);
        BPlatformCommandScript.println("    Display this help message", new Object[0]);
        BPlatformCommandScript.println("  option -<optName>:<optVal>*", new Object[0]);
        BPlatformCommandScript.println("    Set the default value for the given command option(s)", new Object[0]);
        BPlatformCommandScript.println("  removeopt -<optName>", new Object[0]);
        BPlatformCommandScript.println("    Remove a default option value previously set with 'option'", new Object[0]);
        BPlatformCommandScript.println("  showoptions", new Object[0]);
        BPlatformCommandScript.println("    Show all default option values", new Object[0]);
        BPlatformCommandScript.println("  <command> <commandopts>", new Object[0]);
        BPlatformCommandScript.println("    Execute one of the platform commands listed below", new Object[0]);
        BPlatformCommandScript.println("Platform commands:", new Object[0]);
        BPlat.commands();
    }

    @Override
    public int invoke(CommandLineArguments args) throws Exception {
        String line;
        BufferedReader in;
        boolean prompt = false;
        boolean echo = args.hasOption("echo");
        if (args.hasHelpOption()) {
            this.usage();
            return 0;
        }
        if (args.hasOption("f")) {
            BIFile file = BFileSystem.INSTANCE.findFile(new FilePath(args.getOption("f")));
            if (file == null) {
                System.out.println("File not found");
                return 1;
            }
            in = new BufferedReader(new InputStreamReader(file.getInputStream()));
        } else {
            in = new BufferedReader(new InputStreamReader(System.in));
            prompt = true;
        }
        HashMap<String, String> defaultArgs = new HashMap<String, String>();
        for (int i = 0; i < args.options.length; ++i) {
            if (args.options[i].equals("f")) continue;
            defaultArgs.put(args.options[i], args.optionValues[i]);
        }
        if (prompt) {
            System.out.println("Type 'quit' to exit, 'help' for instructions");
            System.out.print("> ");
        }
        while ((line = in.readLine()) != null) {
            if (echo) {
                System.out.println(line);
            }
            line = line.trim();
            CommandLineArguments parsed = new CommandLineArguments(TextUtil.splitAndTrim((String)line, (char)' '));
            while (parsed.parameters.length == 0 || parsed.parameters[0].equals("plat")) {
                if (parsed.parameters.length <= 0) continue;
                line = line.substring(5).trim();
                parsed = new CommandLineArguments(TextUtil.splitAndTrim((String)line, (char)' '));
            }
            if (parsed.parameters[0].trim().length() == 0) {
                if (parsed.options.length > 0) {
                    this.help();
                }
                if (!prompt) continue;
                System.out.print("> ");
                continue;
            }
            if (parsed.parameters[0].equals("quit")) break;
            if (parsed.parameters[0].equals("help")) {
                this.help();
                if (!prompt) continue;
                System.out.print("> ");
                continue;
            }
            if (parsed.parameters[0].equals("option")) {
                for (int i = 0; i < parsed.options.length; ++i) {
                    defaultArgs.put(parsed.options[i], parsed.optionValues[i]);
                }
                if (!prompt) continue;
                System.out.print("> ");
                continue;
            }
            if (parsed.parameters[0].equals("removeopt")) {
                for (int i = 0; i < parsed.options.length; ++i) {
                    defaultArgs.remove(parsed.options[i]);
                }
                if (!prompt) continue;
                System.out.print("> ");
                continue;
            }
            if (parsed.parameters[0].equals("showoptions")) {
                System.out.println("Default options:");
                for (String key : defaultArgs.keySet()) {
                    System.out.println("  " + key + ":" + (String)defaultArgs.get(key));
                }
                if (!prompt) continue;
                System.out.print("> ");
                continue;
            }
            for (String key : defaultArgs.keySet()) {
                if (parsed.hasOption(key)) continue;
                line = line + " -" + key + ":" + (String)defaultArgs.get(key);
            }
            BPlat.parse(line);
            if (!prompt) continue;
            System.out.print("> ");
        }
        in.close();
        return 0;
    }
}

