/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.command;

import com.tridium.platform.command.BIPlatformCommand;
import com.tridium.sys.Nre;
import com.tridium.util.CommandLineArguments;
import java.util.TreeSet;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPlat
extends BObject {
    public static final Type TYPE = Sys.loadType(BPlat.class);
    private static BIPlatformCommand[] licensedCommands = null;

    public Type getType() {
        return TYPE;
    }

    public static void commands() {
        BIPlatformCommand[] commands = BPlat.getLicensedCommands();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].includeInCommandListing()) continue;
            BPlat.println("  " + commands[i].getCommandName());
            BPlat.println("    " + commands[i].getCommandDescription());
        }
        BPlat.println("  installdaemon");
        BPlat.println("    install the Niagara Platform service (Windows only)");
        BPlat.println("  uninstalldaemon");
        BPlat.println("    remove the Niagara Platform service (Windows only)");
        BPlat.println("  stopdaemon");
        BPlat.println("    stop the Niagara Platform service (Windows only)");
        BPlat.println("  restartdaemon");
        BPlat.println("    restart the Niagara Platform service (Windows only)");
    }

    public static void usage() {
        if (Nre.args.parameters.length < 2) {
            BPlat.showUsage();
            return;
        }
        BIPlatformCommand[] commands = BPlat.getLicensedCommands();
        for (int i = 0; i < commands.length; ++i) {
            if (!Nre.args.parameters[1].equals(commands[i].getCommandName())) continue;
            commands[i].usage();
            return;
        }
        BPlat.showUsage();
    }

    private static void showUsage() {
        BPlat.println("");
        BPlat.println("usage:");
        BPlat.println("  plat <command> <flags> <command-flags>");
        BPlat.println("commands:");
        BPlat.commands();
        BPlat.println("optional flags:");
        BPlat.println("  -usage        plat -usage prints this message");
        BPlat.println("                  plat <command> -usage prints command");
        BPlat.println("                  specific usage");
        BPlat.println("  -?            same as -usage");
        BPlat.println("  -help         same as -usage");
        BPlat.println("  -locale:<x>   set the default locale (en_US)");
        BPlat.println("  -@<option>    pass option to Java VM");
        BPlat.println("  -buildreg     force rebuild of the registry");
        BPlat.println("");
    }

    private static BIPlatformCommand[] getLicensedCommands() {
        if (licensedCommands == null) {
            TreeSet<BIPlatformCommand> resultSet = new TreeSet<BIPlatformCommand>((o1, o2) -> o1.getCommandName().compareTo(o2.getCommandName()));
            TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BIPlatformCommand.TYPE.getTypeInfo());
            for (int i = 0; i < types.length; ++i) {
                BIPlatformCommand instance = (BIPlatformCommand)types[i].getInstance();
                try {
                    if (instance.getLicenseVendor() != null && instance.getLicenseFeature() != null) {
                        Sys.getLicenseManager().checkFeature(instance.getLicenseVendor(), instance.getLicenseFeature());
                    }
                    resultSet.add(instance);
                    continue;
                }
                catch (FeatureNotLicensedException | LicenseDatabaseException throwable) {
                    // empty catch block
                }
            }
            licensedCommands = new BIPlatformCommand[resultSet.size()];
            resultSet.toArray(licensedCommands);
        }
        return licensedCommands;
    }

    public static int parse(String commandLine) {
        return BPlat.parse(TextUtil.splitAndTrim((String)commandLine, (char)' '));
    }

    public static int parse(String[] args) {
        try {
            if (args.length == 0) {
                BPlat.showUsage();
                return 2;
            }
            BIPlatformCommand[] commands = BPlat.getLicensedCommands();
            for (int i = 0; i < commands.length; ++i) {
                if (!args[0].equals(commands[i].getCommandName())) continue;
                String[] sendArgs = new String[args.length - 1];
                System.arraycopy(args, 1, sendArgs, 0, args.length - 1);
                return commands[i].invoke(new CommandLineArguments(sendArgs));
            }
            BPlat.showUsage();
            return 2;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] args) {
        BPlat.parse(args);
    }

    static void println(String s) {
        System.out.println(s);
    }
}

