/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BNavContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BSessionNavNode
extends BNavContainer {
    public static final Type TYPE = Sys.loadType(BSessionNavNode.class);
    private BISession session;
    private Type viewType;
    private Lexicon lexicon;

    public Type getType() {
        return TYPE;
    }

    public BSessionNavNode(BISession session, Type viewType) {
        super(viewType.getModule().getLexicon().get(viewType.getTypeName() + ".navName", viewType.getTypeName()));
        this.session = session;
        this.lexicon = viewType.getModule().getLexicon();
        this.viewType = viewType;
    }

    public BISession getNavSession() {
        return this.session;
    }

    public Type getViewType() {
        return this.viewType;
    }

    public BOrd getNavOrd() {
        return BOrd.make((BOrd)this.session.getNavOrd(), (OrdQuery)new ViewQuery(this.getViewType().toString()));
    }

    public BIcon getNavIcon() {
        return this.viewType.getTypeInfo().getIcon(null);
    }

    public String getNavDisplayName(Context cx) {
        return this.viewType.getTypeInfo().getDisplayName(cx);
    }

    public String getNavDescription(Context cx) {
        String text = this.lexicon.get(this.viewType.getTypeName() + ".viewDesc");
        return text == null ? "" : text;
    }
}

