/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.util.ArrayUtil;
import com.tridium.util.CertAliasCasePropertyValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="sslLicensed", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sslEnabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sslOnly", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sslEnabledStateReadonly", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="sslPort", type="int", defaultValue="BPlatformSSLSettings.DEFAULT_SSL_PORT", flags=3), @NiagaraProperty(name="keyAlias", type="String", defaultValue="tridium", flags=3), @NiagaraProperty(name="sslAlgType", type="BSslTlsEnum", defaultValue="BSslTlsEnum.make(BSslTlsEnum.TLSV_1)", flags=3), @NiagaraProperty(name="tlsCipherSuiteGroup", type="BTlsCipherSuiteGroup", defaultValue="BTlsCipherSuiteGroup.recommended", flags=3), @NiagaraProperty(name="fipsMode", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="useExtendedMasterSecret", type="String", defaultValue="\"true\"", flags=3)})
public class BPlatformSSLSettings
extends BComponent {
    public static final int DEFAULT_SSL_PORT = 5011;
    public static final Property sslLicensed = BPlatformSSLSettings.newProperty((int)3, (boolean)false, null);
    public static final Property sslEnabled = BPlatformSSLSettings.newProperty((int)3, (boolean)false, null);
    public static final Property sslOnly = BPlatformSSLSettings.newProperty((int)3, (boolean)false, null);
    public static final Property sslEnabledStateReadonly = BPlatformSSLSettings.newProperty((int)3, (boolean)false, null);
    public static final Property sslPort = BPlatformSSLSettings.newProperty((int)3, (int)5011, null);
    public static final Property keyAlias = BPlatformSSLSettings.newProperty((int)3, (String)"tridium", null);
    public static final Property sslAlgType = BPlatformSSLSettings.newProperty((int)3, (BValue)BSslTlsEnum.make((int)1), null);
    public static final Property tlsCipherSuiteGroup = BPlatformSSLSettings.newProperty((int)3, (BValue)BTlsCipherSuiteGroup.recommended, null);
    public static final Property fipsMode = BPlatformSSLSettings.newProperty((int)3, (boolean)false, null);
    public static final Property useExtendedMasterSecret = BPlatformSSLSettings.newProperty((int)3, (String)"true", null);
    public static final Type TYPE = Sys.loadType(BPlatformSSLSettings.class);
    private List<String> aliases = null;
    private CertAliasCasePropertyValidator validator = new CertAliasCasePropertyValidator(keyAlias.getName());

    public boolean getSslLicensed() {
        return this.getBoolean(sslLicensed);
    }

    public void setSslLicensed(boolean v) {
        this.setBoolean(sslLicensed, v, null);
    }

    public boolean getSslEnabled() {
        return this.getBoolean(sslEnabled);
    }

    public void setSslEnabled(boolean v) {
        this.setBoolean(sslEnabled, v, null);
    }

    public boolean getSslOnly() {
        return this.getBoolean(sslOnly);
    }

    public void setSslOnly(boolean v) {
        this.setBoolean(sslOnly, v, null);
    }

    public boolean getSslEnabledStateReadonly() {
        return this.getBoolean(sslEnabledStateReadonly);
    }

    public void setSslEnabledStateReadonly(boolean v) {
        this.setBoolean(sslEnabledStateReadonly, v, null);
    }

    public int getSslPort() {
        return this.getInt(sslPort);
    }

    public void setSslPort(int v) {
        this.setInt(sslPort, v, null);
    }

    public String getKeyAlias() {
        return this.getString(keyAlias);
    }

    public void setKeyAlias(String v) {
        this.setString(keyAlias, v, null);
    }

    public BSslTlsEnum getSslAlgType() {
        return (BSslTlsEnum)this.get(sslAlgType);
    }

    public void setSslAlgType(BSslTlsEnum v) {
        this.set(sslAlgType, (BValue)v, null);
    }

    public BTlsCipherSuiteGroup getTlsCipherSuiteGroup() {
        return (BTlsCipherSuiteGroup)this.get(tlsCipherSuiteGroup);
    }

    public void setTlsCipherSuiteGroup(BTlsCipherSuiteGroup v) {
        this.set(tlsCipherSuiteGroup, (BValue)v, null);
    }

    public boolean getFipsMode() {
        return this.getBoolean(fipsMode);
    }

    public void setFipsMode(boolean v) {
        this.setBoolean(fipsMode, v, null);
    }

    public String getUseExtendedMasterSecret() {
        return this.getString(useExtendedMasterSecret);
    }

    public void setUseExtendedMasterSecret(String v) {
        this.setString(useExtendedMasterSecret, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPlatformSSLSettings() {
    }

    public BPlatformSSLSettings(BPlatformSSLSettings settings) {
        this.setSslLicensed(settings.getSslLicensed());
        this.setSslEnabled(settings.getSslEnabled());
        this.setSslOnly(settings.getSslOnly());
        this.setSslEnabledStateReadonly(settings.getSslEnabledStateReadonly());
        this.setSslPort(settings.getSslPort());
        this.setKeyAlias(settings.getKeyAlias().toLowerCase(Locale.ENGLISH));
        this.setSslAlgType(settings.getSslAlgType());
        this.setFipsMode(settings.getFipsMode());
        this.setTlsCipherSuiteGroup(settings.getTlsCipherSuiteGroup());
        this.setUseExtendedMasterSecret(settings.getUseExtendedMasterSecret());
    }

    public void updateFromXml(XElem sslSupported) {
        this.setSslLicensed(this.getB(sslSupported, "sslLicensed", "true"));
        this.setSslEnabled(this.getB(sslSupported, "sslEnabled"));
        this.setSslOnly(this.getB(sslSupported, "sslOnly"));
        this.setSslEnabledStateReadonly(this.getB(sslSupported, "sslEnabledStateReadonly", "false"));
        this.setSslPort(sslSupported.geti("sslPort"));
        this.setKeyAlias(sslSupported.get("keyAlias").toLowerCase(Locale.ENGLISH));
        this.setFipsMode(this.getB(sslSupported, "fipsMode", "false"));
        this.setUseExtendedMasterSecret(sslSupported.get("tlsUseExtendedMasterSecret", "unsupported"));
        String group = sslSupported.get("tlsCipherSuiteGroup", TlsCipherSuiteGroup.recommended.name());
        try {
            this.setTlsCipherSuiteGroup(BTlsCipherSuiteGroup.make((String)group));
        }
        catch (Exception e) {
            this.setTlsCipherSuiteGroup(BTlsCipherSuiteGroup.recommended);
        }
        String type = sslSupported.get("sslAlgType");
        if (type != null) {
            type = type.toLowerCase();
        }
        if ("sslv3".equals(type) || "sslv3andtlsv1".equals(type)) {
            this.setSslAlgType(BSslTlsEnum.make((String)"tlsv1"));
        } else {
            this.setSslAlgType(BSslTlsEnum.make((String)type));
        }
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        for (int i = 0; i < aliases.size(); ++i) {
            String alias = aliases.get(i);
            if (alias == null || alias.equals(alias.toLowerCase(Locale.ENGLISH))) continue;
            alias = alias.toLowerCase(Locale.ENGLISH);
            aliases.set(i, alias);
        }
        this.aliases = aliases;
    }

    private boolean getB(XElem elem, String property) {
        return this.getB(elem, property, "false");
    }

    private boolean getB(XElem elem, String property, String defaultValue) {
        return Boolean.valueOf(elem.get(property, defaultValue));
    }

    public void loadAliases(XElem aliasesElem) {
        XElem[] keys = aliasesElem.elems("key");
        ArrayList<String> aliases = new ArrayList<String>(keys.length);
        for (XElem key : keys) {
            aliases.add(key.get("alias"));
        }
        this.setAliases(aliases);
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (ArrayUtil.indexOf((Object[])properties, (Object)keyAlias) > -1) {
            return this.validator;
        }
        return super.getPropertyValidator(properties, context);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (keyAlias.equals(property)) {
            return this.validator;
        }
        return super.getPropertyValidator(property, context);
    }
}

