/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BPart;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BVmPart
extends BPart {
    public static final Property unspecified = BVmPart.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BVmPart.class);
    private static final BIcon icon = BPart.getPartTypeIcon(TYPE);

    public boolean getUnspecified() {
        return this.getBoolean(unspecified);
    }

    public void setUnspecified(boolean v) {
        this.setBoolean(unspecified, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BVmPart() {
        this.setPartName(this.getLexicon().getText("unspecifiedVm.vmName"));
        this.setUnspecified(true);
    }

    public BVmPart(String pName, BVersion pVersion, BInstallable pInstallable) {
        this.setVersion(pVersion);
        if (pName == null || pName.indexOf("Undetermined") != -1) {
            this.setPartName(this.getLexicon().getText("unspecifiedVm.vmName"));
            this.setUnspecified(true);
        } else {
            this.setPartName(pName);
            this.setUnspecified(false);
        }
        this.setInstallable(pInstallable);
    }

    @Override
    public boolean meets(BDependency depend) {
        return depend.getPartType().is(TYPE) && this.getVersion().meets(depend) && this.matchesName(depend.getPartName());
    }

    public static BPart make(XElem elem) {
        return BVmPart.make(elem, null);
    }

    public static BPart make(XElem elem, BInstallable pInstallable) {
        if (elem == null) {
            return null;
        }
        if (elem.name().equals("vm")) {
            return new BVmPart(elem.get("name", null), new BVersion(elem.get("vendor", ""), BVmPart.getVendorVersion(elem)), pInstallable);
        }
        return null;
    }

    @Override
    public XElem getXml() {
        XElem result = new XElem("vm");
        result.setAttr("name", this.getPartName());
        if (this.getVersion().getVendor().trim().length() > 0) {
            result.setAttr("vendor", this.getVersion().getVendor());
        }
        if (this.getVersion().getBajaVersionString().trim().length() > 0) {
            result.setAttr("bajaVersion", this.getVersion().getBajaVersionString());
        }
        if (this.getVersion().getVendorVersionString().trim().length() > 0) {
            result.setAttr("version", this.getVersion().getVendorVersionString());
        }
        if (this.getDescription().trim().length() > 0) {
            result.setAttr("description", this.getDescription());
        }
        return result;
    }

    public String toString(Context context) {
        return "VM Part: " + this.getPartName() + " " + (Object)((Object)this.getVersion());
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public boolean isNull() {
        return this.getPartName().equals("nullvm");
    }

    public static BVmPart makeNull() {
        return new BVmPart("nullvm", BVersion.makeZero(), null);
    }
}

