/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BPart;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BNrePart
extends BPart {
    public static final Type TYPE = Sys.loadType(BNrePart.class);
    private static final BIcon icon = BPart.getPartTypeIcon(TYPE);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNrePart() {
    }

    public BNrePart(String pName, String pDescription, BVersion pVersion, BInstallable pInstallable) {
        this.setPartName(pName);
        this.setDescription(pDescription);
        this.setVersion(pVersion);
        this.setInstallable(pInstallable);
    }

    @Override
    public boolean meets(BDependency depend) {
        return depend.getPartType().is(TYPE) && this.getVersion().meets(depend) && this.matchesName(depend.getPartName());
    }

    public static BPart make(XElem elem) {
        return BNrePart.make(elem, null);
    }

    public static BPart make(XElem elem, BInstallable installable) {
        if (elem == null) {
            return null;
        }
        if (elem.name().equals("nre")) {
            return new BNrePart(elem.get("name", ""), elem.get("description", elem.get("desc", "")), new BVersion(elem.get("bajaVersion", ""), BNrePart.getVendorVersion(elem)), installable);
        }
        return null;
    }

    @Override
    public XElem getXml() {
        XElem result = new XElem("nre");
        result.setAttr("name", this.getPartName());
        if (this.getVersion().getVendor().trim().length() > 0) {
            result.setAttr("vendor", this.getVersion().getVendor());
        }
        if (this.getVersion().getBajaVersionString().trim().length() > 0) {
            result.setAttr("bajaVersion", this.getVersion().getBajaVersionString());
        }
        if (this.getVersion().getVendorVersionString().trim().length() > 0) {
            result.setAttr("version", this.getVersion().getVendorVersionString());
        }
        if (this.getDescription().trim().length() > 0) {
            result.setAttr("description", this.getDescription());
        }
        return result;
    }

    public String toString(Context context) {
        return "Nre Part: " + this.getPartName() + " " + (Object)((Object)this.getVersion());
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public boolean isNull() {
        return this.getPartName().equals("nullnre");
    }

    public static BNrePart makeNull() {
        return new BNrePart("nullnre", "", BVersion.makeZero(), null);
    }

    public BIcon getIcon() {
        return icon;
    }
}

