/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BPart;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BModelPart
extends BPart {
    public static final Type TYPE = Sys.loadType(BModelPart.class);
    private static final BIcon icon = BPart.getPartTypeIcon(TYPE);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BModelPart() {
    }

    public BModelPart(String pName, String pDescription, BVersion pVersion, BInstallable pInstallable) {
        this.setPartName(pName);
        this.setDescription(pDescription);
        this.setVersion(pVersion);
        this.setInstallable(pInstallable);
    }

    @Override
    public boolean meets(BDependency depend) {
        return !this.isNull() && (depend.getPartType().is(TYPE) || depend.getPartType().is(BGenericPart.TYPE)) && this.matchesName(depend.getPartName());
    }

    public static BPart make(XElem elem) {
        return BModelPart.make(elem, null);
    }

    public static BPart make(XElem elem, BInstallable installable) {
        if (elem == null) {
            return null;
        }
        if (elem.name().equals("model")) {
            return new BModelPart(elem.get("name"), elem.get("description", elem.get("desc", "")), new BVersion("", BModelPart.getVendorVersion(elem)), installable);
        }
        return null;
    }

    public String toString(Context context) {
        return "Model Part: " + this.getPartName() + " " + (Object)((Object)this.getVersion());
    }

    public boolean isNull() {
        return this.getPartName().equals("");
    }

    public static BModelPart makeNull() {
        return new BModelPart("", "", BVersion.makeZero(), null);
    }

    public BIcon getIcon() {
        return icon;
    }
}

