/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BModuleStatus;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.module.AxModuleContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class ModuleManifest {
    private XElem moduleElement = null;
    private List<XElem> types = new ArrayList<XElem>();
    private List<XElem> unknownElements = new ArrayList<XElem>();
    private Map<String, BDependency> dependencyByName = new HashMap<String, BDependency>();
    private Map<RuntimeProfile, String> relatedModuleParts = new HashMap<RuntimeProfile, String>();
    private Map<String, BModuleContent> moduleContentByPath = new HashMap<String, BModuleContent>();
    private XElem exclElement = null;
    private BModuleStatus status = null;
    private boolean noRunningStation = false;

    private ModuleManifest(XElem manifestDom) {
        if (!this.loadManifestHeader(manifestDom)) {
            return;
        }
        try {
            block16: for (XElem manifestElem : manifestDom.elems()) {
                switch (manifestElem.name()) {
                    case "dirs": {
                        for (XElem dir : manifestElem.elems("dir")) {
                            this.moduleContentByPath.put(dir.get("name"), BModuleContent.make(dir.get("install", "doc")));
                        }
                        continue block16;
                    }
                    case "dependencies": {
                        for (XElem dep : manifestElem.elems("dependency")) {
                            this.dependencyByName.put(dep.get("name"), BDependency.make(dep));
                        }
                        continue block16;
                    }
                    case "moduleParts": {
                        for (XElem modulePartElem : manifestElem.elems("modulePart")) {
                            this.relatedModuleParts.put(RuntimeProfile.valueOf((String)modulePartElem.get("runtimeProfile")), modulePartElem.get("name"));
                        }
                        continue block16;
                    }
                    case "types": {
                        Collections.addAll(this.types, manifestElem.elems("type"));
                        continue block16;
                    }
                    case "installation": {
                        this.noRunningStation = manifestElem.getb("noRunningStation", this.getModuleName().equals("baja"));
                        XElem depsRoot = manifestElem.elem("dependencies");
                        this.exclElement = manifestElem.elem("exclusions");
                        if (depsRoot == null) continue block16;
                        for (XElem depElem : depsRoot.elems()) {
                            BDependency dep = BDependency.make(depElem);
                            if (dep == null) continue;
                            if (dep.getPartName().startsWith("nre-core") && depElem.get("solvers", null) == null) {
                                dep.setSolverFiltersString("commissioning");
                            }
                            this.dependencyByName.put(dep.getPartName(), dep);
                        }
                        continue block16;
                    }
                    default: {
                        this.unknownElements.add(manifestElem);
                    }
                }
            }
            this.status = BModuleStatus.ok;
        }
        catch (Exception e) {
            this.status = BModuleStatus.corrupt;
        }
    }

    private ModuleManifest(XElem moduleElem, XParser parser) throws Exception {
        if (this.loadManifestHeader(moduleElem)) {
            while (parser.next() != -1) {
                if (parser.type() != 1) continue;
                if (parser.elem().name().equals("dir")) {
                    this.moduleContentByPath.put(parser.elem().get("name"), BModuleContent.make(parser.elem().get("install", "doc")));
                    continue;
                }
                if (parser.elem().name().equals("dependency")) {
                    this.dependencyByName.put(parser.elem().get("name"), BDependency.make(parser.elem()));
                    continue;
                }
                if (parser.elem().name().equals("modulePart")) {
                    this.relatedModuleParts.put(RuntimeProfile.valueOf((String)parser.elem().get("runtimeProfile")), parser.elem().get("name"));
                    continue;
                }
                if (parser.elem().name().equals("exclusions")) {
                    this.exclElement = parser.parseCurrent(false);
                    continue;
                }
                if (parser.depth() > 1 && parser.elem(parser.depth() - 2).name().equals("dependencies")) {
                    BDependency dep = BDependency.make(parser.elem());
                    if (dep == null) continue;
                    if (dep.getPartName().startsWith("nre-core") && parser.elem().get("solvers", null) == null) {
                        dep.setSolverFiltersString("commissioning");
                    }
                    this.dependencyByName.put(dep.getPartName(), dep);
                    continue;
                }
                if (parser.elem().name().equals("type")) {
                    this.types.add(parser.parseCurrent(false));
                    continue;
                }
                if (parser.elem().name().equals("installation")) {
                    this.noRunningStation = parser.elem().getb("noRunningStation", this.getModuleName().equals("baja"));
                    continue;
                }
                if (parser.elem().name().equals("types") || parser.elem().name().equals("dependencies") || parser.elem().name().equals("moduleParts") || parser.elem().name().equals("dirs") || parser.depth() != 2) continue;
                this.unknownElements.add(parser.parseCurrent(false));
            }
            this.status = BModuleStatus.ok;
        }
    }

    private ModuleManifest(BModuleStatus status) {
        this.status = status;
    }

    public static ModuleManifest make(XElem moduleElement) {
        return moduleElement == null ? null : new ModuleManifest(moduleElement);
    }

    public static ModuleManifest make(InputStream manifestStream) {
        return ModuleManifest.make(manifestStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModuleManifest make(InputStream manifestStream, boolean closeStream) {
        try {
            XParser parser = XParser.make((InputStream)manifestStream);
            if (parser.next() == -1) {
                ModuleManifest moduleManifest = new ModuleManifest(BModuleStatus.corrupt);
                return moduleManifest;
            }
            if (parser.type() == 1 && parser.elem().name().equals("module")) {
                ModuleManifest moduleManifest = new ModuleManifest(parser.elem(), parser);
                return moduleManifest;
            }
            ModuleManifest moduleManifest = new ModuleManifest(BModuleStatus.corrupt);
            return moduleManifest;
        }
        catch (Exception e) {
            ModuleManifest moduleManifest = new ModuleManifest(BModuleStatus.corrupt);
            return moduleManifest;
        }
        finally {
            if (closeStream) {
                try {
                    manifestStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void write(OutputStream out) throws Exception {
        this.write(this.getModuleContent(), out);
    }

    /*
     * WARNING - void declaration
     */
    public void write(BModuleContent outContent, OutputStream outStream) {
        try {
            void var9_14;
            XWriter out = new XWriter(outStream);
            out.prolog();
            XElem moduleElemCopy = this.moduleElement.copy();
            moduleElemCopy.addAttr("archiveDate", String.valueOf(new Date()));
            moduleElemCopy.addAttr("archiveInstall", outContent.getTag());
            try {
                moduleElemCopy.addAttr("archiveHost", Sys.getHostName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            XElem dependElem = new XElem("dependencies");
            XElem installElem = null;
            XElem installDependElem = null;
            for (BDependency bDependency : this.dependencyByName.values()) {
                try {
                    if (bDependency.getPartTypeSpec().equals((Object)BModulePart.TYPE.getTypeSpec())) {
                        dependElem.addContent((XContent)bDependency.getXml());
                        continue;
                    }
                    if (installElem == null) {
                        installElem = new XElem("installation");
                    }
                    if (installDependElem == null) {
                        installDependElem = new XElem("dependencies");
                        installElem.addContent((XContent)installDependElem);
                    }
                    installDependElem.addContent((XContent)bDependency.getXml());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            moduleElemCopy.addContent((XContent)dependElem);
            if (this.noRunningStation) {
                if (installElem == null) {
                    installElem = new XElem("installation");
                }
                installElem.addAttr("noRunningStation", "true");
            }
            if (this.exclElement != null) {
                if (installElem == null) {
                    installElem = new XElem("installation");
                }
                installElem.addContent((XContent)this.exclElement.copy());
            }
            if (installElem != null) {
                moduleElemCopy.addContent((XContent)installElem);
            }
            XElem dirsElem = null;
            for (String dirPath : this.moduleContentByPath.keySet()) {
                try {
                    BModuleContent dirFlag = this.moduleContentByPath.get(dirPath);
                    XElem dirElem = new XElem("dir");
                    dirElem.addAttr("name", dirPath);
                    dirElem.addAttr("install", dirFlag.getTag());
                    if (outContent.getOrdinal() < dirFlag.getOrdinal()) {
                        dirElem.addAttr("stripped", "true");
                    }
                    if (dirsElem == null) {
                        dirsElem = new XElem("dirs");
                    }
                    dirsElem.addContent((XContent)dirElem);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (dirsElem != null) {
                moduleElemCopy.addContent(dirsElem);
            }
            Object var9_13 = null;
            for (XElem typeData : this.types) {
                String classPath = typeData.get("class").replace('.', '/');
                if (!this.includePath(classPath = classPath.substring(0, classPath.lastIndexOf(47)), outContent)) continue;
                if (var9_14 == null) {
                    XElem xElem = new XElem("types");
                }
                var9_14.addContent((XContent)typeData.copy());
            }
            if (var9_14 != null) {
                moduleElemCopy.addContent((XContent)var9_14);
            }
            this.unknownElements.forEach(elem -> moduleElemCopy.addContent((XContent)elem.copy()));
            moduleElemCopy.write(out);
            out.flush();
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("platform", "ModulePart.exception.writeXml", (Throwable)e);
        }
    }

    public int getManifestSchemaVersion() {
        return this.moduleElement.get("runtimeProfile", null) == null || this.moduleElement.get("moduleName", null) == null ? 3 : 4;
    }

    public String getArchiveDate() {
        return this.moduleElement.get("archiveDate", "");
    }

    public String getArchiveHost() {
        return this.moduleElement.get("archiveHost", "");
    }

    public BAbsTime getBuildAbsTime() {
        String value = this.moduleElement.get("buildMillis", null);
        if (value == null) {
            return BAbsTime.NULL;
        }
        long millis = Long.parseLong(value);
        return BAbsTime.make((long)millis);
    }

    public String getBuildDate() {
        return this.moduleElement.get("buildDate", "");
    }

    public String getBuildHost() {
        return this.moduleElement.get("buildHost", "");
    }

    public BDependency[] getDependencies() {
        return this.dependencyByName.values().toArray(new BDependency[this.dependencyByName.size()]);
    }

    public BDependency getDependency(String targetModulePartName) {
        return this.dependencyByName.get(targetModulePartName);
    }

    public String getDescription() {
        return this.moduleElement.get("description", "");
    }

    public BDependency[] getExclusions() {
        if (this.exclElement == null) {
            return new BDependency[0];
        }
        XElem[] elems = this.exclElement.elems();
        ArrayList<BDependency> result = new ArrayList<BDependency>();
        for (XElem elem : elems) {
            BDependency d = BDependency.make(elem);
            if (d == null) continue;
            result.add(d);
        }
        return result.toArray(new BDependency[result.size()]);
    }

    public BModuleContent getModuleContent() {
        return BModuleContent.make(this.moduleElement.get("archiveInstall", "doc"));
    }

    public BModuleContent getModuleContentForPath(String path) {
        return this.getModuleContentForPath(path, this.getModuleContent());
    }

    public BModuleContent getModuleContentForPath(String path, BModuleContent def) {
        return this.moduleContentByPath.containsKey(path) ? this.moduleContentByPath.get(path) : def;
    }

    public String getModuleName() {
        return this.moduleElement.get("moduleName", this.getModulePartName());
    }

    public String getModulePartName() {
        return this.moduleElement.get("name");
    }

    public RuntimeProfile getRuntimeProfile() {
        RuntimeProfile manifestProfile = RuntimeProfile.valueOf((String)this.moduleElement.get("runtimeProfile", null), null);
        if (manifestProfile == null) {
            return AxModuleContent.forModuleManifest((XElem)this.moduleElement).getEquivalentRuntimeProfile();
        }
        return manifestProfile;
    }

    public boolean isNiagaraAXModule() {
        return this.moduleElement.get("runtimeProfile", null) == null;
    }

    public Map<RuntimeProfile, String> getRelatedModulePartNames() {
        return new HashMap<RuntimeProfile, String>(this.relatedModuleParts);
    }

    public Optional<Long> getReleaseDate() {
        return LicenseUtil.getDateAttributeValue((XElem)this.moduleElement, (String)"releaseDate", (boolean)true);
    }

    public void setReleaseDate(Optional<Long> value) {
        if (value.isPresent()) {
            this.moduleElement.setAttr("releaseDate", LicenseUtil.formatDate((long)value.get()));
        } else {
            this.moduleElement.removeAttr("releaseDate");
        }
    }

    public String getPreferredSymbol() {
        return this.moduleElement.get("preferredSymbol", "");
    }

    public BModuleStatus getStatus() {
        return this.status;
    }

    public BVersion getVersion() {
        return new BVersion(this.moduleElement.get("vendor", ""), this.moduleElement.get("vendorVersion", this.moduleElement.get("version", "0")));
    }

    public boolean includePath(String path, BModuleContent flag) {
        BModuleContent pathFlag = path.startsWith("doc/") ? BModuleContent.doc : this.getModuleContentForPath(path, null);
        return pathFlag == null || flag.getOrdinal() >= pathFlag.getOrdinal();
    }

    public boolean noRunningStation() {
        return this.noRunningStation;
    }

    public void setNoRunningStation(boolean value) {
        this.noRunningStation = value;
    }

    public boolean isInstallable() {
        return this.moduleElement.getb("installable", true);
    }

    public boolean isNreModule() {
        return this.moduleElement.getb("nre", true) && this.isInstallable();
    }

    private boolean loadManifestHeader(XElem element) {
        if (!element.name().equals("module")) {
            this.status = BModuleStatus.misnamed;
            return false;
        }
        this.moduleElement = element.copy();
        this.moduleElement.clearContent();
        return true;
    }
}

