/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BundleManifest;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.nre.security.SecretChars;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridium.platform.tcpip.TcpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.file.BIFile;
import javax.baja.nre.util.Array;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.security.BIPasswordValidator;
import javax.baja.security.BPassword;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DistributionManifest
extends BundleManifest {
    private XElem platformBogElem = null;
    private XElem platformTcpIpElem = null;
    private XElem platformUsersElem = null;

    private DistributionManifest(XElem rootElem) throws Exception {
        super(rootElem);
        this.platformBogElem = this.rootElem.elem("platform");
        this.platformTcpIpElem = this.rootElem.elem("tcpIpSettings");
        this.platformUsersElem = this.rootElem.elem("platformUsers");
    }

    private DistributionManifest() {
    }

    public static DistributionManifest make() {
        return new DistributionManifest();
    }

    public static DistributionManifest make(InputStream in) throws Exception {
        return DistributionManifest.make(in, true);
    }

    public static DistributionManifest make(InputStream in, boolean closeStream) throws Exception {
        return DistributionManifest.make(XParser.make((InputStream)in).parse(closeStream));
    }

    public static DistributionManifest make(XElem rootElem) throws Exception {
        return new DistributionManifest(rootElem);
    }

    public boolean isDaemonBinaryUpdateRequired() {
        return this.rootElem.getb("updateDaemonBinaries", false);
    }

    public void setDaemonBinaryUpdateRequired(boolean value) {
        this.rootElem.setAttr("updateDaemonBinaries", String.valueOf(value));
    }

    public boolean noRunningStation() {
        return this.noRunningApp() || this.rootElem.getb("noRunningStation", false);
    }

    public void setNoRunningStation(boolean value) {
        this.rootElem.setAttr("noRunningStation", String.valueOf(value));
    }

    public boolean noRunningApp() {
        return this.rootElem.getb("noRunningApp", this.rootElem.getb("noStation", false));
    }

    public void setNoRunningApp(boolean value) {
        this.rootElem.setAttr("noRunningApp", String.valueOf(value));
        this.rootElem.setAttr("noStation", String.valueOf(value));
    }

    public String getHostId() {
        return this.rootElem.get("hostId", null);
    }

    public void setHostId(String hostId) {
        if (hostId != null) {
            this.rootElem.setAttr("hostId", hostId);
        }
    }

    public boolean isOsUpdateRequired() {
        return this.rootElem.getb("osInstall", false);
    }

    public void setOsUpdateRequired(boolean value) {
        this.rootElem.setAttr("osInstall", String.valueOf(value));
    }

    public boolean isStandalone() {
        return this.rootElem.getb("standalone", false);
    }

    public void setIsStandalone(boolean value) {
        this.rootElem.setAttr("standalone", String.valueOf(value));
    }

    public boolean isRebootRequired() {
        return this.rootElem.getb("reboot", false);
    }

    public void setRebootRequired(boolean value) {
        this.rootElem.setAttr("reboot", String.valueOf(value));
    }

    public boolean ignoreDefaultExclusions() {
        return this.rootElem.getb("ignoreDefaultExclusions", false);
    }

    public void setIgnoreDefaultExclusions(boolean value) {
        this.rootElem.setAttr("ignoreDefaultExclusions", String.valueOf(value));
    }

    public void setTargetOs(BOsPart value) {
        this.setUseAbsoluteElementPaths(value.allowGlobalFileAccess());
    }

    public BModuleContent getUpdateModuleContent() {
        String tag = this.rootElem.get("setInstallFlag", null);
        if (tag == null) {
            return null;
        }
        return BModuleContent.make(tag);
    }

    public void setUpdateModuleContent(BModuleContent value) {
        this.rootElem.setAttr("setInstallFlag", value.getTag());
    }

    public void setNewOsTimeZone(BTimeZone value) throws Exception {
        if (value == null) {
            value = BTimeZone.NULL;
        }
        this.rootElem.setAttr("osTimeZone", value.encodeToString());
    }

    public String getUpdatedRuntimeProfilesEnabled() {
        return this.rootElem.get("runtimeProfilesEnabled", null);
    }

    public void setUpdatedRuntimeProfilesEnabled(String value) {
        this.rootElem.setAttr("runtimeProfilesEnabled", value);
    }

    public BTimeZone getNewOsTimeZone() {
        String encoded = this.rootElem.get("osTimeZone", null);
        if (encoded == null) {
            return BTimeZone.NULL;
        }
        try {
            return (BTimeZone)BTimeZone.DEFAULT.decodeFromString(encoded);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BTimeZone.NULL;
        }
    }

    @Override
    public BDependency[] getExclusions() {
        Array result = new Array(BDependency.class);
        result.addAll((Object[])super.getExclusions());
        if (!this.ignoreDefaultExclusions()) {
            BPart[] p = this.getProvidedParts(null);
            if (p.length > 0) {
                this.addDefaultOsExclusions(p[0], (Array<BDependency>)result);
                this.addDefaultNreCoreExclusions(p[0], (Array<BDependency>)result);
            }
            this.addDefaultNreConfigExclusions((Array<BDependency>)result);
        }
        return (BDependency[])result.trim();
    }

    protected void addDefaultOsExclusions(BPart part, Array<BDependency> accum) {
        if (part.getType().equals(BOsPart.TYPE)) {
            Version v = part.getVersion().getVendorVersion();
            if (part.getPartName().startsWith("qnx-jace") || part.getPartName().startsWith("tridium-qnx7")) {
                if (v.major() == 1) {
                    accum.add((Object)new BDependency(part.getPartName(), new BVersion(part.getVersion().getVendor(), "2.0"), part.getType().getTypeSpec()));
                } else if (v.size() >= 2) {
                    accum.add((Object)new BDependency(part.getPartName(), new BVersion(part.getVersion().getVendor(), v.major() + "." + (v.minor() + 1)), part.getType().getTypeSpec()));
                }
            } else if (v.size() >= 1) {
                accum.add((Object)new BDependency(part.getPartName(), new BVersion(part.getVersion().getVendor(), String.valueOf(v.major() + 1)), part.getType().getTypeSpec()));
            }
        }
    }

    protected void addDefaultNreCoreExclusions(BPart part, Array<BDependency> accum) {
        if (part.getType().equals(BNrePart.TYPE)) {
            Version v = part.getVersion().getVendorVersion();
            accum.add((Object)new BDependency("nre-core-*", new BVersion(part.getVersion().getVendor(), v.major() + "." + (v.minor() + 1)), part.getType().getTypeSpec()));
        }
    }

    protected void addDefaultNreConfigExclusions(Array<BDependency> accum) {
        if (this.getInstallableName().startsWith("nre-config")) {
            for (BDependency dependency : this.getDependencies()) {
                Version v;
                if (dependency.getPartTypeSpec().equals((Object)BOsPart.TYPE.getTypeSpec()) && dependency.getVersionRelation() != BVersionRelation.exact) {
                    v = dependency.getVersion().getVendorVersion();
                    if (!dependency.getPartName().startsWith("qnx-jace") && !dependency.getPartName().startsWith("tridium-qnx7")) continue;
                    if (v.major() == 1) {
                        accum.add((Object)new BDependency(dependency.getPartName(), new BVersion(dependency.getVersion().getVendor(), "2.0"), dependency.getPartTypeSpec()));
                        continue;
                    }
                    if (v.size() < 2) continue;
                    accum.add((Object)new BDependency(dependency.getPartName(), new BVersion(dependency.getVersion().getVendor(), v.major() + "." + (v.minor() + 1)), dependency.getPartTypeSpec()));
                    continue;
                }
                if (!dependency.getPartTypeSpec().equals((Object)BNrePart.TYPE.getTypeSpec()) || dependency.getVersionRelation() == BVersionRelation.exact) continue;
                v = dependency.getVersion().getVendorVersion();
                accum.add((Object)new BDependency("nre-core-*", new BVersion(dependency.getVersion().getVendor(), v.major() + "." + (v.minor() + 1)), dependency.getPartTypeSpec()));
            }
        }
    }

    public void setPBEEncodingInfo(PBEEncodingInfo encodingInfo) {
        this.rootElem.removeAttr("reversibleEncodingValidator");
        this.rootElem.removeAttr("reversibleEncodingIterationCount");
        this.rootElem.removeAttr("reversibleEncodingSalt");
        if (encodingInfo != null) {
            this.rootElem.addAttr("reversibleEncodingValidator", encodingInfo.getEncodedValidator());
            this.rootElem.addAttr("reversibleEncodingIterationCount", String.valueOf(encodingInfo.getEncodingIterationCount()));
            this.rootElem.addAttr("reversibleEncodingSalt", encodingInfo.getEncodingSaltHex());
        }
    }

    public BIPasswordValidator getReversibleEncodingValidator() throws IOException {
        String encodedResult = this.rootElem.get("reversibleEncodingValidator", null);
        return encodedResult == null ? null : (BPassword)BPassword.DEFAULT.decodeFromString(encodedResult);
    }

    public PBEEncodingInfo getPBEEncodingInfo() throws IOException {
        String encodedValidator = this.rootElem.get("reversibleEncodingValidator", null);
        String encodingSaltHex = this.rootElem.get("reversibleEncodingSalt", null);
        int iterationCount = this.rootElem.geti("reversibleEncodingIterationCount", -1);
        if (encodedValidator == null || encodingSaltHex == null || iterationCount < 0) {
            return null;
        }
        return new PBEEncodingInfo(encodedValidator, encodingSaltHex, iterationCount, CryptographicAlgorithmBundle.getInstance((String)"pbkdf2-sha256.1"));
    }

    public PBEEncodingKey makePBEKey(SecretChars passPhrase) throws IOException {
        PBEEncodingInfo encodingInfo = this.getPBEEncodingInfo();
        return encodingInfo == null ? null : encodingInfo.makePBEKey(passPhrase);
    }

    public Context makeEncodingContext(Context base, SecretChars passPhrase) throws IOException {
        PBEEncodingKey pbeKey = this.makePBEKey(passPhrase);
        return pbeKey == null ? base : PasswordEncodingContext.updateForExternal((Context)base, (ISecretBytesSupplier)pbeKey);
    }

    public XElem getPlatformXml() {
        return this.platformBogElem;
    }

    public void setPlatformXml(XElem value) {
        if (this.platformBogElem != null) {
            this.rootElem.removeContent((XContent)this.platformBogElem);
        }
        this.platformBogElem = value;
        this.rootElem.addContent((XContent)this.platformBogElem);
    }

    public void setPlatformBog(BIFile platformBogFile) throws Exception {
        this.setPlatformBog(platformBogFile, true);
    }

    public void setPlatformBog(BIFile platformBogFile, boolean merge) throws Exception {
        XElem elem = new XElem("platform");
        if (!merge) {
            elem.setAttr("merge", "false");
        }
        InputStream platformBogIn = platformBogFile.getInputStream();
        XElem platformBogElem = XParser.make((InputStream)platformBogIn).parse().elem(0);
        String moduleAttr = platformBogElem.get("m", null);
        String moduleSymbol = null;
        if (moduleAttr != null && moduleAttr.contains("=")) {
            moduleSymbol = moduleAttr.substring(0, moduleAttr.indexOf("=")) + ":";
        }
        for (XElem bogEntryOrig : platformBogElem.elems("p")) {
            String typeAttr;
            XElem bogEntry = bogEntryOrig.copy();
            if (moduleSymbol != null && (typeAttr = bogEntry.get("t", null)) != null && typeAttr.startsWith(moduleSymbol)) {
                bogEntry.addAttr("m", moduleAttr);
                moduleSymbol = null;
            }
            elem.addContent((XContent)bogEntry);
        }
        try {
            platformBogIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPlatformXml(elem);
    }

    public BTcpIpHostSettings getTcpIpSettings() {
        if (this.platformTcpIpElem == null) {
            return null;
        }
        BTcpIpHostSettings result = new BTcpIpHostSettings();
        TcpUtil.updateFields(result, this.platformTcpIpElem);
        return result;
    }

    public void setTcpIpSettings(BTcpIpHostSettings settings) throws Exception {
        if (this.platformTcpIpElem != null) {
            this.rootElem.removeContent((XContent)this.platformTcpIpElem);
        }
        if (settings == null) {
            this.platformTcpIpElem = null;
        } else if (!settings.getIsReadonly()) {
            this.platformTcpIpElem = TcpUtil.getHostSettingsXml(settings);
            this.rootElem.addContent((XContent)this.platformTcpIpElem);
        }
    }

    public void setStationTcpIpSettings() throws Exception {
        BTcpIpPlatformService platSvc = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        platSvc.poll();
        this.setTcpIpSettings(platSvc.getSettings());
    }

    public void setDaemonTcpIpSettings(BDaemonSession session) throws Exception {
        BTcpIpHostSettings ipSettings = new BTcpIpHostSettings();
        TcpUtil.loadFromSession(ipSettings, session);
        this.setTcpIpSettings(ipSettings);
    }

    public XElem getPlatformUsersXml() {
        return this.platformUsersElem;
    }

    public void setPlatformUsersXml(XElem value) {
        if (this.platformUsersElem != null) {
            this.rootElem.removeContent((XContent)this.platformUsersElem);
        }
        this.platformUsersElem = value;
        if (value != null) {
            this.rootElem.addContent((XContent)this.platformUsersElem);
        }
    }

    public void setPlatformUsers(BDaemonSession session) throws Exception {
        XElem[] remoteGroupElems;
        if (!session.getHostProperties().supportsServlet("acctmgt")) {
            this.setPlatformUsersXml(null);
            return;
        }
        boolean authReadonly = false;
        try {
            XElem authInfo = XParser.make((InputStream)session.getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null) {
                authReadonly = authElem.getb("readonly", false);
            }
        }
        catch (Exception authInfo) {
            // empty catch block
        }
        if (authReadonly) {
            this.setPlatformUsersXml(null);
            return;
        }
        ArrayList<UserAccount> adminUsers = new ArrayList<UserAccount>();
        XElem authenticationInfo = XParser.make((InputStream)session.getInputStream(new AuthenticationInfoMessage())).parse();
        XElem authElement = authenticationInfo.elem("auth");
        assert (authElement != null);
        XElem adminGroupElement = authElement.elem("admingroup");
        assert (adminGroupElement != null);
        String adminGroupName = NativeAccount.fullyQualifiedToUsername((String)adminGroupElement.get("name"));
        XElem accountInfo = XParser.make((InputStream)session.getInputStream(new AccountManagementMessage(true))).parse();
        for (XElem currentGroupElem : remoteGroupElems = accountInfo.elems("group")) {
            XElem[] adminUserElems;
            if (!adminGroupName.equals(NativeAccount.fullyQualifiedToUsername((String)currentGroupElem.get("name")))) continue;
            for (XElem adminUserElem : adminUserElems = currentGroupElem.elems("user")) {
                adminUsers.add(new UserAccount(adminUserElem.get("name"), adminUserElem.get("id", null), adminUserElem.get("description"), adminUserElem.get("passwordHash")));
            }
        }
        XElem result = new XElem("platformUsers");
        result.addAttr("adminGroup", adminGroupElement.get("name"));
        for (UserAccount user : adminUsers) {
            if (user.getPassword() == null) continue;
            XElem userElem = new XElem("user");
            userElem.addAttr("name", user.getFullyQualifiedName());
            userElem.addAttr("description", user.getComment());
            userElem.addAttr("passwordHash", user.getPassword());
            result.addContent((XContent)userElem);
        }
        this.setPlatformUsersXml(result);
    }
}

