/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.sys.Nre;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.sys.module.BModuleFile;
import com.tridium.sys.registry.NModuleInfo;
import java.io.File;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
public class BModuleInstallable
extends BInstallable {
    public static final Type TYPE = Sys.loadType(BModuleInstallable.class);
    private boolean localInstance = false;
    private boolean dependsInitialized = false;
    private final Lock dependsLock = new ReentrantLock();
    private static final BIcon ICON = BIcon.std((String)"module.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    public BModuleInstallable() {
    }

    private BModuleInstallable(BIFile pFile, NModuleInfo pModuleInfo) {
        this.setInstallableFileProperties(pFile);
        BModulePart module = new BModulePart(pFile, pModuleInfo, (BInstallable)this);
        module.setInstallable(this);
        this.setInstallableName(module.getPartName());
        this.getParts().add(SlotPath.escape((String)module.getPartName()), (BValue)module);
        this.setDescription(module.getDescription());
        this.setVersion((BVersion)module.getVersion().newCopy());
        this.localInstance = true;
    }

    private BModuleInstallable(BIFile pFile, InputStream pManifestStream) {
        this(pFile, pManifestStream, true);
    }

    private BModuleInstallable(BIFile pFile, InputStream pManifestStream, boolean pCloseFile) {
        this.setInstallableFileProperties(pFile);
        BModulePart module = new BModulePart(pFile, pManifestStream, this, pCloseFile);
        module.setInstallable(this);
        this.setInstallableName(module.getPartName());
        this.getParts().add(SlotPath.escape((String)module.getPartName()), (BValue)module);
        this.setDescription(module.getDescription());
        this.setVersion((BVersion)module.getVersion().newCopy());
        BVector depsVector = (BVector)this.get(dependencies);
        depsVector.removeAll();
        SlotCursor c = module.getDependencies().getProperties();
        while (c.next()) {
            depsVector.add(c.property().getName(), c.get().newCopy());
        }
        depsVector = (BVector)this.get(exclusions);
        depsVector.removeAll();
        c = module.getExclusions().getProperties();
        while (c.next()) {
            depsVector.add(c.property().getName(), c.get().newCopy());
        }
        this.setIsInstallable(module.getIsInstallable());
        this.setReleaseDate(module.getReleaseDate());
        this.dependsInitialized = true;
        this.localInstance = true;
    }

    public BModuleInstallable(long pFileSize, String pInstallableFileName, XElem pManifestElem) {
        this.setInstallableFileName(pInstallableFileName);
        this.setInstallableFileSize(pFileSize);
        BModulePart module = BModulePart.make(pInstallableFileName.substring(0, pInstallableFileName.length() - 4), pManifestElem);
        this.setInstallableName(module.getPartName());
        module.setFileSize(pFileSize);
        module.setInstallable(this);
        this.getParts().add(SlotPath.escape((String)module.getPartName()), (BValue)module);
        this.setDescription(module.getDescription());
        this.setVersion((BVersion)module.getVersion().newCopy());
        BVector depsVector = (BVector)this.get(dependencies);
        depsVector.removeAll();
        SlotCursor c = module.getDependencies().getProperties();
        while (c.next()) {
            depsVector.add(c.property().getName(), c.get().newCopy());
        }
        depsVector = (BVector)this.get(exclusions);
        depsVector.removeAll();
        c = module.getExclusions().getProperties();
        while (c.next()) {
            depsVector.add(c.property().getName(), c.get().newCopy());
        }
        this.setIsInstallable(module.getIsInstallable());
        this.setReleaseDate(module.getReleaseDate());
        this.dependsInitialized = true;
    }

    public BModulePart getModulePart() {
        SlotCursor c = this.getParts().getProperties();
        c.next();
        return (BModulePart)c.get();
    }

    @Override
    public BVector getDependencies() {
        if (this.localInstance) {
            this.dependsLock.lock();
            try {
                if (!this.dependsInitialized) {
                    BVector depsVector = (BVector)this.get(dependencies);
                    depsVector.removeAll();
                    SlotCursor c = this.getModulePart().getDependencies().getProperties();
                    while (c.next()) {
                        depsVector.add(c.property().getName(), c.get().newCopy());
                    }
                    depsVector = (BVector)this.get(exclusions);
                    depsVector.removeAll();
                    c = this.getModulePart().getExclusions().getProperties();
                    while (c.next()) {
                        depsVector.add(c.property().getName(), c.get().newCopy());
                    }
                    this.setReleaseDate(this.getModulePart().getReleaseDate());
                    this.dependsInitialized = true;
                }
            }
            finally {
                this.dependsLock.unlock();
            }
        }
        return super.getDependencies();
    }

    @Override
    public BVector getExclusions() {
        if (this.localInstance) {
            this.getDependencies();
        }
        return super.getExclusions();
    }

    @Override
    public Optional<Long> getReleaseDate() {
        if (this.localInstance) {
            this.getDependencies();
        }
        return super.getReleaseDate();
    }

    @Override
    public void close() {
    }

    @Override
    public long getProcessingFlags(BDaemonPlatform targetPlatform, DaemonSessionTaskListener taskListener) {
        if (targetPlatform == null || !this.localInstance || this.getInstallableName().equals("baja") || this.getModulePart().getManifest().noRunningStation()) {
            return 2L;
        }
        targetPlatform.getModuleList().init(taskListener);
        if (targetPlatform.getModuleList().meets(BDependency.forModule(this.getInstallableName()))) {
            return 2L;
        }
        return 4L;
    }

    @Override
    public FileTransferMessageElement[] getTransferElements(BDaemonPlatform target, StoreCache cache, ICancelHint cancelHint, DaemonSessionTaskListener taskListener) {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModuleInstallable");
        }
        return new FileTransferMessageElement[]{this.getModulePart().makeTransferElement(target)};
    }

    @Override
    public BInstallable makeLocalInstance() {
        if (this.localInstance) {
            return this;
        }
        try {
            return BModuleInstallable.make((BIFile)this.getInstallableFileOrd().get());
        }
        catch (UnresolvedException ue) {
            return null;
        }
    }

    @Override
    public boolean equivalent(Object obj) {
        if (obj instanceof BModuleInstallable) {
            BModuleInstallable inst = (BModuleInstallable)obj;
            return inst.getInstallableName().equals(this.getInstallableName()) && inst.getVersion().equivalent((Object)this.getVersion());
        }
        return false;
    }

    @Override
    public boolean meetsLicenseCriteria(VendorLicense vendorLicense) {
        if (vendorLicense.getVendor().equalsIgnoreCase("tridium") && this.getVersion().getVendor().equalsIgnoreCase("tridium")) {
            if (this.getReleaseDate().isPresent()) {
                if (vendorLicense.getMaintenanceExpiration().isPresent()) {
                    return (Long)vendorLicense.getMaintenanceExpiration().get() >= this.getReleaseDate().get();
                }
                if (this.getInstallableName().equals("baja")) {
                    return vendorLicense.getVersion().compareTo(this.getVersion().getVendorVersion().toMinorVersion()) >= 0;
                }
            } else {
                return (!this.getInstallableName().equals("baja") || vendorLicense.getVersion().compareTo(this.getVersion().getVendorVersion().toMinorVersion()) >= 0) && vendorLicense.getUnreleasedSwAccessExpiration().isPresent() && (Long)vendorLicense.getUnreleasedSwAccessExpiration().get() >= BAbsTime.now().getMillis();
            }
        }
        return true;
    }

    public static BInstallable make(BIFile file) {
        return BModuleInstallable.make(file, true);
    }

    public static BModuleInstallable make(NModuleInfo modInfo) {
        try {
            File installableFile = Nre.bootEnv.findModuleFile(modInfo.getModuleName(), modInfo.getRuntimeProfile().name());
            if (installableFile != null) {
                BModuleFile moduleFile = new BModuleFile();
                moduleFile.setStore((BIFileStore)new BLocalFileStore((BFileSpace)BFileSystem.INSTANCE, BFileSystem.INSTANCE.localFileToPath(installableFile), installableFile));
                return new BModuleInstallable((BIFile)moduleFile, modInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static BModuleInstallable make(BIFile file, boolean flagMissingManifest) {
        return BModuleInstallable.make(file, flagMissingManifest, true);
    }

    public static BModuleInstallable make(BIFile file, boolean flagMissingManifest, boolean closeFile) {
        try {
            InputStream manifestStream;
            if (file.getStore() instanceof BLocalFileStore) {
                BZipFile zipFile = file instanceof BZipFile ? (BZipFile)file : new BZipFile(file.getStore());
                BZipSpace space = (BZipSpace)zipFile.open();
                BIFile zipEntry = space.findFile(new FilePath("META-INF/module.xml"));
                if (zipEntry == null && (zipEntry = space.findFile(new FilePath("meta-inf/module.xml"))) == null) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                manifestStream = new DaemonFileUtil.ZipEntryInputStream(zipFile, zipEntry);
            } else {
                manifestStream = DaemonFileUtil.getZipStream(file, new FilePath("META-INF/module.xml"));
                if (manifestStream == null) {
                    manifestStream = DaemonFileUtil.getZipStream(file, new FilePath("meta-inf/module.xml"));
                }
            }
            if (manifestStream == null) {
                if (flagMissingManifest) {
                    return new BModuleInstallable(file, (InputStream)null);
                }
                return null;
            }
            return new BModuleInstallable(file, manifestStream, closeFile);
        }
        catch (Exception ioe) {
            return new BModuleInstallable(file, (InputStream)null);
        }
    }

    public BIcon getIcon() {
        return ICON;
    }
}

