/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.ValidationException;
import com.tridium.nre.security.ModuleVerificationMode;
import java.security.CodeSigner;
import java.security.Timestamp;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public enum ModuleSignatureStatusEnum {
    OK,
    NOT_TIMESTAMPED,
    UNKNOWN,
    SIGNER_SELF_SIGNED,
    TIMESTAMP_SELF_SIGNED,
    CERT_PATH_VALIDATION_FAILURE,
    CERT_PATH_VALIDATION_WARNING,
    UNSIGNED,
    INVALID_SIGNATURE;


    public boolean isAcceptable(ModuleVerificationMode verificationMode) {
        switch (verificationMode) {
            case high: {
                if (this == SIGNER_SELF_SIGNED || this == TIMESTAMP_SELF_SIGNED) {
                    return false;
                }
            }
            case medium: {
                if (this == UNSIGNED || this == CERT_PATH_VALIDATION_FAILURE || this == UNKNOWN) {
                    return false;
                }
            }
            case low: {
                if (this != INVALID_SIGNATURE) break;
                return false;
            }
        }
        return true;
    }

    public static List<ModuleSignatureStatusEnum> getSignatureStatus(List<CodeSigner> codeSigners, String signatureFailureCause, CertificateChainValidator validator) {
        if (codeSigners == null) {
            ArrayList<ModuleSignatureStatusEnum> status = new ArrayList<ModuleSignatureStatusEnum>();
            status.add(UNKNOWN);
            return status;
        }
        if (codeSigners.isEmpty()) {
            ArrayList<ModuleSignatureStatusEnum> status = new ArrayList<ModuleSignatureStatusEnum>();
            if (!signatureFailureCause.isEmpty()) {
                status.add(INVALID_SIGNATURE);
            } else {
                status.add(UNSIGNED);
            }
            return status;
        }
        ArrayList<List<ModuleSignatureStatusEnum>> statuses = new ArrayList<List<ModuleSignatureStatusEnum>>();
        for (CodeSigner signer : codeSigners) {
            statuses.add(ModuleSignatureStatusEnum.getSignatureStatus(signer, validator));
        }
        List best = null;
        int bestScore = 0;
        for (List list : statuses) {
            int currentScore = 0;
            for (ModuleSignatureStatusEnum status : list) {
                if (!status.isAcceptable(ModuleVerificationMode.low)) {
                    currentScore += 8;
                    continue;
                }
                if (!status.isAcceptable(ModuleVerificationMode.medium)) {
                    currentScore += 4;
                    continue;
                }
                if (!status.isAcceptable(ModuleVerificationMode.high)) {
                    currentScore += 2;
                    continue;
                }
                if (status == OK) continue;
                ++currentScore;
            }
            if (best != null && bestScore <= currentScore) continue;
            best = list;
            bestScore = currentScore;
        }
        return best;
    }

    public static List<ModuleSignatureStatusEnum> getSignatureStatus(CodeSigner signer, CertificateChainValidator validator) {
        ArrayList<ModuleSignatureStatusEnum> status = new ArrayList<ModuleSignatureStatusEnum>();
        try {
            Timestamp ts;
            List<? extends Certificate> certificates = signer.getSignerCertPath().getCertificates();
            X509Certificate certificate = (X509Certificate)certificates.get(0);
            if (certificates.size() == 1 && certificate.getSubjectDN().equals(certificate.getIssuerDN())) {
                status.add(SIGNER_SELF_SIGNED);
            }
            if ((ts = signer.getTimestamp()) != null) {
                certificates = ts.getSignerCertPath().getCertificates();
                certificate = (X509Certificate)certificates.get(0);
                if (certificates.size() == 1 && certificate.getSubjectDN().equals(certificate.getIssuerDN())) {
                    status.add(TIMESTAMP_SELF_SIGNED);
                }
            } else {
                status.add(NOT_TIMESTAMPED);
            }
            validator.validateCertChain(signer);
            if (status.isEmpty()) {
                status.add(OK);
            }
        }
        catch (ValidationException e) {
            if (validator.getLaxValidation()) {
                status.add(CERT_PATH_VALIDATION_WARNING);
            }
            status.add(CERT_PATH_VALIDATION_FAILURE);
        }
        return status;
    }
}

