/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.PartSpec;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BOsPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BInteger;
import javax.baja.sys.IterableCursor;

public class InstallableCandidates {
    private Map<Object, List<BInstallable>> candidatesByKey = new TreeMap<Object, List<BInstallable>>(CANDIDATE_KEY_COMPARATOR);
    private Map<BInteger, Set<Object>> keyByNumCandidates = new TreeMap<BInteger, Set<Object>>();
    private Map<PartSpec, UnmeetableDependency> unmeetableDependencyByPartSpec = null;
    private static Logger LOGGER = Logger.getLogger("platform.install");
    protected static final Comparator<Object> CANDIDATE_KEY_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof BDependency) {
            if (o2 instanceof BDependency) {
                return BDependency.COMPARATOR.compare((BDependency)((Object)((Object)o1)), (BDependency)((Object)((Object)o2)));
            }
            return 1;
        }
        if (o2 instanceof BDependency) {
            return -1;
        }
        return o1.toString().compareTo(o2.toString());
    };

    public void addAll(InstallableCandidates toAdd) {
        if (toAdd == null) {
            return;
        }
        for (Object newKey : toAdd.getKeys()) {
            Set<Object> keys;
            BInteger numCand;
            BInstallable[] newCands = toAdd.getCandidates(newKey);
            List<BInstallable> candidates = this.candidatesByKey.get(newKey);
            if (candidates == null) {
                candidates = new ArrayList<BInstallable>();
                Collections.addAll(candidates, newCands);
                this.candidatesByKey.put(newKey, candidates);
            } else {
                numCand = BInteger.make((int)candidates.size());
                keys = this.keyByNumCandidates.get(numCand);
                keys.remove(newKey);
                if (keys.size() == 0) {
                    this.keyByNumCandidates.remove(numCand);
                }
                Collections.addAll(candidates, newCands);
            }
            numCand = BInteger.make((int)candidates.size());
            keys = this.keyByNumCandidates.get(numCand);
            if (keys == null) {
                keys = new TreeSet<Object>(CANDIDATE_KEY_COMPARATOR);
                this.keyByNumCandidates.put(numCand, keys);
            }
            keys.add(newKey);
        }
    }

    public InstallableCandidates newCopy() {
        InstallableCandidates result = new InstallableCandidates();
        for (Object key : this.candidatesByKey.keySet()) {
            List<BInstallable> cands = this.candidatesByKey.get(key);
            result.candidatesByKey.put(key, new ArrayList<BInstallable>(cands));
            BInteger numCand = BInteger.make((int)cands.size());
            Set<Object> keySet = result.keyByNumCandidates.get(numCand);
            if (keySet == null) {
                keySet = new TreeSet<Object>(CANDIDATE_KEY_COMPARATOR);
                result.keyByNumCandidates.put(numCand, keySet);
            }
            keySet.add(key);
        }
        return result;
    }

    public int size() {
        return this.candidatesByKey.size();
    }

    public String toString() {
        return this.candidatesByKey.toString();
    }

    public boolean isDependencyUnsolvable(BDependency unmeetableDep, InstallScenario scenario) {
        UnmeetableDependency ud = this.getUnmeetableDependency(unmeetableDep.getPartSpec(), scenario);
        return ud != null && ud.isUnsolvable;
    }

    public boolean isDependencyReadonly(BDependency unmeetableDep, InstallScenario scenario) {
        UnmeetableDependency ud = this.getUnmeetableDependency(unmeetableDep.getPartSpec(), scenario);
        return ud != null && ud.isSoftwareReadonly;
    }

    public BDependency getFailedExclusion(BDependency unmeetableDep, InstallScenario scenario) {
        UnmeetableDependency ud = this.getUnmeetableDependency(unmeetableDep.getPartSpec(), scenario);
        return ud == null ? null : ud.failedExclusion;
    }

    public RuntimeProfile getDisabledRuntimeProfile(BDependency unmeetableDep, InstallScenario scenario) {
        UnmeetableDependency ud = this.getUnmeetableDependency(unmeetableDep.getPartSpec(), scenario);
        return ud == null ? null : ud.disabledRuntimeProfile;
    }

    public InstallableFilter getFailedFilter(BDependency unmeetableDep, InstallScenario scenario) {
        UnmeetableDependency ud = this.getUnmeetableDependency(unmeetableDep.getPartSpec(), scenario);
        return ud == null ? null : ud.failedFilter;
    }

    public boolean installableNotFound(BDependency unmeetableDep, InstallScenario scenario) {
        UnmeetableDependency ud = this.getUnmeetableDependency(unmeetableDep.getPartSpec(), scenario);
        return ud == null || ud.isSoftwareNotFound;
    }

    public UnmeetableDependency getUnmeetableDependency(PartSpec spec, InstallScenario scenario) {
        this.getUnmeetableDependencies(scenario);
        return this.unmeetableDependencyByPartSpec.get(spec);
    }

    public UnmeetableDependency[] getUnmeetableDependencies(InstallScenario scenario) {
        if (scenario.isSolved()) {
            if (this.unmeetableDependencyByPartSpec == null) {
                this.unmeetableDependencyByPartSpec = new HashMap<PartSpec, UnmeetableDependency>();
                for (Object key : this.candidatesByKey.keySet()) {
                    UnmeetableDependency ud;
                    if (!(key instanceof BDependency)) continue;
                    BDependency dep = (BDependency)((Object)key);
                    boolean depMet = scenario.getTargetPlatform().meets(dep);
                    if (depMet) {
                        if (scenario.getTargetPlatform().getIsNiagara4()) {
                            if (dep.getPartType() == BModulePart.TYPE && scenario.getNewEnabledRuntimeProfiles() != null && !scenario.getNewEnabledRuntimeProfiles().contains(((BModulePart)scenario.getTargetPlatform().getPart(dep)).getRuntimeProfile())) {
                                depMet = false;
                            }
                        } else if (dep.getPartType() == BModulePart.TYPE && scenario.getNewModuleContent() != null && scenario.getNewModuleContent().getOrdinal() > ((BModulePart)scenario.getTargetPlatform().getPart(dep)).getArchiveContent().getOrdinal()) {
                            depMet = false;
                        }
                    }
                    if (depMet) continue;
                    if (!scenario.getTargetPlatform().getIsSoftwareReadonly()) {
                        if (dep.canSolveWith(scenario.getSolutionParameters().solvers)) {
                            try {
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.finest("Installable candidates determining if dependency '" + (Object)((Object)dep) + "' is unmeetable with available installable registry");
                                }
                                IterableCursor<BInstallable> cInst = scenario.getInstallableRegistry().getInstallables(dep, scenario.getSolutionParameters().listener);
                                boolean foundInstallable = false;
                                boolean signatureFailure = false;
                                Object unmeetableReason = null;
                                while (cInst.next()) {
                                    BInstallable inst = (BInstallable)cInst.get();
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.finest("Installable candidates determining if candidate installable '" + inst + "' is unmeetable for dependency '" + (Object)((Object)dep) + "'...");
                                    }
                                    if (inst instanceof BModuleInstallable && scenario.getNewEnabledRuntimeProfiles() != null && !scenario.getNewEnabledRuntimeProfiles().contains(((BModuleInstallable)inst).getModulePart().getRuntimeProfile())) {
                                        if (LOGGER.isLoggable(Level.FINEST)) {
                                            LOGGER.finest("Installable candidates labeling candidate installable '" + inst + "' as unmeetable for dependency '" + (Object)((Object)dep) + "', runtime profile not supported");
                                        }
                                        unmeetableReason = ((BModuleInstallable)inst).getModulePart().getRuntimeProfile();
                                        break;
                                    }
                                    boolean partMismatch = false;
                                    boolean fatalPartMismatch = false;
                                    if (!inst.getPart().getType().is(dep.getPartType())) {
                                        partMismatch = true;
                                        if (inst.getPart().getType().is(BGenericPart.TYPE) && "tridium-qnx7-n4-titan-am335x-hs-maint".equals(inst.getInstallableName()) && dep.getPartType().is(BOsPart.TYPE) && "tridium-qnx7-n4-titan-am335x*".equals(dep.getPartName())) {
                                            fatalPartMismatch = true;
                                        }
                                    }
                                    if (fatalPartMismatch) {
                                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                                        LOGGER.finest("Installable candidates discarding candidate installable '" + inst + "' as meetable for dependency '" + (Object)((Object)dep) + "', part types do not match");
                                        continue;
                                    }
                                    BDependency failedExclusion = scenario.getFailedExclusion(inst);
                                    if (failedExclusion == null) {
                                        InstallableFilter failedFilter = scenario.getSolutionParameters().getFailedFilter(inst);
                                        if (failedFilter == null) {
                                            List<ModuleSignatureStatusEnum> status = scenario.getSignatureFailures().get(inst);
                                            if (status == null) {
                                                if (partMismatch) {
                                                    LOGGER.warning("Installable candidates considering candidate installable '" + inst + "' as meetable for dependency '" + (Object)((Object)dep) + "' with mismatched part types (" + inst.getPart().getType() + " != " + dep.getPartType() + ")");
                                                }
                                                if (LOGGER.isLoggable(Level.FINEST)) {
                                                    LOGGER.finest("Installable candidates labeling candidate installable '" + inst + "' as meetable for dependency '" + (Object)((Object)dep) + "', removing from unmeetable software");
                                                }
                                                foundInstallable = true;
                                                break;
                                            }
                                            if (unmeetableReason != null) continue;
                                            if (LOGGER.isLoggable(Level.FINEST)) {
                                                LOGGER.finest("Installable candidates labeling candidate installable '" + inst + "' as unmeetable for dependency '" + (Object)((Object)dep) + "', signature verification failed");
                                            }
                                            signatureFailure = true;
                                            continue;
                                        }
                                        if (unmeetableReason != null) continue;
                                        if (LOGGER.isLoggable(Level.FINEST)) {
                                            LOGGER.finest("Installable candidates labeling candidate installable '" + inst + "' as unmeetable for dependency '" + (Object)((Object)dep) + "', solution parameters reject candidate");
                                        }
                                        unmeetableReason = failedFilter;
                                        continue;
                                    }
                                    if (unmeetableReason != null) continue;
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.finest("Installable candidates labeling candidate installable '" + inst + "' as unmeetable for dependency '" + (Object)((Object)dep) + "', candidate is excluded from scenario");
                                    }
                                    unmeetableReason = failedExclusion;
                                }
                                try {
                                    cInst.close();
                                }
                                catch (Exception inst) {
                                    // empty catch block
                                }
                                if (foundInstallable) continue;
                                UnmeetableDependency ud2 = this.unmeetableDependencyByPartSpec.get(dep.getPartSpec());
                                if (ud2 == null) {
                                    ud2 = new UnmeetableDependency(dep);
                                    this.unmeetableDependencyByPartSpec.put(dep.getPartSpec(), ud2);
                                }
                                if (signatureFailure) {
                                    ud2.signatureFailure = true;
                                    continue;
                                }
                                if (unmeetableReason == null) {
                                    ud2.isSoftwareNotFound = true;
                                    continue;
                                }
                                if (unmeetableReason instanceof BDependency) {
                                    ud2.failedExclusion = (BDependency)((Object)unmeetableReason);
                                } else if (unmeetableReason instanceof RuntimeProfile) {
                                    ud2.disabledRuntimeProfile = unmeetableReason;
                                } else {
                                    ud2.failedFilter = (InstallableFilter)unmeetableReason;
                                }
                                this.unmeetableDependencyByPartSpec.put(dep.getPartSpec(), ud2);
                            }
                            catch (Exception e) {
                                UnmeetableDependency ud3 = this.unmeetableDependencyByPartSpec.get(dep.getPartSpec());
                                if (ud3 == null) {
                                    ud3 = new UnmeetableDependency(dep);
                                    this.unmeetableDependencyByPartSpec.put(dep.getPartSpec(), ud3);
                                }
                                ud3.isSoftwareNotFound = true;
                            }
                            continue;
                        }
                        ud = this.unmeetableDependencyByPartSpec.get(dep.getPartSpec());
                        if (ud == null) {
                            ud = new UnmeetableDependency(dep);
                            this.unmeetableDependencyByPartSpec.put(dep.getPartSpec(), ud);
                        }
                        ud.isUnsolvable = true;
                        continue;
                    }
                    ud = this.unmeetableDependencyByPartSpec.get(dep.getPartSpec());
                    if (ud == null) {
                        ud = new UnmeetableDependency(dep);
                        this.unmeetableDependencyByPartSpec.put(dep.getPartSpec(), ud);
                    }
                    ud.isSoftwareReadonly = true;
                }
            }
            return this.unmeetableDependencyByPartSpec.values().toArray(new UnmeetableDependency[this.unmeetableDependencyByPartSpec.size()]);
        }
        throw new IllegalStateException("Cannot call getUnavailableDependencies() on a scenario that has not been solved");
    }

    public BDependency[] getDependencies() {
        return (BDependency[])this.candidatesByKey.keySet().stream().filter(o -> o instanceof BDependency).toArray(BDependency[]::new);
    }

    public Object[] getKeys() {
        return this.candidatesByKey.keySet().toArray();
    }

    public boolean containsKey(Object key) {
        return this.candidatesByKey.containsKey(key);
    }

    public void addKey(Object key) {
        this.add(key, null);
    }

    public void add(Object key, BInstallable candidate) {
        Set<Object> keys;
        BInteger numCand;
        List<BInstallable> candidates = this.candidatesByKey.get(key);
        if (candidates == null) {
            candidates = new ArrayList<BInstallable>();
            if (candidate != null) {
                candidates.add(candidate);
            }
            this.candidatesByKey.put(key, candidates);
        } else {
            numCand = BInteger.make((int)candidates.size());
            keys = this.keyByNumCandidates.get(numCand);
            keys.remove(key);
            if (keys.size() == 0) {
                this.keyByNumCandidates.remove(numCand);
            }
            if (candidate != null) {
                candidates.add(candidate);
            }
        }
        numCand = BInteger.make((int)candidates.size());
        keys = this.keyByNumCandidates.get(numCand);
        if (keys == null) {
            keys = new TreeSet<Object>(CANDIDATE_KEY_COMPARATOR);
            this.keyByNumCandidates.put(numCand, keys);
        }
        keys.add(key);
    }

    public void set(Object key, BInstallable[] candidatesArray) {
        Set<Object> keys;
        BInteger numCand;
        List<BInstallable> oldCandidates = this.candidatesByKey.get(key);
        if (oldCandidates != null) {
            numCand = BInteger.make((int)oldCandidates.size());
            keys = this.keyByNumCandidates.get(numCand);
            keys.remove(key);
            if (keys.size() == 0) {
                this.keyByNumCandidates.remove(numCand);
            }
        }
        ArrayList newCandidates = new ArrayList();
        Collections.addAll(newCandidates, candidatesArray);
        this.candidatesByKey.put(key, newCandidates);
        numCand = BInteger.make((int)newCandidates.size());
        keys = this.keyByNumCandidates.get(numCand);
        if (keys == null) {
            keys = new TreeSet<Object>(CANDIDATE_KEY_COMPARATOR);
            this.keyByNumCandidates.put(numCand, keys);
        }
        keys.add(key);
    }

    public void removeKey(Object key) {
        List<BInstallable> candidates = this.candidatesByKey.get(key);
        if (candidates != null) {
            BInteger numCand = BInteger.make((int)candidates.size());
            Set<Object> keys = this.keyByNumCandidates.get(numCand);
            if (keys != null) {
                keys.remove(key);
                if (keys.size() == 0) {
                    this.keyByNumCandidates.remove(numCand);
                }
            }
            this.candidatesByKey.remove(key);
        }
    }

    public Object getFirstKey() {
        for (Set<Object> keys : this.keyByNumCandidates.values()) {
            Iterator<Object> iKeys = keys.iterator();
            if (!iKeys.hasNext()) continue;
            return iKeys.next();
        }
        return null;
    }

    public BInstallable[] getCandidates(Object key) {
        List<BInstallable> result = this.candidatesByKey.get(key);
        if (result == null) {
            return new BInstallable[0];
        }
        return result.toArray(new BInstallable[result.size()]);
    }
}

