/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.IFilter;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;

public class FilenameFilterUtil {
    public static final Lexicon lex = Lexicon.make((String)"platform");
    public static final IFilter NULL_FILTER = new NullFilenameFilter();

    public static IFilter make(String includes, String excludes) {
        if (includes == null || includes.trim().length() == 0) {
            if (excludes == null || excludes.trim().length() == 0) {
                return NULL_FILTER;
            }
            return FilenameFilterUtil.makeExclude(excludes);
        }
        if (excludes == null || excludes.trim().length() == 0) {
            return FilenameFilterUtil.makeInclude(includes);
        }
        return FilenameFilterUtil.makeAnd(new IFilter[]{FilenameFilterUtil.makeInclude(includes), FilenameFilterUtil.makeExclude(excludes)});
    }

    public static IFilter makeExclude(String excludes) {
        return FilenameFilterUtil.makeExclude((IFilter[])PatternFilter.parseList((String)excludes));
    }

    public static IFilter makeExclude(String excludes, String separators) {
        return FilenameFilterUtil.makeExclude((IFilter[])PatternFilter.parseList((String)excludes, (String)separators));
    }

    private static IFilter makeExclude(IFilter[] orig) {
        if (orig.length == 0) {
            return NULL_FILTER;
        }
        IFilter[] inverses = new IFilter[orig.length];
        for (int i = 0; i < inverses.length; ++i) {
            inverses[i] = FilenameFilterUtil.makeInverse(orig[i]);
        }
        return FilenameFilterUtil.makeAnd(inverses);
    }

    public static IFilter makeInclude(String includes) {
        return FilenameFilterUtil.makeOr((IFilter[])PatternFilter.parseList((String)includes));
    }

    public static IFilter makeInclude(String includes, String separators) {
        return FilenameFilterUtil.makeOr((IFilter[])PatternFilter.parseList((String)includes, (String)separators));
    }

    public static IFilter makeInverse(IFilter value) {
        return new NotFilenameFilter(value);
    }

    public static IFilter makeOr(IFilter[] orig) {
        if (orig.length == 0) {
            return NULL_FILTER;
        }
        return new OrFilenameFilter(orig);
    }

    public static IFilter makeAnd(IFilter[] orig) {
        if (orig.length == 0) {
            return NULL_FILTER;
        }
        return new AndFilenameFilter(orig);
    }

    private static String getFilename(Object obj) {
        if (obj instanceof BIFile) {
            return ((BIFile)obj).getFileName();
        }
        if (obj instanceof FilePath) {
            return ((FilePath)obj).getName();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new IllegalArgumentException("unrecognized file object");
    }

    public static class NotFilenameFilter
    implements IFilter {
        private IFilter invert;

        public NotFilenameFilter(IFilter invert) {
            this.invert = invert;
        }

        public boolean accept(Object file) {
            return !this.invert.accept((Object)FilenameFilterUtil.getFilename(file));
        }
    }

    public static class OrFilenameFilter
    implements IFilter {
        private IFilter[] filters;

        public OrFilenameFilter(IFilter[] filters) {
            if (filters == null || filters.length == 0) {
                throw new IllegalArgumentException();
            }
            this.filters = filters;
        }

        public boolean accept(Object file) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].accept((Object)FilenameFilterUtil.getFilename(file))) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndFilenameFilter
    implements IFilter {
        private IFilter[] filters;

        public AndFilenameFilter(IFilter[] filters) {
            if (filters == null || filters.length == 0) {
                throw new IllegalArgumentException();
            }
            this.filters = filters;
        }

        public boolean accept(Object file) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].accept((Object)FilenameFilterUtil.getFilename(file))) continue;
                return false;
            }
            return true;
        }
    }

    private static class NullFilenameFilter
    implements IFilter {
        private NullFilenameFilter() {
        }

        public boolean accept(Object file) {
            return true;
        }
    }
}

