/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BModuleList;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLocalDirectoryModuleList
extends BModuleList {
    public static final Type TYPE = Sys.loadType(BLocalDirectoryModuleList.class);
    private boolean initialized = false;
    private BDirectory[] moduleDirectories;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BLocalDirectoryModuleList(BDirectory moduleDirectory) {
        this(new BDirectory[]{moduleDirectory});
    }

    public BLocalDirectoryModuleList(BDirectory[] moduleDirectories) {
        this.moduleDirectories = moduleDirectories;
        this.setLocalInstance(true);
        this.reset();
    }

    public BLocalDirectoryModuleList() {
    }

    public BDirectory[] getDirectories() {
        return this.moduleDirectories;
    }

    @Override
    public void doReload(DaemonSessionTaskListener listener) {
        this.init(listener);
    }

    @Override
    public void reset() {
        super.reset();
        this.getModules().removeAll();
        this.initialized = false;
    }

    private void addFiles(BDirectory directory) {
        for (BIFile child : directory.listFiles()) {
            BModuleInstallable inst;
            if (child.getExtension() == null || !child.getExtension().equals("jar") && !child.getExtension().equals("sjar") || (inst = (BModuleInstallable)BModuleInstallable.make(child)) == null) continue;
            String slotName = SlotPath.escape((String)inst.getInstallableName());
            if (this.getModules().getProperty(slotName) == null) {
                this.getModules().add(slotName, (BValue)inst);
                continue;
            }
            throw new LocalizableRuntimeException("platform", "ModuleList.exception.dupModule", new Object[]{inst.getInstallableName()});
        }
    }

    @Override
    public synchronized void doInit(DaemonSessionTaskListener listener) {
        if (!this.initialized) {
            this.getModules().removeAll();
            for (BDirectory dir : this.moduleDirectories) {
                this.addFiles(dir);
            }
            this.initialized = true;
        }
    }
}

