/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.point;

import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.datatypes.BAaPhpOrd;
import com.tridium.aaphp.messages.AaPhpReadAttributeRequest;
import com.tridium.aaphp.messages.AaPhpReadAttributeResponse;
import com.tridium.aaphp.messages.AaPhpWriteAttributeRequest;
import com.tridium.aaphp.messages.AaPhpWriteAttributeResponse;
import com.tridium.aaphp.point.BAaPhpProxyExt;
import com.tridium.aaphp.util.AaPhpAttributeConversion;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAaPhpAttributeProxyExt
extends BAaPhpProxyExt {
    public static final Type TYPE = Sys.loadType(BAaPhpAttributeProxyExt.class);
    AaPhpAttributeConversion attrConv = null;
    boolean overriddenState = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pollForData() {
        BAaPhpNetwork network = (BAaPhpNetwork)this.getNetwork();
        AaPhpReadAttributeRequest req = null;
        AaPhpReadAttributeResponse rsp = null;
        try {
            String aaphpOrdString = this.getAaPhpOrd().getAaPhpOrd();
            req = new AaPhpReadAttributeRequest(this.getDeviceAddress(), aaphpOrdString);
            rsp = (AaPhpReadAttributeResponse)network.sendSync(req);
            if (rsp == null) {
                this.readFail("device timeout");
            } else if (rsp.isError()) {
                this.readFail("AaPhpError:" + rsp.getErrorMsg());
            } else {
                this.processResponseData(rsp);
            }
        }
        catch (Exception e) {
            this.readFail("" + e);
            e.printStackTrace();
        }
        finally {
            network = null;
        }
    }

    protected boolean discoverOverriddenState(BAaPhpOrd aaphpOrd) {
        return false;
    }

    void processResponseData(AaPhpReadAttributeResponse rsp) {
        BStatus status;
        this.attrConv = rsp.getAttrConv();
        BStatus bStatus = status = this.overriddenState ? BStatus.overridden : BStatus.ok;
        if (this.isBoolean()) {
            this.readOk((BStatusValue)new BStatusBoolean(rsp.getBooleanValue((Context)this.getPointFacets()), status));
        } else if (this.isNumeric()) {
            this.readOk((BStatusValue)new BStatusNumeric(rsp.getFloatValue((Context)this.getPointFacets()), status));
        } else if (this.isString()) {
            this.readOk((BStatusValue)new BStatusString(rsp.getStringValue((Context)this.getPointFacets()), status));
        } else if (this.isEnum()) {
            this.readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)rsp.getIntValue((Context)this.getPointFacets())), status));
        } else {
            throw new BajaRuntimeException("Please fix my program! Unexpected point type.");
        }
    }

    public void doWrite(BStatusValue out) {
        System.out.println("doWrite " + this);
        if (out == null) {
            this.updateOutput(this.getWriteValue());
        } else {
            this.updateOutput(out);
        }
        if (this.getParentPoint().isSubscribed()) {
            this.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOutput(BStatusValue value) {
        boolean success = false;
        if (this.isUnoperational()) {
            return false;
        }
        BAaPhpNetwork network = (BAaPhpNetwork)this.getNetwork();
        AaPhpWriteAttributeRequest req = null;
        AaPhpWriteAttributeResponse rsp = null;
        try {
            req = new AaPhpWriteAttributeRequest(this.getDeviceAddress(), this.getAaPhpOrd().getAaPhpOrd(), this.getRawAaPhpData(value));
            rsp = (AaPhpWriteAttributeResponse)network.sendSync(req);
            if (rsp == null) {
                this.writeFail("device timeout");
                this.getDevice().pingFail("timeout");
            } else if (rsp.isError()) {
                this.writeFail("error writing point:" + rsp.getErrorMsg());
            } else {
                this.writeOk(value);
                success = true;
            }
        }
        catch (Exception e) {
            this.writeFail("" + e);
            e.printStackTrace();
        }
        finally {
            network = null;
        }
        return success;
    }

    long getRawAaPhpData(BStatusValue value) {
        if (this.isBoolean()) {
            return this.attrConv.getRawValueFor(((BStatusBoolean)value).getBoolean());
        }
        if (this.isNumeric()) {
            return this.attrConv.getRawValueFor(((BStatusNumeric)value).getNumeric());
        }
        if (this.isString()) {
            return this.attrConv.getRawValueFor(((BStatusString)value).getValue(), (Context)this.getPointFacets());
        }
        if (this.isEnum()) {
            return this.attrConv.getRawValueFor(((BStatusEnum)value).getValue().getOrdinal());
        }
        throw new IllegalStateException("Unsupported BStatusValue type: " + value.getClass());
    }
}

