/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpMessage;
import com.tridium.aaphp.messages.AaPhpOutputStream;
import com.tridium.aaphp.messages.AaPhpReceivedMessage;
import com.tridium.aaphp.messages.AaPhpWriteFileResponse;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.sys.BajaRuntimeException;

public class AaPhpWriteFileRequest
extends AaPhpMessage {
    final int recordNum;
    final char fileNum;
    final byte[] data;
    final int dataFrom;
    final int dataTo;

    public AaPhpWriteFileRequest(int unitNumberAddress, int recordNo, char fileNum, byte[] data, int dataFrom, int dataTo) {
        super(unitNumberAddress);
        this.recordNum = recordNo;
        this.fileNum = fileNum;
        this.dataFrom = dataFrom;
        this.dataTo = dataTo;
        this.data = data;
    }

    public void write(OutputStream out) {
        AaPhpOutputStream aaphpOutStream = new AaPhpOutputStream();
        aaphpOutStream.write(59);
        aaphpOutStream.write(this.getUnitNumberAddress());
        aaphpOutStream.writeCmdCode("09");
        aaphpOutStream.writeRawDataHex16(this.recordNum);
        aaphpOutStream.write(this.fileNum);
        aaphpOutStream.writeHexBytes(this.data, this.dataFrom, this.dataTo);
        aaphpOutStream.writeCrc();
        aaphpOutStream.write(13);
        try {
            out.write(aaphpOutStream.toByteArray());
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException((Throwable)ioe);
        }
    }

    public Message toResponse(ReceivedMessage resp) {
        return new AaPhpWriteFileResponse(this.getUnitNumberAddress(), new AaPhpInputStream(((AaPhpReceivedMessage)resp).getBytes()));
    }
}

