/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpMessage;
import com.tridium.aaphp.messages.AaPhpOutputStream;
import com.tridium.aaphp.messages.AaPhpReadAttributeResponse;
import com.tridium.aaphp.messages.AaPhpReceivedMessage;
import com.tridium.aaphp.util.AaPhpOrdParser;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.sys.BajaRuntimeException;

public class AaPhpReadAttributeRequest
extends AaPhpMessage {
    final AaPhpOrdParser aaphpOrdParser;
    final String aaphpOrd;

    public AaPhpReadAttributeRequest(int unitNumberAddress, String aaphpOrd) {
        super(unitNumberAddress);
        this.aaphpOrd = aaphpOrd;
        this.aaphpOrdParser = new AaPhpOrdParser(aaphpOrd);
    }

    protected String getCommandCode() {
        if (this.aaphpOrdParser.isChannelAttr()) {
            return "00";
        }
        if (this.aaphpOrdParser.isPointAttr()) {
            return "02";
        }
        if (this.aaphpOrdParser.isPointObject()) {
            return "02";
        }
        throw new BajaRuntimeException("Unrecognized aaphp ord:" + this.aaphpOrd);
    }

    public void write(OutputStream out) {
        AaPhpOutputStream aaphpOutStream = new AaPhpOutputStream();
        aaphpOutStream.write(59);
        aaphpOutStream.write(this.getUnitNumberAddress());
        aaphpOutStream.writeCmdCode(this.getCommandCode());
        if (this.aaphpOrdParser.isChannelAttr()) {
            aaphpOutStream.writeChannel(this.aaphpOrdParser.getChannel());
            aaphpOutStream.writeAttribute(this.aaphpOrdParser.getAttr());
        } else if (this.aaphpOrdParser.isPointAttr()) {
            aaphpOutStream.writePointName(this.aaphpOrdParser.getPoint());
            aaphpOutStream.writeAttribute(this.aaphpOrdParser.getAttr());
        } else if (this.aaphpOrdParser.isPointObject()) {
            aaphpOutStream.write(39);
            aaphpOutStream.writeObjectName(this.aaphpOrdParser.getObject());
            aaphpOutStream.write(39);
        } else {
            throw new BajaRuntimeException("Unrecognized aaphp ord:" + this.aaphpOrd);
        }
        aaphpOutStream.writeCrc();
        aaphpOutStream.write(13);
        try {
            out.write(aaphpOutStream.toByteArray());
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException((Throwable)ioe);
        }
    }

    public Message toResponse(ReceivedMessage resp) {
        return new AaPhpReadAttributeResponse(new AaPhpInputStream(((AaPhpReceivedMessage)resp).getBytes()));
    }
}

