/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.session.MutableNiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.web.session.NiagaraWebSession;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;

public class SessionIdChangeHandler
implements HttpSessionIdListener {
    private static final Logger LOGGER = Logger.getLogger(SessionIdChangeHandler.class.getName());

    public void sessionIdChanged(HttpSessionEvent httpSessionEvent, String oldId) {
        HttpSession httpSession = httpSessionEvent.getSession();
        NiagaraWebSession niagaraSession = (NiagaraWebSession)SessionManager.getNiagaraSession((String)oldId, NiagaraWebSession.class);
        LOGGER.fine(() -> String.format("HttpSession id changed: oldId = %s, newId = %s", oldId, httpSessionEvent.getSession().getId()));
        if (niagaraSession != null) {
            SessionManager.changeSessionId((MutableNiagaraSession)niagaraSession, NiagaraWebSession.class, (String)httpSession.getId());
            LOGGER.fine(() -> String.format("Changed NiagaraHttpSession id: oldId = %s, superId = %s, newId = %s", oldId, niagaraSession.getSuperId(), niagaraSession.getId()));
        }
    }
}

