/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.authn.LoginFailureCause;
import com.tridium.jetty.NiagaraHttpSession;
import com.tridium.jetty.SessionIdChangeHandler;
import com.tridium.jetty.SessionInvalidationHandler;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.web.CookieUtil;
import com.tridium.web.session.NiagaraWebSession;
import java.security.AccessController;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Sys;
import javax.baja.web.authn.AuthMessage;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionHandler;

public class NiagaraSessionHandler
extends SessionHandler {
    private static final int AUTHENTICATED_MAX_INACTIVE_TIME = (int)TimeUnit.MINUTES.toSeconds(AccessController.doPrivileged(() -> Long.getLong("niagara.session.inactive.time", 240L)));
    private static final int UNAUTHENTICATED_MAX_INACTIVE_TIME = AccessController.doPrivileged(() -> Integer.getInteger("niagara.session.unauthenticated.inactive.time", 120));
    private static final Logger LOGGER = Logger.getLogger(NiagaraSessionHandler.class.getName());

    public NiagaraSessionHandler() {
        this.addEventListener((EventListener)((Object)new SessionIdChangeHandler()));
        this.addEventListener((EventListener)((Object)new SessionInvalidationHandler()));
        try {
            this.addEventListener((EventListener)Sys.loadClass((String)"box", (String)"com.tridium.box.BoxWsHttpSessionListener").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Problem adding event listener for BoxWsHttpSessionListener", e);
        }
    }

    protected void doStart() throws Exception {
        if (this.getServer() == null) {
            LOGGER.severe("Cannot start NiagaraSessionHandler when Server is null");
            throw new IllegalStateException("Cannot start NiagaraSessionHandler when Server is null");
        }
        super.doStart();
        this.setMaxInactiveInterval(UNAUTHENTICATED_MAX_INACTIVE_TIME);
    }

    public HttpCookie access(HttpSession session, boolean secure) {
        if (session instanceof Session) {
            Session s = (Session)session;
            Set sessionHandlers = s.getSessionHandler().getSessionIdManager().getSessionHandlers();
            for (SessionHandler sessionHandler : sessionHandlers) {
                Session matchingSession = AccessController.doPrivileged(() -> sessionHandler.getSession(s.getId()));
                if (matchingSession == null) continue;
                if (sessionHandler instanceof NiagaraSessionHandler) {
                    ((NiagaraSessionHandler)sessionHandler).accessSingle((HttpSession)matchingSession, secure);
                    continue;
                }
                sessionHandler.access((HttpSession)matchingSession, secure);
            }
        }
        return super.access(session, secure);
    }

    private void accessSingle(HttpSession session, boolean secure) {
        super.access(session, secure);
    }

    public void updateToAuthenticatedMaxInactiveInterval(Session session) {
        Set sessionHandlers = session.getSessionHandler().getSessionIdManager().getSessionHandlers();
        for (SessionHandler sessionHandler : sessionHandlers) {
            Session matchingSession = AccessController.doPrivileged(() -> sessionHandler.getSession(session.getId()));
            if (matchingSession == null) continue;
            matchingSession.setMaxInactiveInterval(AUTHENTICATED_MAX_INACTIVE_TIME);
        }
        session.setMaxInactiveInterval(AUTHENTICATED_MAX_INACTIVE_TIME);
    }

    protected void checkRequestedSessionId(Request baseRequest, HttpServletRequest request) {
        Cookie token;
        String authHeader;
        super.checkRequestedSessionId(baseRequest, request);
        String requested_session_id = request.getRequestedSessionId();
        LoginFailureCause cause = SessionManager.getCloseCause((String)requested_session_id);
        HttpSession session = request.getSession(false);
        if ((requested_session_id == null || session == null) && (authHeader = request.getHeader("Authorization")) != null) {
            try {
                AuthMessage message = AuthMessage.decodeFromString((String)authHeader);
                requested_session_id = message.getParameter("handshakeToken");
                if (requested_session_id == null && message.getScheme().equalsIgnoreCase("BEARER")) {
                    requested_session_id = message.getParameter("authToken");
                }
                if (requested_session_id != null) {
                    session = this.getHttpSession(requested_session_id);
                    baseRequest.setRequestedSessionId(requested_session_id);
                    if (session != null && this.isValid(session)) {
                        baseRequest.setSession(session);
                    } else {
                        requested_session_id = null;
                    }
                }
            }
            catch (IllegalArgumentException message) {
                // empty catch block
            }
        }
        if ((token = CookieUtil.getCookieFromName((HttpServletRequest)request, (String)"NTOKEN")) != null && (requested_session_id == null || session == null)) {
            String uri;
            String NToken = token.getValue();
            requested_session_id = SessionManager.getSessionFromNtoken((String)NToken, NiagaraHttpSession.class, (String)(uri = request.getRequestURI()));
            if (requested_session_id != null) {
                session = this.getHttpSession(requested_session_id);
                baseRequest.setRequestedSessionId(requested_session_id);
                baseRequest.setRequestedSessionIdFromCookie(requested_session_id != null);
                if (session != null && this.isValid(session)) {
                    baseRequest.setSession(session);
                }
                if (uri.startsWith("/wb/killntokens")) {
                    HttpCookie cookie = this.getSessionCookie(session, request.getContextPath(), request.isSecure());
                    ((Request)request).getResponse().addCookie(cookie);
                }
            }
            if (requested_session_id == null || session == null || !this.isValid(session)) {
                Cookie removeNtoken = CookieUtil.createCookie((String)"NTOKEN", (String)"", (int)0);
                removeNtoken.setHttpOnly(false);
                ((Request)request).getResponse().addCookie(removeNtoken);
            }
        }
        if (cause != null) {
            ((Request)request).getResponse().addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)cause.name(), (int)-1, (boolean)true, (boolean)request.isSecure()));
        }
    }

    public HttpSession newHttpSession(HttpServletRequest request) {
        if (request == null) {
            LOGGER.warning("Cannot create new HttpSession for null HttpServletRequest");
            throw new IllegalArgumentException("Cannot create new HttpSession for null HttpServletRequest");
        }
        if (!this.isStarted()) {
            LOGGER.warning("Cannot create new HttpSession when SessionHandler not running");
            throw new IllegalStateException("Cannot create new HttpSession when SessionHandler not running");
        }
        if (this.getServer() == null) {
            LOGGER.warning("Cannot create new HttpSession when Server is null");
            throw new IllegalStateException("Cannot create new HttpSession when Server is null");
        }
        HttpSession httpSession = super.newHttpSession(request);
        if (httpSession == null) {
            LOGGER.warning(() -> String.format("[%s] Failed to create new HttpSession, returning null", request.getRequestURI()));
            return null;
        }
        LOGGER.fine(() -> String.format("[%s] Created new HttpSession: id = %s", request.getRequestURI(), httpSession.getId()));
        NiagaraHttpSession niagaraSession = (NiagaraHttpSession)SessionManager.getNiagaraSession((String)httpSession.getId(), NiagaraWebSession.class);
        if (niagaraSession == null) {
            niagaraSession = new NiagaraHttpSession(httpSession, request);
            SessionManager.addSession((NiagaraSession)niagaraSession, NiagaraWebSession.class);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("[%s] Created new NiagaraHttpSession: id = %s, superId = %s", request.getRequestURI(), niagaraSession.getId(), niagaraSession.getSuperId()));
            }
        }
        if (niagaraSession.isCreatedWithSuperSessionId()) {
            httpSession.setMaxInactiveInterval(0);
        }
        niagaraSession.addHttpSession(httpSession);
        return httpSession;
    }

    public void invalidate(String id) {
        AccessController.doPrivileged(() -> {
            super.invalidate(id);
            return null;
        });
    }
}

