/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.web.BHostHeaderValidationSettings;
import java.io.IOException;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.web.BWebService;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class NiagaraSecurityHandler
extends HandlerWrapper {
    private static final Logger LOGGER = Logger.getLogger(NiagaraSecurityHandler.class.getName());
    public static final String HTTP_1_0_PROPERTY = "niagara.web.http10.enabled";
    private final boolean http10Enabled = AccessController.doPrivileged(() -> Boolean.getBoolean(HTTP_1_0_PROPERTY));

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.http10Enabled && request.getProtocol().equalsIgnoreCase(HttpVersion.HTTP_1_0.asString())) {
            response.sendError(505);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, () -> String.format("rejecting %s request for URI %s", HttpVersion.HTTP_1_0.asString(), request.getRequestURI()));
            }
            return;
        }
        if (!this.isHostHeaderValid(request)) {
            response.sendError(400, "Invalid Host Header");
            return;
        }
        if ("TRACE".equals(request.getMethod())) {
            response.sendError(405);
            LOGGER.log(Level.FINE, () -> String.format("Blocked HTTP TRACE request for URI %s", request.getRequestURI()));
            return;
        }
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.handle(target, baseRequest, request, response);
        }
    }

    public boolean isHostHeaderValid(HttpServletRequest request) {
        String hostHeader = request.getHeader("Host");
        boolean isSecure = request.isSecure();
        BHostHeaderValidationSettings hostHeaderValidationSettings = BWebService.getMainService().getHostHeaderValidationSettings();
        if (hostHeaderValidationSettings.isHostHeaderFormatValid(hostHeader) && hostHeaderValidationSettings.isHostHeaderValid(hostHeader, isSecure)) {
            return true;
        }
        this.logHostnameValidationFailure(request, hostHeader);
        return false;
    }

    private void logHostnameValidationFailure(HttpServletRequest request, String hostHeader) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Host header validation failed for: " + hostHeader);
        }
    }
}

