/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.authn.LoginFailureCause;
import com.tridium.jetty.JettyDiagUtil;
import com.tridium.jetty.NiagaraUserIdentity;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.web.session.NiagaraWebSession;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.Auditor;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.web.BWebService;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.UserIdentity;

public class NiagaraHttpSession
implements NiagaraWebSession {
    private Collection<HttpSession> httpSessions = new ArrayList<HttpSession>();
    private ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private String superId;
    private String remoteHost;
    private long creationTime;
    private String id;
    private boolean valid = true;
    private boolean createdWithSuperSessionId = false;
    private static String auditTarget = null;
    private static final Logger LOGGER = Logger.getLogger("web");

    public NiagaraHttpSession(HttpSession httpSession, HttpServletRequest request) {
        this.id = httpSession.getId();
        this.creationTime = System.currentTimeMillis();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"super_session_id".equals(cookie.getName())) continue;
                this.superId = cookie.getValue();
                this.createdWithSuperSessionId = true;
                break;
            }
        }
        this.setRemoteHost(request.getRemoteHost());
        if (SessionManager.isAuthenticated((String)this.getSuperId())) {
            AccessController.doPrivileged(() -> {
                this.doSetAuthenticated(SessionManager.getAuthenticatedUserFromSession((String)this.getSuperId()));
                return null;
            });
        }
        this.addHttpSession(httpSession);
    }

    public String getSuperId() {
        return this.superId;
    }

    public void setSuperId(String superId) {
        NiagaraBasicPermission initPermission = new NiagaraBasicPermission("MODIFY_SESSION_IDS");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)initPermission);
        }
        this.superId = superId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getSessionInfo() {
        return Collections.emptyMap();
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getAuditTarget() {
        if (auditTarget == null) {
            BWebService webService = BWebService.getMainService();
            auditTarget = webService.toPathString();
        }
        return auditTarget;
    }

    public void doSetAuthenticated(BUser user) {
        SessionAuthentication cached = new SessionAuthentication("NIAGARA_AUTH", (UserIdentity)new NiagaraUserIdentity(user), null);
        this.setAttribute("org.eclipse.jetty.security.UserIdentity", cached);
    }

    public Set<String> getAttributeKeys() {
        Set<String> attributeKeys = this.attributes.keySet();
        LOGGER.finest(() -> {
            StringJoiner joiner = new StringJoiner(",");
            for (String attributeKey : attributeKeys) {
                joiner.add(attributeKey);
            }
            return String.format("%s, getAttributes: keys = [%s]", this.getId(), joiner.toString());
        });
        return attributeKeys;
    }

    public <V> V getAttribute(String key) {
        Object value = this.attributes.get(key);
        LOGGER.finest(() -> String.format("%s: getAttribute, key = [%s], value = [%s]", this.getId(), key, value));
        return value;
    }

    public Object setAttribute(String key, Object value) {
        LOGGER.finest(() -> String.format("%s: setAttribute, key = [%s], value = [%s]", this.getId(), key, value));
        if (value == null) {
            return this.attributes.remove(key);
        }
        return this.attributes.put(key, value);
    }

    public <V> V removeAttribute(String key) {
        Object value = this.attributes.remove(key);
        LOGGER.finest(() -> String.format("%s: removeAttribute, key = [%s], value = [%s]", this.getId(), key, value));
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Collection<HttpSession> collection = this.httpSessions;
        synchronized (collection) {
            if (this.isValid()) {
                LOGGER.fine(() -> String.format("[%s] Invalidating NiagaraHttpSession: %s", Thread.currentThread().getName(), this.getId()));
                SessionManager.removeSession((NiagaraSession)this, NiagaraWebSession.class);
                this.valid = false;
                for (HttpSession httpSession : this.httpSessions) {
                    LOGGER.finer(() -> String.format("[%s] Invalidating HttpSession: %s", Thread.currentThread().getName(), JettyDiagUtil.getProperties(httpSession)));
                    try {
                        AccessController.doPrivileged(() -> {
                            httpSession.invalidate();
                            return null;
                        });
                    }
                    catch (IllegalStateException e) {
                        LOGGER.finer(() -> String.format("[%s] HttpSession already invalid: %s", Thread.currentThread().getName(), JettyDiagUtil.getProperties(httpSession)));
                    }
                }
                this.httpSessions.clear();
                this.auditLogout();
            }
        }
    }

    public void invalidate(LoginFailureCause cause) {
        LOGGER.fine(() -> String.format("[%s] Invalidating NiagaraHttpSession %s due to failure cause %s", Thread.currentThread().getName(), this.getId(), cause));
        SessionManager.putCloseCause((String)this.getId(), (LoginFailureCause)cause);
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Collection<HttpSession> collection = this.httpSessions;
        synchronized (collection) {
            return this.valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSession(HttpSession httpSession) {
        Collection<HttpSession> collection = this.httpSessions;
        synchronized (collection) {
            LOGGER.fine(() -> String.format("[%s] NiagaraHttpSession %s: Adding HttpSession: %s", this.getId(), Thread.currentThread().getName(), JettyDiagUtil.getProperties(httpSession)));
            if (!this.valid) {
                throw new IllegalStateException(String.format("[%s] NiagaraHttpSession is invalid. Cannot add HttpSession.", Thread.currentThread().getName()));
            }
            httpSession.setAttribute("javax.baja.web.niagaraWebSession", (Object)this);
            this.httpSessions.add(httpSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllHttpSessions() {
        Collection<HttpSession> collection = this.httpSessions;
        synchronized (collection) {
            this.httpSessions.clear();
        }
    }

    public boolean isCreatedWithSuperSessionId() {
        return this.createdWithSuperSessionId;
    }

    private void auditLogout() {
        SessionAuthentication seshAuth = (SessionAuthentication)this.getAttribute("org.eclipse.jetty.security.UserIdentity");
        Auditor auditor = Sys.getAuditor();
        if (seshAuth != null && auditor != null) {
            UserIdentity identity = seshAuth.getUserIdentity();
            BUser user = (BUser)identity.getUserPrincipal();
            Object fromLogoutServlet = this.getAttribute("isManualLogout");
            String auditType = fromLogoutServlet != null ? "Logout" : "Logout (Timeout)";
            try {
                auditor.audit(this.makeAuditEvent(auditType, user));
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, String.format("Failed to audit logout of NiagaraHttpSession: %s", this.getId()), e);
            }
        }
    }
}

