/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.table.view;

import com.tridium.hx.fieldeditors.BHxDefaultFE;
import com.tridium.hx.fieldeditors.BHxStringFE;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.util.UiLexicon;

public abstract class CompTableViewCol {
    static String lexName = UiLexicon.bajaui().getText("name");
    static String lexType = UiLexicon.bajaui().getText("type");
    static String lexPath = UiLexicon.bajaui().getText("path");
    public static final int EDITABLE = 1;
    public static final int UNSEEN = 2;
    public static final int READONLY = 4;
    protected String displayName;
    protected int flags;

    protected CompTableViewCol(String displayName) {
        this(displayName, 0);
    }

    protected CompTableViewCol(String displayName, int flags) {
        this.displayName = displayName;
        this.flags = flags;
    }

    public String getDisplayName(Context cx) {
        return this.displayName;
    }

    public abstract Object get(Object var1);

    public String toDisplayString(Object row, Object value, Context cx) {
        if (value instanceof BObject) {
            return ((BObject)value).toString(cx);
        }
        return String.valueOf(value);
    }

    public String getHyperlink(Object row, Object value, Context cx) {
        return null;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isEditable() {
        return (this.flags & 1) != 0;
    }

    public boolean isUnseen() {
        return (this.flags & 2) != 0;
    }

    public boolean isReadonly() {
        return (this.flags & 4) != 0;
    }

    public String toString() {
        return this.displayName + "[" + this.getClass().getName() + "]";
    }

    public BHxFieldEditor getEditor(BComponent[] rows) throws Exception {
        return null;
    }

    public void save(BComponent[] rows, BValue value, Context cx) throws Exception {
    }

    public static class PropPath
    extends CompTableViewCol {
        Property[] props;

        public PropPath(String name, Property[] props, int flags) {
            super(name, flags);
            this.props = props;
        }

        public PropPath(Property[] props, int flags) {
            this(props[props.length - 1].getDefaultDisplayName(null), props, flags);
        }

        public PropPath(Property[] props) {
            this(props, 0);
        }

        @Override
        public Object get(Object row) {
            BComplex val = (BComplex)row;
            for (int i = 0; i < this.props.length - 1; ++i) {
                val = (BComplex)val.get(this.props[i]);
            }
            Property prop = this.props[this.props.length - 1];
            return val.get(prop);
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            BComplex val = (BComplex)row;
            for (int i = 0; i < this.props.length - 1; ++i) {
                val = (BComplex)val.get(this.props[i]);
            }
            Property prop = this.props[this.props.length - 1];
            BFacets facets = val.getSlotFacets((Slot)prop);
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            return ((BObject)value).toString(cx);
        }
    }

    public static class Prop
    extends CompTableViewCol {
        Property prop;
        Property[] props;

        public Prop(String name, Property prop, int flags) {
            super(name, flags);
            this.prop = prop;
            this.props = new Property[]{prop};
        }

        public Prop(Property prop, int flags) {
            this(prop.getDefaultDisplayName(null), prop, flags);
        }

        public Prop(Property prop) {
            this(prop, 0);
        }

        @Override
        public Object get(Object row) {
            BComplex complex = (BComplex)row;
            return complex.get(this.prop);
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            BComplex complex = (BComplex)row;
            BFacets facets = complex.getSlotFacets((Slot)this.prop);
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            return ((BObject)value).toString(cx);
        }

        @Override
        public BHxFieldEditor getEditor(BComponent[] rows) throws Exception {
            BHxFieldEditor editor = BHxDefaultFE.INSTANCE;
            if (rows.length > 0) {
                try {
                    editor = BHxFieldEditor.makeFor((BObject)rows[0].get(this.prop), (Context)rows[0].getSlotFacets((Slot)this.prop));
                }
                catch (RuntimeException e) {
                    try {
                        editor = BHxFieldEditor.makeFor((BObject)rows[0].get(this.prop), null);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
            return editor;
        }

        @Override
        public void save(BComponent[] rows, BValue value, Context cx) throws Exception {
            for (int i = 0; i < rows.length; ++i) {
                BComponent row = rows[i];
                BValue old = row.get(this.prop);
                if (old.equivalent((Object)value)) continue;
                row.set(this.prop, value.newCopy(), cx);
            }
        }
    }

    public static class ToString
    extends CompTableViewCol {
        public ToString(String displayName, int flags) {
            super(displayName, flags);
        }

        @Override
        public Object get(Object row) {
            return ((BComponent)row).toString(null);
        }
    }

    public static class Path
    extends CompTableViewCol {
        public Path(int flags) {
            super(lexPath, flags);
        }

        @Override
        public Object get(Object row) {
            return ((BComponent)row).getSlotPath().toDisplayString();
        }
    }

    public static class Type
    extends CompTableViewCol {
        public Type() {
            super(lexType, 1);
        }

        public Type(int flags) {
            super(lexType, flags);
        }

        @Override
        public Object get(Object row) {
            return ((BComponent)row).getType();
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            if (value instanceof BFacets) {
                BFacets dummy = (BFacets)value;
                return dummy.getPickle().toString();
            }
            return String.valueOf(value);
        }
    }

    public static class Name
    extends CompTableViewCol {
        public Name() {
            super(lexName, 1);
        }

        public Name(int flags) {
            super(lexName, flags);
        }

        @Override
        public Object get(Object row) {
            String name = ((BComponent)row).getName();
            if (name != null) {
                return BString.make((String)SlotPath.unescape((String)name));
            }
            return BString.make((String)((BComponent)row).getType().getDisplayName(null));
        }

        @Override
        public String toDisplayString(Object row, Object value, Context cx) {
            return SlotPath.unescape((String)value.toString());
        }

        @Override
        public BHxFieldEditor getEditor(BComponent[] rows) {
            if (rows.length != 1) {
                return null;
            }
            return BHxStringFE.INSTANCE;
        }

        @Override
        public void save(BComponent[] rows, BValue value, Context cx) {
            String name = SlotPath.escape((String)((BString)value).getString());
            if (rows[0].getParent() != null) {
                BComponent parent = rows[0].getParent().asComponent();
                Property prop = rows[0].getPropertyInParent();
                parent.rename(prop, name, cx);
            }
        }
    }
}

