/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.px.binding;

import com.tridium.hx.util.HxUtils;
import com.tridium.web.WebUtil;
import javax.baja.agent.BIAgent;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.hx.px.MouseEventCommand;
import javax.baja.hx.px.binding.BHxPxBinding;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BValueBinding;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.LexiconModule;
import javax.servlet.http.HttpServletRequest;

public class BHxPxValueBinding
extends BHxPxBinding
implements BIAgent {
    public static final BHxPxValueBinding INSTANCE = new BHxPxValueBinding();
    public static final Type TYPE = Sys.loadType(BHxPxValueBinding.class);
    private InvokeActionCommand invokeActionCommand = new InvokeActionCommand();
    private static LexiconModule HX_LEX = LexiconModule.make((String)"hx");
    private static LexiconModule BAJAUI_LEX = LexiconModule.make((String)"bajaui");

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxPxValueBinding() {
        this.registerEvent(this.invokeActionCommand);
    }

    @Override
    public void write(HxOp op) throws Exception {
        HxOp widgetOp = (HxOp)op.getBase().getBase();
        BBinding binding = (BBinding)op.get();
        BHxPxWidget hxPxWidget = BHxPxWidget.makeFor((BObject)binding.getWidget());
        MouseEventCommand mouseHandler = hxPxWidget.getMouseEventHandler();
        if (mouseHandler != null) {
            hxPxWidget.registerEvent(mouseHandler, "mouseEventHandler");
            if (hxPxWidget.isEventRegistered(hxPxWidget.mouseEventCommand)) {
                StringBuilder onload = new StringBuilder();
                onload.append("hx.$addLongTouch(hx.$('").append(widgetOp.getPath()).append("'),function(event){").append(mouseHandler.getInvokeCode(502, widgetOp)).append("});");
                op.addOnload(onload.toString());
            }
        }
    }

    @Override
    public void update(int width, int height, boolean forceUpdate, HxOp op) throws Exception {
        super.update(width, height, forceUpdate, op);
        BValueBinding valueBinding = (BValueBinding)op.get();
        HxOp baseOp = (HxOp)op.getBase().getBase();
        if (valueBinding.isBound()) {
            PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
            properties.addUnsafe("title", valueBinding.getSummary().format((Object)valueBinding.getTarget().get(), (Context)op));
            properties.write(baseOp);
        }
        if (!valueBinding.getHyperlink().isNull() && MouseEventCommand.isMouseEnabled(valueBinding.getWidget())) {
            PropertiesCollection.Styles style = new PropertiesCollection.Styles();
            style.add("cursor", "pointer");
            style.write(baseOp);
            PropertiesCollection.Events events = new PropertiesCollection.Events();
            events.add("onmouseover", "window.status=\"" + HxUtil.escapeJsStringLiteral(valueBinding.getHyperlink().toString()) + "\"; return true;");
            events.add("onmouseout", "window.status=\"\"; return true;");
            events.write(baseOp);
        }
    }

    @Override
    public void handle(BInputEvent event, HxOp op) throws Exception {
        if (event instanceof BMouseEvent && (event.getId() == 501 || event.getId() == 502)) {
            BValueBinding valueBinding = (BValueBinding)op.get();
            HtmlWriter out = op.getHtmlWriter();
            BMouseEvent mouseEvent = (BMouseEvent)event;
            if (mouseEvent.isButton1Down() && !valueBinding.getHyperlink().isNull()) {
                out.w((Object)"hx.dynamic=false;");
                out.w((Object)"hx.hyperlink('").w((Object)HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)BOrd.make((BOrd)op.getOrd(), (BOrd)valueBinding.getHyperlink()).normalize()))).w((Object)"');");
            }
            if (mouseEvent.isButton2Down() && this.hasContextMenu(valueBinding, op)) {
                new ActionMenu(valueBinding).open(op);
            }
        }
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        if (BHxPxValueBinding.processAction(this.invokeActionCommand, op)) {
            return true;
        }
        return super.process(op);
    }

    public static boolean processAction(InvokeActionCommand invokeActionCommand, HxOp op) {
        BBinding valueBinding = (BBinding)op.get();
        if (valueBinding.isBound()) {
            OrdTarget target = valueBinding.getTarget();
            BComponent component = target.getComponent();
            String actionName = invokeActionCommand.getActionName(op);
            if (actionName != null) {
                Slot slot = component.getSlot(actionName);
                if (slot == null || !slot.isAction()) {
                    return false;
                }
                Action action = slot.asAction();
                BValue def = component.getActionParameterDefault(action);
                if (def != null) {
                    HxOp childOp = op.make("param", new OrdTarget((OrdTarget)op, (BObject)def));
                    childOp.mergeFacets(component.getSlotFacets((Slot)action));
                    BHxFieldEditor editor = BHxFieldEditor.makeForUx((BObject)def, childOp);
                    try {
                        if (editor.process(childOp)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    protected boolean hasContextMenu(BValueBinding binding, HxOp op) {
        if (!binding.isBound() || !binding.getPopupEnabled()) {
            return false;
        }
        BComponent component = binding.getTarget().getComponent();
        if (component == null) {
            return false;
        }
        BPermissions permissions = component.getPermissions((Context)op);
        SlotCursor cur = component.getActions();
        while (cur.next()) {
            boolean oper;
            Action action = cur.action();
            int flags = component.getFlags((Slot)action);
            boolean hidden = (flags & 4) != 0;
            boolean bl = oper = (flags & 0x100) != 0;
            if (hidden || (oper ? !permissions.has(4) : !permissions.has(64))) continue;
            return true;
        }
        return false;
    }

    public static void handleAction(InvokeActionCommand command, HxOp op) throws Exception {
        BBinding binding = (BBinding)op.get();
        if (!binding.isBound()) {
            return;
        }
        BComponent component = binding.getTarget().getComponent();
        String slotName = command.getActionName(op);
        if (slotName == null) {
            return;
        }
        Slot slot = component.getSlot(slotName);
        if (slot == null || !slot.isAction()) {
            return;
        }
        Action action = slot.asAction();
        BValue def = component.getActionParameterDefault(action);
        if (Flags.isConfirmRequired((BComplex)component, (Slot)action) && op.getFormValue("confirmed") == null) {
            ActionConfirmation dialog = new ActionConfirmation(action, binding, (Command)command);
            dialog.open(op);
            return;
        }
        if (def == null) {
            component.invoke(action, null, (Context)op);
            HxUtils.forceUpdate(op);
        } else {
            ActionDialog dialog = new ActionDialog(action, binding, (Command)command);
            BValue defaultActionArg = command.getDefaultActionArgument(op);
            if (defaultActionArg != null) {
                component.invoke(action, defaultActionArg, (Context)op);
                HxUtils.forceUpdate(op);
            } else if (op.getFormValue("paramsDisplayed") != null) {
                BValue param = dialog.saveContent(op);
                component.invoke(action, param, (Context)op);
                HxUtils.forceUpdate(op);
            } else {
                dialog.open(op);
            }
        }
    }

    static class ActionDialog
    extends Dialog {
        Action action;
        BComponent component;
        BBinding binding;

        ActionDialog(Action action, BBinding binding, Command command) {
            super((String)null, command);
            this.component = binding.getTarget().getComponent();
            this.action = action;
            this.binding = binding;
        }

        @Override
        protected String getTitle(HxOp op) {
            return this.component.getDisplayName((Slot)this.action, (Context)op);
        }

        protected BValue saveContent(HxOp op) throws Exception {
            OrdTarget target = this.binding.getTarget();
            BComponent c = target.getComponent();
            BValue def = c.getActionParameterDefault(this.action);
            HxOp childOp = op.make("param", new OrdTarget((OrdTarget)op, (BObject)def));
            childOp.mergeFacets(c.getSlotFacets((Slot)this.action));
            BHxFieldEditor editor = BHxFieldEditor.makeForUx((BObject)def, childOp);
            return (BValue)editor.fwSave(childOp);
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            OrdTarget target = this.binding.getTarget();
            BComponent c = target.getComponent();
            BValue def = c.getActionParameterDefault(this.action);
            HxOp childOp = op.make("param", new OrdTarget((OrdTarget)op, (BObject)def));
            childOp.mergeFacets(this.component.getSlotFacets((Slot)this.action));
            HtmlWriter out = op.getHtmlWriter();
            BHxFieldEditor editor = BHxFieldEditor.makeForUx((BObject)def, childOp);
            out.write("<div align='center'>");
            editor.write(childOp);
            out.write("</div>");
            out.w((Object)"<input type='hidden' name='").w((Object)op.scope("confirmed")).w((Object)"' value='true'/>");
            out.w((Object)"<input type='hidden' name='").w((Object)op.scope("paramsDisplayed")).w((Object)"' value='true'/>");
        }

        @Override
        public Command[] getCommands() {
            return new Command[]{new ActionSubmit(), new Dialog.Cancel(this)};
        }

        protected class ActionSubmit
        extends Dialog.Submit {
            protected ActionSubmit() {
                super(ActionDialog.this);
            }

            @Override
            public String getInvokeCode(HxOp op) {
                StringBuffer buf = new StringBuffer();
                buf.append("hx.setFormValue(&quot;").append(op.scope("action")).append("&quot;,&quot;").append(op.getFormValue("action")).append("&quot;); ");
                buf.append("hx.closeDialog(&quot;").append(op.getPath()).append("&quot;,&quot;").append(ActionDialog.this.getHandler().getId()).append("&quot;,null);");
                return buf.toString();
            }
        }
    }

    public static class ActionConfirmation
    extends Dialog {
        Action action;
        BComponent component;
        BBinding binding;

        public ActionConfirmation(Action action, BBinding binding, Command command) {
            super((String)null, command);
            this.component = binding.getTarget().getComponent();
            this.action = action;
            this.binding = binding;
        }

        @Override
        protected String getTitle(HxOp op) {
            return HX_LEX.getText("invoke.confirmTitle", (Context)op, new Object[]{this.component.getDisplayName((Slot)this.action, (Context)op)});
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String prompt = BAJAUI_LEX.getText("invoke.confirm", (Context)op, new Object[]{this.component.getDisplayName((Slot)this.action, (Context)op)});
            out.w((Object)"<div align='center'>");
            out.safe((Object)prompt);
            out.w((Object)"</div>");
            out.w((Object)"<input type='hidden' name='").w((Object)op.scope("confirmed")).w((Object)"' value='true'/>");
        }

        @Override
        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit(this), new Dialog.Cancel(this)};
        }
    }

    public static class InvokeActionCommand
    extends Command {
        public InvokeActionCommand() {
            super(null);
        }

        public String getActionName(HxOp op) {
            return op.getFormValue("action");
        }

        public BValue getDefaultActionArgument(HxOp op) {
            return null;
        }

        public String getInvokeCode(Action action, HxOp op) {
            String quote = HxUtil.getOuterQuote(op);
            StringBuffer buf = new StringBuffer();
            buf.append("hx.setFormValue(");
            buf.append(quote).append(op.scope("action")).append(quote);
            buf.append(",");
            buf.append(quote).append(action.getName()).append(quote);
            buf.append(");");
            buf.append("hx.fireEvent(");
            buf.append(quote).append(op.getPath()).append(quote);
            buf.append(",");
            buf.append(quote).append(this.getId()).append(quote);
            buf.append(");");
            return buf.toString();
        }

        @Override
        public void handle(HxOp op) throws Exception {
            BHxPxValueBinding.handleAction(this, op);
        }
    }

    class ActionMenu
    extends Dialog {
        BComponent component;
        BValueBinding binding;

        ActionMenu(BValueBinding binding) {
            super((String)null, null);
            this.binding = binding;
            this.component = binding.getTarget().getComponent();
        }

        @Override
        public Command[] getCommands() {
            return new Command[0];
        }

        @Override
        protected String getTitle(HxOp op) {
            return this.component.getDisplayName((Context)op);
        }

        @Override
        public void open(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var body = \"");
            this.write(op);
            out.w((Object)"\";");
            out.w((Object)"hx.doShowMenu(body);");
            if (this.onload.length() > 0) {
                out.w((Object)this.onload.toString());
            }
            String[] code = op.getOnload();
            for (int i = 0; i < code.length; ++i) {
                out.w((Object)code[i]);
            }
        }

        @Override
        public void write(HxOp op) throws Exception {
            this.writeContent(op);
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            BPermissions permissions = this.component.getPermissions((Context)op);
            SlotCursor cur = this.component.getActions();
            while (cur.next()) {
                boolean oper;
                Action action = cur.action();
                int flags = this.component.getFlags((Slot)action);
                boolean hidden = (flags & 4) != 0;
                boolean bl = oper = (flags & 0x100) != 0;
                if (hidden || (oper ? !permissions.has(4) : !permissions.has(64))) continue;
                String displayName = this.component.getDisplayName((Slot)action, (Context)op);
                HxUtil.writeContextMenuListItem(BHxPxValueBinding.this.invokeActionCommand.getInvokeCode(action, op), displayName, BOrd.DEFAULT, op);
            }
        }
    }
}

