/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.px;

import java.util.logging.Level;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.hx.px.BHxPxView;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.hx.px.binding.BHxPxBinding;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

public class MouseEventCommand
extends Command {
    public MouseEventCommand(BHxView view) {
        super(view);
    }

    public String getInvokeCode(int event, HxOp op) {
        return this.getInvokeCode(event, 0L, op);
    }

    public String getInvokeCode(int event, long delay, HxOp op) {
        String quote = "\"";
        StringBuffer buf = new StringBuffer();
        buf.append("var e=event;");
        buf.append("if(hx.setMouseEvent(e)){");
        if (event == 502 || event == 501) {
            buf.append("hx.closeMenu();");
        }
        if (delay > 0L) {
            buf.append("setTimeout(function(){");
        }
        buf.append("hx.fireEvent(");
        buf.append(quote).append(op.getPath()).append(quote);
        buf.append(",");
        buf.append(quote).append(this.getId()).append(quote);
        buf.append(", e);");
        if (delay > 0L) {
            buf.append("}, ").append(delay).append(");");
        }
        buf.append("}");
        buf.append("return hx.stopEventPropagation(e);");
        return buf.toString();
    }

    @Override
    public void handle(HxOp op) throws Exception {
        BWidget widget = (BWidget)op.get();
        BBinding[] bindings = widget.getBindings();
        BInputEvent event = this.getEvent(op);
        BHxPxWidget hxPxWidget = null;
        try {
            hxPxWidget = BHxPxWidget.makeFor((BObject)widget, (Context)op);
            if (!hxPxWidget.isMouseEnabled(op)) {
                return;
            }
            hxPxWidget.handle(event, op);
        }
        catch (NoSuchAgentException noSuchAgentException) {
            // empty catch block
        }
        for (int i = 0; i < bindings.length; ++i) {
            HxOp bindingOp = op.make(new OrdTarget((OrdTarget)op, (BObject)bindings[i]));
            try {
                BHxPxBinding hxBinding = BHxPxBinding.makeFor(bindings[i], (Context)bindingOp);
                hxBinding.handle(event, bindingOp);
                continue;
            }
            catch (NoSuchAgentException noSuchAgentException) {
                // empty catch block
            }
        }
    }

    protected HxOp getRootHxOp(HxOp op) {
        HxOp cx = op;
        while (cx.getBase() != null) {
            if (cx instanceof HxOp && cx.getPath().equals("")) {
                op = cx;
                break;
            }
            cx = cx.getBase();
        }
        return op;
    }

    protected BInputEvent getEvent(HxOp op) {
        BWidget widget = (BWidget)op.get();
        if ((op = this.getRootHxOp(op)).getFormValue("button") == null) {
            return null;
        }
        int modifiers = 0;
        modifiers = "right".equals(op.getFormValue("button")) ? (modifiers |= 8) : (modifiers |= 0x10);
        if ("true".equals(op.getFormValue("shiftModifier"))) {
            modifiers |= 1;
        }
        if ("true".equals(op.getFormValue("altModifier"))) {
            modifiers |= 8;
        }
        if ("true".equals(op.getFormValue("ctrlModifier"))) {
            modifiers |= 2;
        }
        if ("true".equals(op.getFormValue("metaModifier"))) {
            modifiers |= 4;
        }
        int clickCount = 1;
        if (op.getFormValue("doubleClick") != null) {
            clickCount = 2;
        }
        String eventIdStr = op.getFormValue("id");
        int eventId = 502;
        switch (eventIdStr) {
            case "mouseenter": {
                eventId = 504;
                break;
            }
            case "mouseleave": {
                eventId = 505;
                break;
            }
            case "touchstart": 
            case "mousedown": {
                eventId = 501;
                break;
            }
            case "touchcancel": 
            case "touchend": 
            case "mouseup": {
                eventId = 502;
            }
        }
        double x = Double.parseDouble(op.getFormValue("x"));
        double y = Double.parseDouble(op.getFormValue("y"));
        BMouseEvent event = new BMouseEvent(eventId, widget, modifiers, x, y, clickCount, false);
        if (BHxPxView.log.isLoggable(Level.FINER)) {
            BHxPxView.log.log(Level.FINER, String.valueOf(event));
        }
        return event;
    }

    public static boolean isMouseEnabled(BWidget widget) {
        if (!widget.getEnabled()) {
            return false;
        }
        if (widget == null) {
            return true;
        }
        BComplex c = widget.getParent();
        if (c instanceof BWidget) {
            return MouseEventCommand.isMouseEnabled((BWidget)c);
        }
        return true;
    }
}

