/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.mgr;

import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.mgr.HxMgrColumn;
import javax.baja.hx.mgr.HxMgrCommand;
import javax.baja.hx.mgr.HxMgrModel;
import javax.baja.hx.mgr.MgrOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@Deprecated
public abstract class BHxAbstractManager
extends BHxView {
    public static final Type TYPE = Sys.loadType(BHxAbstractManager.class);
    static Lexicon lex = Lexicon.make((String)"workbench");
    static String lexDiscoveryObjects = lex.getText("discovery.objects");
    static String lexDatabaseObjects = lex.getText("database.objects");

    @Override
    public Type getType() {
        return TYPE;
    }

    protected HxMgrModel makeModel() {
        return new HxMgrModel();
    }

    @Override
    public void write(HxOp hxop) throws Exception {
        int i;
        MgrOp op = this.makeMgrOp(hxop);
        op.addJavaScript("module://hx/javax/baja/hx/mgr/AbstractManager.js");
        BComponent c = (BComponent)op.get();
        BComponent[] rows = op.getModel().getRows();
        HxMgrCommand[] cmds = op.getModel().getCommands();
        boolean editable = cmds.length > 0;
        HxMgrColumn[] cols = op.getModel().getColumns();
        ArrayList<HxMgrColumn> list = new ArrayList<HxMgrColumn>();
        for (int i2 = 0; i2 < cols.length; ++i2) {
            if (cols[i2].isUnseen()) continue;
            list.add(cols[i2]);
        }
        cols = new HxMgrColumn[list.size()];
        cols = list.toArray(cols);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='tableViewHeader'>");
        out.w((Object)"<span style='float:right'>").w(rows.length);
        out.w((Object)" ").safe((Object)op.getModel().getRowType());
        out.w((Object)"</span>");
        out.safe((Object)op.getModel().getTableTitle());
        out.w((Object)"</div>");
        out.w((Object)"<div ").attr("id", op.scope("content"));
        out.w((Object)">");
        out.w((Object)"<table width='100%' cellspacing='0'>");
        out.w((Object)"<tr>");
        if (editable) {
            out.w((Object)"<th class='tableHeader'>&nbsp;</th>");
        }
        for (i = 0; i < cols.length; ++i) {
            out.w((Object)"<th class='tableHeader' style='text-align:left; white-space:nowrap;'");
            if (i == cols.length - 1) {
                out.w((Object)" width='100%'");
            }
            out.w((Object)">").safe((Object)cols[i].getDisplayName()).w((Object)"</th>");
        }
        out.w((Object)"</tr>");
        for (int r = 0; r < rows.length; ++r) {
            BComponent row = rows[r];
            out.w((Object)"<tr>");
            String cls = "tableCell tableHgrid tableVgrid";
            if (editable) {
                out.w((Object)"<td class='").w((Object)cls).w((Object)"' align='center' valign='top' style='padding:0;'>");
                out.w((Object)"<input type='checkbox' name='' ");
                out.attr("value", op.getModel().toRowValue(rows[r], r)).w(' ');
                out.attr("onclick", "mgr.select(event)").w((Object)"/>");
                out.w((Object)"</td>");
            }
            for (int i3 = 0; i3 < cols.length; ++i3) {
                out.w((Object)"<td class='").w((Object)cls).w((Object)"' valign='top' style='white-space:nowrap;'");
                if (i3 == cols.length - 1) {
                    out.w((Object)" width='100%'");
                }
                out.w((Object)">");
                if (i3 == 0 && row.getIcon() != null && row.getIcon().getOrdList().size() > 0) {
                    HxUtil.makeImageJS(BImage.make((BIcon)row.getIcon()), "style='vertical-align:middle;'", op);
                }
                String href = cols[i3].getHyperlink(row, cols[i3].get(row), (Context)op);
                String value = cols[i3].toDisplayString(row, cols[i3].get(row), (Context)op);
                if (href != null) {
                    out.w((Object)"<a href='").w((Object)HxUtil.encodeURLForHref(href)).w((Object)"'>");
                }
                if (value.length() == 0) {
                    out.w((Object)"&nbsp;");
                } else {
                    String[] lines = TextUtil.split((String)value, (char)'\n');
                    for (int j = 0; j < lines.length; ++j) {
                        if (j > 0) {
                            out.w((Object)"<br/>");
                        }
                        out.safe((Object)lines[j]);
                    }
                }
                if (href != null) {
                    out.w((Object)"</a>");
                }
                out.w((Object)"</td>");
            }
            out.w((Object)"</tr>");
        }
        out.w((Object)"</table>");
        if (cmds.length > 0) {
            out.w((Object)"<div class='tableViewToolbar'>");
            for (i = 0; i < cmds.length; ++i) {
                String name = cmds[i].getDisplayName((Context)op);
                String func = cmds[i].getFunctionName();
                boolean sel = cmds[i].getRequireSelection();
                StringBuffer cmd = new StringBuffer();
                cmd.append("mgr.invokeCommand(\"").append(func).append("\", ");
                cmd.append(sel ? "true" : "false").append(", event);");
                out.w((Object)" <input type='button' class='button'");
                out.attr(" value", name);
                out.attr(" onclick", cmd.toString());
                out.w((Object)" />");
            }
            out.w((Object)"</div>");
        }
        out.w((Object)"</div>");
    }

    @Override
    public boolean process(HxOp hxop) throws Exception {
        if (super.process(hxop)) {
            return true;
        }
        String contentType = hxop.getRequest().getContentType();
        if (contentType.equals("application/x-niagara-hx-event")) {
            String path = hxop.getRequest().getHeader("x-niagara-hx-path");
            if (path == null || path.equals("*")) {
                path = "";
            }
            if (!path.startsWith(hxop.getPath())) {
                return false;
            }
        }
        MgrOp op = this.makeMgrOp(hxop);
        HxMgrCommand[] cmds = op.getModel().getCommands();
        for (int i = 0; i < cmds.length; ++i) {
            if (!cmds[i].process(op)) continue;
            return true;
        }
        if (!contentType.equals("application/x-niagara-AbstractMgr-InvokeCommand")) {
            return false;
        }
        String[] args = TextUtil.split((String)op.getUnsafePostBody(), (char)',');
        op.setCmdArgs(args);
        for (int i = 0; i < cmds.length; ++i) {
            if (!cmds[i].getFunctionName().equals(args[0])) continue;
            cmds[i].invoke(op);
        }
        String content = op.getContent().toString();
        if (content.length() == 0) {
            op.getResponse().getWriter().print("null");
        } else {
            op.setContentType("text/html");
            op.getResponse().setHeader("hxPath", op.getPath());
            op.getResponse().getWriter().print(content);
        }
        return true;
    }

    @Override
    public BObject save(HxOp hxop) throws Exception {
        MgrOp op = this.makeMgrOp(hxop);
        String curr = op.getFormValue("command");
        if (curr == null) {
            return op.get();
        }
        HxMgrCommand[] cmds = op.getModel().getCommands();
        for (int i = 0; i < cmds.length; ++i) {
            if (!curr.equals(cmds[i].getFunctionName())) continue;
            cmds[i].save(op);
        }
        return op.get();
    }

    protected MgrOp makeMgrOp(HxOp op) {
        HxMgrModel model = this.makeModel();
        MgrOp mgrOp = new MgrOp(model, op);
        model.init(mgrOp);
        return mgrOp;
    }
}

