/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;

class MultiPartForm {
    private byte[] boundary;
    private boolean endStream = false;
    private static long counter = 0L;
    private static final int MAX_TEMP_FILES = 10000;

    MultiPartForm() {
    }

    public Map<String, String> decode(HxOp op) throws Exception {
        HashMap<String, String> hash = new HashMap<String, String>();
        String contentType = op.getRequest().getContentType();
        int index = contentType.indexOf("boundary=");
        this.boundary = contentType.substring(index + 9).getBytes();
        BufferedInputStream in = new BufferedInputStream((InputStream)op.getRequest().getInputStream());
        String line = this.readLine(in);
        while (!this.endStream && line != null) {
            boolean valid;
            line = this.readLine(in);
            if (line == null) continue;
            PartHeader header = this.parseHeader(line);
            if (header.filename == null) {
                String temp = this.readLine(in);
                while (temp.length() != 0) {
                    temp = this.readLine(in);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.readPartContents(in, out);
                String value = this.decodeUtf8(out.toByteArray());
                hash.put(header.name, value);
                continue;
            }
            boolean bl = valid = header.filename.length() > 0;
            if (valid) {
                hash.put(header.name, header.filename);
            }
            String temp = this.readLine(in);
            while (temp.length() != 0) {
                temp = this.readLine(in);
            }
            OutputStream out = null;
            BIFile file = null;
            if (valid) {
                file = this.makeTempFile(op);
                out = new BufferedOutputStream(file.getOutputStream(), 16000);
                op.setFile(header.name, file);
            } else {
                out = new ByteArrayOutputStream();
            }
            this.readPartContents(in, out);
            out.flush();
            out.close();
        }
        return hash;
    }

    private synchronized BIFile makeTempFile(HxOp op) throws Exception {
        String base = "^temp_hx_";
        for (int tries = 0; tries < 10000; ++tries) {
            FilePath path = new FilePath(base + counter);
            if (++counter >= 10000L) {
                counter = 0L;
            }
            try {
                BOrd.make((OrdQuery)path).resolve(op.get());
                continue;
            }
            catch (Exception e) {
                return BFileSystem.INSTANCE.makeFile(path, null);
            }
        }
        throw new RuntimeException("Too many temp files in file system");
    }

    private void readPartContents(InputStream in, OutputStream out) throws Exception {
        byte[] check = new byte[this.boundary.length + 4];
        int len = 0;
        int b = 0;
        while ((b = in.read()) >= 0) {
            check[len++] = (byte)(0xFF & b);
            if (check[0] == 13) {
                if (len < this.boundary.length + 4) continue;
                if (check[1] == 10 && check[2] == 45 && check[3] == 45) {
                    boolean match = true;
                    for (int i = 0; i < this.boundary.length; ++i) {
                        if (check[i + 4] == this.boundary[i]) continue;
                        match = false;
                    }
                    if (match) {
                        int b1 = in.read();
                        int b2 = in.read();
                        if (b1 == 45 && b2 == 45) {
                            this.endStream = true;
                        }
                        return;
                    }
                }
            }
            out.write(check[0]);
            System.arraycopy(check, 1, check, 0, --len);
        }
    }

    private String readLine(InputStream in) throws Exception {
        int b;
        StringBuffer result = null;
        while ((b = in.read()) >= 0) {
            if (result == null) {
                result = new StringBuffer();
            }
            if (b == 13 || b == 10) {
                if (b != 13) break;
                in.read();
                break;
            }
            result.append((char)b);
        }
        return result == null ? null : result.toString();
    }

    private PartHeader parseHeader(String str) {
        PartHeader h = new PartHeader();
        int start = str.indexOf(":") + 2;
        int end = str.indexOf(";");
        h.contentDisposition = str.substring(start, end);
        start = str.indexOf("name=");
        if (start != -1) {
            end = str.indexOf(";", start);
            if (end == -1) {
                end = str.length();
            }
            h.name = str.substring(start + 6, end - 1);
        }
        if ((start = str.indexOf("filename=")) != -1) {
            end = str.indexOf(";", start);
            if (end == -1) {
                end = str.length();
            }
            h.filename = str.substring(start + 10, end - 1);
        }
        return h;
    }

    private String decodeUtf8(byte[] c) {
        StringBuffer buf = new StringBuffer(c.length + 10);
        for (int i = 0; i < c.length; ++i) {
            int val = c[i];
            if ((val & 0xE0) == 192) {
                int high = val;
                int low = c[++i];
                low = (high & 1) << 6 | low & 0x3F;
                high = high >> 1 & 0xF;
                val = high << 7 | low;
            } else if ((val & 0xE0) == 224) {
                int three = val;
                byte two = c[++i];
                byte one = c[++i];
                val = (three & 0xF) << 12 | (two & 0x3F) << 6 | (one & 0x3F) << 0;
            }
            buf.append((char)val);
        }
        return buf.toString();
    }

    private static class PartHeader {
        private String contentDisposition = null;
        private String name = null;
        private String filename = null;
        private String contentType = null;

        private PartHeader() {
        }
    }
}

