/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import com.tridium.hx.HxHyperlinkInfo;
import com.tridium.nre.ConsumerWithException;
import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridium.ui.theme.Theme;
import com.tridium.web.WebUtil;
import com.tridium.web.servlets.ViewAllOrdServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.PropertiesCollection;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.web.WebOp;
import javax.baja.xml.XWriter;
import javax.servlet.http.HttpServletRequest;

public class HxUtil {
    static String WEBKIT = "WebKit";
    static String JAVAFX = "JavaFX";
    static int pollFreq = 5000;
    static boolean spriteSheetsDisabled = true;
    static AtomicInteger imageId = new AtomicInteger(0);

    public static AgentInfo getDefaultView(HxOp op) {
        try {
            return op.getWebEnv().getDefaultView((WebOp)op, HxUtil.getViews(op));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AgentList getViews(HxOp op) {
        return HxHyperlinkInfo.getViews(op);
    }

    private static boolean isValidForViewSelector(AgentInfo info) {
        return !info.getAgentType().is(BExporter.TYPE);
    }

    public static AgentList getViewsForViewSelector(HxOp op) throws Exception {
        AgentList agents = HxUtil.getViews(op);
        ViewAllOrdServlet.removeDuplicateAgents((WebOp)op, (AgentList)agents);
        agents = agents.filter(info -> HxUtil.isValidForViewSelector(info));
        return agents;
    }

    public static String makeFont(BFont font) {
        String name = HxUtil.getCSSFontName(font);
        double size = font.getSize();
        int style = font.getStyle();
        StringBuilder s = new StringBuilder();
        if ((style & 1) != 0) {
            s.append("bold ");
        }
        if ((style & 2) != 0) {
            s.append("italic ");
        }
        s.append(BDouble.encode((double)size)).append("px ");
        s.append(name);
        return s.toString();
    }

    public static String getCSSFontName(BFont font) {
        String fontName = font.getName();
        if ("sansserif".equalsIgnoreCase(fontName)) {
            return "sans-serif";
        }
        if ("monospaced".equalsIgnoreCase(fontName)) {
            return "monospace";
        }
        return fontName;
    }

    public static BColor makeColor(BBrush brush, BColor def) throws Exception {
        if (brush.isNull()) {
            return def;
        }
        if (brush.getPaint() instanceof BBrush.Solid) {
            BColor c = ((BBrush.Solid)brush.getPaint()).getColor();
            return c;
        }
        if (brush.getPaint() instanceof BBrush.Gradient) {
            BBrush.Stop[] stops = ((BBrush.Gradient)brush.getPaint()).getStops();
            int red = 0;
            int blue = 0;
            int green = 0;
            for (int stop = 0; stop < stops.length; ++stop) {
                BColor color = stops[stop].getColor();
                red += color.getRed();
                blue += color.getBlue();
                green += color.getGreen();
            }
            return BColor.make((int)(red / stops.length), (int)(green / stops.length), (int)(blue / stops.length));
        }
        return def;
    }

    public static String makeColor(BBrush brush, String def) throws Exception {
        BColor color = HxUtil.makeColor(brush, BColor.NULL);
        if (color.equals((Object)BColor.NULL)) {
            return def;
        }
        return color.toHtmlStringWithAlpha();
    }

    public static String makeInsets(BInsets insets) throws Exception {
        StringBuilder s = new StringBuilder();
        s.append(insets.top).append("px ");
        s.append(insets.right).append("px ");
        s.append(insets.bottom).append("px ");
        s.append(insets.left).append("px");
        return s.toString();
    }

    public static String makeBorder(BBorder border) throws Exception {
        BBorder b = border;
        StringBuilder s = new StringBuilder();
        s.append("border-top:");
        HxUtil.makeBorder(b.topWidth, b.topStyle, b.topBrush, s);
        s.append("border-left:");
        HxUtil.makeBorder(b.leftWidth, b.leftStyle, b.leftBrush, s);
        s.append("border-right:");
        HxUtil.makeBorder(b.rightWidth, b.rightStyle, b.rightBrush, s);
        s.append("border-bottom:");
        HxUtil.makeBorder(b.bottomWidth, b.bottomStyle, b.bottomBrush, s);
        return s.toString();
    }

    private static void makeBorder(double width, int style, BBrush brush, StringBuilder s) throws Exception {
        s.append(width).append("px ");
        switch (style) {
            case 0: {
                s.append("none ");
                break;
            }
            case 1: {
                s.append("solid ");
                break;
            }
            case 2: {
                s.append("dotted ");
                break;
            }
            case 3: {
                s.append("dashed ");
                break;
            }
            case 4: {
                s.append("groove ");
                break;
            }
            case 5: {
                s.append("solid ");
                break;
            }
            case 6: {
                s.append("inset ");
                break;
            }
            case 7: {
                s.append("outset ");
            }
        }
        if (style == 6 || style == 7) {
            s.append("#ccc");
        } else if (style == 5) {
            s.append(((BBrush.Solid)Theme.widget().getControlHighlight().getPaint()).getColor().toHtmlString());
        } else {
            s.append(HxUtil.makeColor(brush, BColor.black).toHtmlString());
        }
        s.append(";");
    }

    public static void makeAlignment(BHalign ha, BValign va, PropertiesCollection style) {
        if (ha == BHalign.center) {
            style.add("textAlign", "center");
        } else if (ha == BHalign.right) {
            style.add("textAlign", "right");
        } else if (ha != null) {
            style.add("textAlign", "left");
        }
        if (va == BValign.center) {
            style.add("verticalAlign", "middle");
        } else if (va == BValign.top) {
            style.add("verticalAlign", "top");
        } else if (va != null) {
            style.add("verticalAlign", "bottom");
        }
    }

    public static void makeAlignment(BAlign align, PropertiesCollection style) {
        if (align == BAlign.center) {
            style.add("textAlign", "center");
        } else if (align == BAlign.right) {
            style.add("textAlign", "right");
        } else if (align != null) {
            style.add("textAlign", "left");
        }
        if (align == BAlign.center) {
            style.add("verticalAlign", "middle");
        } else if (align == BAlign.bottom) {
            style.add("verticalAlign", "bottom");
        } else if (align != null) {
            style.add("verticalAlign", "top");
        }
    }

    public static void makeFont(BBrush foreground, BFont font, PropertiesCollection style, PropertiesCollection properties, boolean wrap, HxOp op) throws Exception {
        if (!wrap) {
            style.add("whiteSpace", "nowrap");
        }
        if (!foreground.isNull()) {
            style.add("color", HxUtil.makeColor(foreground, BColor.black).toHtmlStringWithAlpha());
            if (foreground.getPaint() instanceof BBrush.Gradient) {
                String gradient = HxUtil.makeGradientString((BBrush.Gradient)foreground.getPaint());
                style.add("background", gradient);
                style.add("-webkit-background-clip", "text");
                style.add("-webkit-text-fill-color", "transparent");
            } else {
                style.add("background", "");
                style.add("-webkit-background-clip", "");
                style.add("-webkit-text-fill-color", "");
            }
        } else {
            style.add("color", "");
            style.add("background", "");
            style.add("-webkit-background-clip", "");
            style.add("-webkit-text-fill-color", "");
        }
        if (font.isNull() && properties != null) {
            properties.append("className", "defaultNssFont");
            style.add("fontSize", "");
            style.add("fontFamily", "");
            style.add("fontWeight", "");
            style.add("textDecoration", "");
            style.add("fontStyle", "");
            return;
        }
        if (!font.isNull()) {
            style.add("fontSize", (int)font.getSize() + "px");
            if (properties == null) {
                style.add("fontFamily", HxUtil.getCSSFontName(font));
            } else {
                switch (font.getName().toLowerCase()) {
                    case "sansserif": 
                    case "sans-serif": {
                        properties.append("className", "ux-font-family-sans-serif");
                        break;
                    }
                    case "monospaced": 
                    case "monospace": {
                        properties.append("className", "ux-font-family-monospace");
                        break;
                    }
                    case "serif": {
                        properties.append("className", "ux-font-family-serif");
                        break;
                    }
                    default: {
                        style.add("fontFamily", HxUtil.getCSSFontName(font));
                        break;
                    }
                }
            }
        } else {
            style.add("fontSize", "");
            style.add("fontFamily", "");
        }
        if (!font.isNull() && font.isBold()) {
            style.add("fontWeight", "bold");
        } else {
            style.add("fontWeight", "normal");
        }
        if (!font.isNull() && font.isUnderline()) {
            style.add("textDecoration", "underline");
        } else {
            style.add("textDecoration", "");
        }
        if (!font.isNull() && font.isItalic()) {
            style.add("fontStyle", "italic");
        } else {
            style.add("fontStyle", "");
        }
    }

    public static void makeBackground(BBrush bg, BBrush def, PropertiesCollection style, HxOp op) throws Exception {
        boolean unsafe = false;
        if (!bg.isNull()) {
            StringBuilder background = new StringBuilder();
            if (bg.getPaint() instanceof BBrush.Solid) {
                background.append(HxUtil.makeColor(bg, BColor.NULL).toHtmlStringWithAlpha());
            } else if (bg.getPaint() instanceof BBrush.Gradient) {
                unsafe = true;
                background.append(HxUtil.makeGradientString((BBrush.Gradient)bg.getPaint()));
            }
            if (bg.getPaint() instanceof BBrush.Image) {
                BBrush.Image brush = (BBrush.Image)bg.getPaint();
                BImage backgroundImage = brush.getImage();
                if (backgroundImage == null || backgroundImage.getOrdList().size() < 1) {
                    style.add("backgroundImage", "");
                    style.add("backgroundColor", "");
                    return;
                }
                style.setSnoopEnabled(false);
                background.append("url(").append(HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)backgroundImage.getOrdList().get(0)))).append(") ");
                switch (brush.getTile()) {
                    case 0: {
                        background.append("no-repeat ");
                        break;
                    }
                    case 1: {
                        background.append("repeat ");
                        break;
                    }
                    case 2: {
                        background.append("repeat-x ");
                        break;
                    }
                    case 3: {
                        background.append("repeat-y ");
                    }
                }
                block6 : switch (brush.getValign()) {
                    case 0: {
                        switch (brush.getHalign()) {
                            case 3: {
                                background.append("center left ");
                                break;
                            }
                            case 4: {
                                background.append("center right ");
                                break;
                            }
                            case 0: {
                                background.append("center center ");
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (brush.getHalign()) {
                            case 3: {
                                background.append("top left ");
                                break;
                            }
                            case 4: {
                                background.append("top right ");
                                break;
                            }
                            case 0: {
                                background.append("top center ");
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (brush.getHalign()) {
                            case 3: {
                                background.append("bottom left ");
                                break block6;
                            }
                            case 4: {
                                background.append("bottom right ");
                                break block6;
                            }
                            case 0: {
                                background.append("bottom center ");
                            }
                        }
                    }
                }
            }
            if (unsafe) {
                style.addUnsafe("background", background.toString());
            } else {
                style.add("background", background.toString());
            }
        } else if (def != null && !def.isNull()) {
            HxUtil.makeBackground(def, null, style, op);
        } else {
            style.add("backgroundImage", "");
            style.add("backgroundColor", "");
        }
    }

    public static String makeGradientString(BBrush.Gradient gradient) {
        if (gradient instanceof BBrush.LinearGradient) {
            BBrush.Stop[] stops;
            BBrush.LinearGradient linear = (BBrush.LinearGradient)gradient;
            StringBuilder b = new StringBuilder();
            String cssAngle = "" + (90.0 - linear.getAngle());
            for (BBrush.Stop stop : stops = linear.getStops()) {
                b.append(",");
                b.append(stop.getColor().toHtmlStringWithAlpha() + " " + stop.getOffset() + "%");
            }
            return "linear-gradient(" + cssAngle + "deg " + b + ")";
        }
        if (gradient instanceof BBrush.RadialGradient) {
            BBrush.RadialGradient radial = (BBrush.RadialGradient)gradient;
            BBrush.Stop[] stops = radial.getStops();
            StringBuilder b = new StringBuilder();
            b.append("radial-gradient( ");
            b.append(radial.getRadius());
            b.append("% ");
            b.append(radial.getRadius());
            b.append("% ");
            b.append("at ");
            b.append(radial.getCenter().x());
            b.append("% ");
            b.append(radial.getCenter().y());
            b.append("% ");
            for (BBrush.Stop stop : stops) {
                b.append(",");
                b.append(stop.getColor().toHtmlStringWithAlpha() + " " + stop.getOffset() + "%");
            }
            b.append(")");
            return b.toString();
        }
        return "";
    }

    public static boolean isWidgetEffectivelyVisible(BWidget widget) {
        return widget.getVisible() || widget.getParentWidget() instanceof BScrollPane;
    }

    public static boolean isWidgetEffectivelyVisible(BWidget widget, int width, int height) {
        return width != 0 && height != 0 && (widget.getVisible() || widget.getParentWidget() instanceof BScrollPane);
    }

    private static String getBorderWidth(double width) {
        return width + "px";
    }

    public static void makeBorder(BBorder b, PropertiesCollection style) throws Exception {
        if (b.isNull()) {
            style.add("borderTopWidth", "");
            style.add("borderTopStyle", "");
            style.add("borderTopColor", "");
            style.add("borderLeftWidth", "");
            style.add("borderLeftStyle", "");
            style.add("borderLeftColor", "");
            style.add("borderRightWidth", "");
            style.add("borderRightStyle", "");
            style.add("borderRightColor", "");
            style.add("borderBottomWidth", "");
            style.add("borderBottomStyle", "");
            style.add("borderBottomColor", "");
            style.add("borderImage", "");
            return;
        }
        if (b.encodeToString().indexOf("bottom(") == -1 && b.topBrush.getPaint() instanceof BBrush.Gradient) {
            BBrush.Gradient gradient = (BBrush.Gradient)b.topBrush.getPaint();
            String gradientString = HxUtil.makeGradientString(gradient) + " " + (int)b.topWidth + " stretch";
            style.add("borderStyle", "solid");
            style.addUnsafe("borderImage", gradientString);
            style.add("borderWidth", HxUtil.getBorderWidth(b.topWidth));
            return;
        }
        style.add("borderTopWidth", HxUtil.getBorderWidth(b.topWidth));
        style.add("borderTopColor", HxUtil.makeColor(b.topBrush, BColor.NULL).toHtmlStringWithAlpha());
        switch (b.topStyle) {
            case 0: {
                style.add("borderTopStyle", "none");
                break;
            }
            case 1: {
                style.add("borderTopStyle", "solid");
                break;
            }
            case 2: {
                style.add("borderTopStyle", "dotted");
                break;
            }
            case 3: {
                style.add("borderTopStyle", "dashed");
                break;
            }
            case 4: {
                style.add("borderTopStyle", "groove");
                style.add("borderTopColor", "inherit");
                break;
            }
            case 5: {
                style.add("borderTopStyle", "ridge");
                style.add("borderTopColor", "inherit");
                break;
            }
            case 6: {
                style.add("borderTopStyle", "inset");
                style.add("borderTopColor", "inherit");
                break;
            }
            case 7: {
                style.add("borderTopStyle", "outset");
                style.add("borderTopColor", "inherit");
            }
        }
        style.add("borderLeftWidth", HxUtil.getBorderWidth(b.leftWidth));
        style.add("borderLeftColor", HxUtil.makeColor(b.leftBrush, BColor.NULL).toHtmlStringWithAlpha());
        switch (b.leftStyle) {
            case 0: {
                style.add("borderLeftStyle", "none");
                break;
            }
            case 1: {
                style.add("borderLeftStyle", "solid");
                break;
            }
            case 2: {
                style.add("borderLeftStyle", "dotted");
                break;
            }
            case 3: {
                style.add("borderLeftStyle", "dashed");
                break;
            }
            case 4: {
                style.add("borderLeftStyle", "groove");
                style.add("borderLeftColor", "inherit");
                break;
            }
            case 5: {
                style.add("borderLeftStyle", "ridge");
                style.add("borderLeftColor", "inherit");
                break;
            }
            case 6: {
                style.add("borderLeftStyle", "inset");
                style.add("borderLeftColor", "inherit");
                break;
            }
            case 7: {
                style.add("borderLeftStyle", "outset");
                style.add("borderLeftColor", "inherit");
            }
        }
        style.add("borderRightWidth", HxUtil.getBorderWidth(b.rightWidth));
        style.add("borderRightColor", HxUtil.makeColor(b.rightBrush, BColor.NULL).toHtmlStringWithAlpha());
        switch (b.rightStyle) {
            case 0: {
                style.add("borderRightStyle", "none");
                break;
            }
            case 1: {
                style.add("borderRightStyle", "solid");
                break;
            }
            case 2: {
                style.add("borderRightStyle", "dotted");
                break;
            }
            case 3: {
                style.add("borderRightStyle", "dashed");
                break;
            }
            case 4: {
                style.add("borderRightStyle", "groove");
                style.add("borderRightColor", "inherit");
                break;
            }
            case 5: {
                style.add("borderRightStyle", "ridge");
                style.add("borderRightColor", "inherit");
                break;
            }
            case 6: {
                style.add("borderRightStyle", "inset");
                style.add("borderRightColor", "inherit");
                break;
            }
            case 7: {
                style.add("borderRightStyle", "outset");
                style.add("borderRightColor", "inherit");
            }
        }
        style.add("borderBottomWidth", HxUtil.getBorderWidth(b.bottomWidth));
        style.add("borderBottomColor", HxUtil.makeColor(b.bottomBrush, BColor.NULL).toHtmlStringWithAlpha());
        switch (b.bottomStyle) {
            case 0: {
                style.add("borderBottomStyle", "none");
                break;
            }
            case 1: {
                style.add("borderBottomStyle", "solid");
                break;
            }
            case 2: {
                style.add("borderBottomStyle", "dotted");
                break;
            }
            case 3: {
                style.add("borderBottomStyle", "dashed");
                break;
            }
            case 4: {
                style.add("borderBottomStyle", "groove");
                style.add("borderBottomColor", "inherit");
                break;
            }
            case 5: {
                style.add("borderBottomStyle", "ridge");
                style.add("borderBottomColor", "inherit");
                break;
            }
            case 6: {
                style.add("borderBottomStyle", "inset");
                style.add("borderBottomColor", "inherit");
                break;
            }
            case 7: {
                style.add("borderBottomStyle", "outset");
                style.add("borderBottomColor", "inherit");
            }
        }
    }

    public static void makePadding(BInsets padding, PropertiesCollection style) throws Exception {
        style.add("paddingTop", (int)padding.top + "px");
        style.add("paddingBottom", (int)padding.bottom + "px");
        style.add("paddingLeft", (int)padding.left + "px");
        style.add("paddingRight", (int)padding.right + "px");
    }

    public static void makeMargin(BInsets padding, PropertiesCollection style) throws Exception {
        style.add("marginTop", (int)padding.top + "px");
        style.add("marginBottom", (int)padding.bottom + "px");
        style.add("marginLeft", (int)padding.left + "px");
        style.add("marginRight", (int)padding.right + "px");
    }

    public static void writeFormValue(String name, String value, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input ");
        out.attr("style", "display: none");
        out.w((Object)" ");
        out.attr("type", "text");
        out.w((Object)" ");
        out.attr("id", op.scope(name));
        out.w((Object)" ");
        out.attr("name", op.scope(name));
        out.w((Object)" ");
        out.attr("value", value);
        out.w((Object)"/>");
    }

    public static void persistFormValue(String name, HxOp op) throws Exception {
        if (op.getFormValue(name) != null) {
            HxUtil.writeFormValue(name, op.getFormValue(name), op);
        }
    }

    public static String decode(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 10);
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '+') {
                buf.append(" ");
                continue;
            }
            if (c[i] == '%') {
                int val = 0;
                int n = ++i;
                val += HxUtil.fromHex(c[n]) * 16;
                if (((val += HxUtil.fromHex(c[++i])) & 0xE0) == 192) {
                    int high = val;
                    int low = 0;
                    ++i;
                    low += HxUtil.fromHex(c[++i]) * 16;
                    low += HxUtil.fromHex(c[++i]);
                    low = (high & 1) << 6 | low & 0x3F;
                    high = high >> 1 & 0xF;
                    val = high << 7 | low;
                } else if ((val & 0xE0) == 224) {
                    int three = val;
                    int two = 0;
                    int one = 0;
                    ++i;
                    two += HxUtil.fromHex(c[++i]) * 16;
                    two += HxUtil.fromHex(c[++i]);
                    ++i;
                    one += HxUtil.fromHex(c[++i]) * 16;
                    val = (three & 0xF) << 12 | (two & 0x3F) << 6 | ((one += HxUtil.fromHex(c[++i])) & 0x3F) << 0;
                }
                buf.append((char)val);
                continue;
            }
            buf.append(c[i]);
        }
        return buf.toString();
    }

    private static int fromHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + ch);
    }

    @Deprecated
    public static void addTouchScroll(String elemID, HxOp op) {
    }

    public static boolean isPost(HxOp op) {
        String method = op.getRequest().getMethod().toLowerCase();
        return !method.equals("get");
    }

    public static String getOuterQuote(HxOp op) {
        String quote = !HxUtil.isPost(op) ? "\"" : "&quot;";
        return quote;
    }

    public static String getInnerQuote(HxOp op) {
        String quote = !HxUtil.isPost(op) ? "&quot;" : "'";
        return quote;
    }

    @Deprecated
    public static void makeImage(BImage image, HxOp op) throws Exception {
        HxUtil.makeImage(image, null, "", op);
    }

    @Deprecated
    public static void makeImage(BImage image, String attrs, HxOp op) throws Exception {
        HxUtil.makeImage(image, attrs, "", op);
    }

    @Deprecated
    public static void makeImage(BImage image, String attrs, String alt, HxOp op) throws Exception {
        HxUtil.makeImage(image, attrs, alt, null, op);
    }

    @Deprecated
    public static void makeImage(BImage image, String attrs, String alt, String quote, HxOp op) throws Exception {
        if (image == null || image.getOrdList().size() == 0) {
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        String ord = image.getOrdList().get(0).toString();
        if (alt == null) {
            alt = "";
        }
        out.w((Object)"<img");
        HxUtil.attr(" alt", alt, quote, out);
        if (alt != null && alt.length() > 0) {
            HxUtil.attr(" title", alt, quote, out);
        }
        HxUtil.attr(" src", ord, quote, out);
        if (attrs != null && attrs.length() > 0) {
            out.w((Object)" ").w((Object)attrs);
        }
        out.w((Object)"/>");
    }

    public static void makeImageJS(BImage image, HxOp op) throws Exception {
        HxUtil.makeImageJS(image, null, "", op);
    }

    public static void makeImageJS(BImage image, String attrs, HxOp op) throws Exception {
        HxUtil.makeImageJS(image, attrs, "", op);
    }

    public static void makeImageJS(BImage image, String attrs, String alt, HxOp op) throws Exception {
        HxUtil.makeImageJS(image, attrs, alt, null, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeImageJS(BImage image, String attrs, String alt, String quote, HxOp op) throws Exception {
        if (image == null || image.getOrdList().size() == 0) {
            return;
        }
        if (attrs == null) {
            attrs = "";
        }
        if (alt == null) {
            alt = "";
        }
        if (quote == null) {
            quote = "'";
        }
        if (spriteSheetsDisabled) {
            String ord = image.getOrdList().get(0).toString();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("<span class=" + quote + "hxImageWrapper" + quote + ">"));
            out.w((Object)"<span>");
            out.w((Object)"<img");
            HxUtil.attr(" alt", alt, quote, out);
            if (!alt.isEmpty()) {
                HxUtil.attr(" title", alt, quote, out);
            }
            HxUtil.attr(" src", ord, quote, out);
            if (!attrs.isEmpty()) {
                out.w((Object)" ").w((Object)attrs);
            }
            out.w((Object)"/>");
            out.w((Object)"</span>");
            out.w((Object)"</span>");
        } else {
            HtmlWriter html = op.getHtmlWriter();
            html.w((Object)("<span class=" + quote + "hxImageWrapper" + quote + ">"));
            StringBuilder ordArray = new StringBuilder("[");
            StringBuilder opArray = new StringBuilder("[");
            for (int i = 0; i < image.getOrdList().size(); ++i) {
                HxOp scopeOp = op.make("hx_image_" + imageId.getAndIncrement(), (OrdTarget)op);
                if (i != 0) {
                    ordArray.append(", ");
                    opArray.append(", ");
                }
                ordArray.append("'" + HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)image.getOrdList().get(i))) + "'");
                opArray.append("'" + HxUtil.escapeJsStringLiteral(scopeOp.scope("value")) + "'");
                html.w((Object)"<span ");
                HxUtil.attr("id", scopeOp.scope("value"), quote, html);
                html.w((Object)"></span>");
            }
            ordArray.append("]");
            opArray.append("]");
            html.w((Object)"</span>");
            Writer writer = HxUtil.startOnloadWriter(op);
            try {
                HtmlWriter js = op.getHtmlWriter();
                if (quote.equals("'")) {
                    js.w((Object)("hx.makeImage(" + ordArray.toString() + ", " + opArray.toString() + ", \"" + XWriter.safeToString((String)alt, (boolean)false) + "\", \"" + attrs + "\").catch(function (err) { console.error(err); });"));
                } else {
                    js.w((Object)("hx.makeImage(" + ordArray.toString() + ", " + opArray.toString() + ", '" + XWriter.safeToString((String)alt, (boolean)false) + "', '" + attrs + "').catch(function (err) { console.error(err); });"));
                }
            }
            finally {
                HxUtil.finishOnloadWriter(writer, op);
            }
        }
    }

    public static void changeImageJS(String parent, BImage image, String attrs, HxOp op) throws Exception {
        HtmlWriter html = op.getHtmlWriter();
        html.w((Object)HxUtil.changeImageJSInvokeCode(parent, image, attrs, op));
    }

    public static String changeImageJSInvokeCode(String parent, BImage image, String attrs, HxOp op) {
        if (attrs == null) {
            attrs = "";
        }
        StringBuilder ordArray = new StringBuilder("[");
        for (int i = 0; i < image.getOrdList().size(); ++i) {
            if (i != 0) {
                ordArray.append(", ");
            }
            ordArray.append("'" + HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)image.getOrdList().get(i))) + "'");
        }
        ordArray.append("]");
        return "hx.changeImage('" + parent + "', " + ordArray.toString() + ", \"" + attrs + "\").catch(function (err) { console.error(err); });";
    }

    public static final HtmlWriter attr(String name, String value, String quote, HtmlWriter out) {
        if (quote == null) {
            quote = "'";
        }
        return out.w((Object)name).w('=').w((Object)quote).safe((Object)value).w((Object)quote);
    }

    public static Writer startOnloadWriter(HxOp op) throws IOException {
        StringWriter contentHx = new StringWriter();
        op.setWriter(new PrintWriter(contentHx));
        return contentHx;
    }

    public static void finishOnloadWriter(Writer writer, HxOp op) throws IOException {
        op.resetWriter();
        op.addOnload(writer.toString());
    }

    @Deprecated
    public static boolean isUserAgentWithoutInnerDivTouchScroll(HxOp op) {
        return false;
    }

    public static int getPollFreq() {
        return pollFreq;
    }

    public static String encodeSingleQuotes(String text) {
        return HxUtil.encodeQuotes(text, "'");
    }

    public static String encodeDoubleQuotes(String text) {
        return HxUtil.encodeQuotes(text, "\"");
    }

    private static String encodeQuotes(String text, String quoteCharacter) {
        return text.replace(quoteCharacter, "\\" + quoteCharacter);
    }

    public static String unescapeJsForInvocation(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("&quot;", "\"");
        return s;
    }

    public static void writeSafeAnchor(BOrd ord, String displayText, HxOp op) throws Exception {
        HxUtil.writeSafeAnchorStart(ord, op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)">");
        out.safe((Object)displayText);
        out.w((Object)"</a>");
    }

    public static void writeSafeAnchorStart(BOrd ord, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)("<!-- @noSnoop --><a href='" + HxUtil.encodeOrdForHref(ord, op) + '\''));
    }

    public static String encodeOrdForHref(BOrd ord, HxOp op) {
        String s = op.toUri(ord);
        int codePointCount = s.codePointCount(0, s.length());
        StringBuilder b = new StringBuilder(s.length());
        block9: for (int i = 0; i < codePointCount; ++i) {
            int codePoint = s.codePointAt(i);
            switch (codePoint) {
                case 34: {
                    b.append("%22");
                    continue block9;
                }
                case 39: {
                    b.append("%27");
                    continue block9;
                }
                case 92: {
                    b.append("%5C");
                    continue block9;
                }
                case 10: {
                    b.append("%0A");
                    continue block9;
                }
                case 13: {
                    b.append("%0D");
                    continue block9;
                }
                case 8232: {
                    b.append("%E2%80%A8");
                    continue block9;
                }
                case 8233: {
                    b.append("%E2%80%A9");
                    continue block9;
                }
                default: {
                    b.appendCodePoint(codePoint);
                }
            }
        }
        return b.toString();
    }

    public static String encodeURLForHref(String link) throws Exception {
        if (link == null || !link.contains("'") && !link.contains("\"")) {
            return link;
        }
        return URLEncoder.encode(link, "UTF-8");
    }

    public static String escapeJsStringLiteral(String s) {
        return WebUtil.escapeJsStringLiteral((String)s);
    }

    public static String marshal(ConsumerWithException<? super HxOp, Exception> r, HxOp op) throws Exception {
        StringWriter content = new StringWriter();
        op.setWriter(new PrintWriter(content));
        try {
            r.accept((Object)op);
        }
        finally {
            op.resetWriter();
        }
        return content.toString();
    }

    public static String encodeText(String text) throws Exception {
        StringBuilder out = new StringBuilder();
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c2;
            char c;
            if (Character.isHighSurrogate(c = text.charAt(i++)) && i < len && Character.isLowSurrogate(c2 = text.charAt(i))) {
                out.append("&#").append(Character.toCodePoint(c, c2)).append(';');
                ++i;
                continue;
            }
            if (c < ' ' || c > '~' || c == '\'' || c == '\"' || c == '\\') {
                if (c == '\n' || c == '\r') {
                    out.append("<br/>");
                    continue;
                }
                if (c == '\"') {
                    out.append("\\\"");
                    continue;
                }
                if (c == '\'') {
                    out.append("\\'");
                    continue;
                }
                if (c == '\\') {
                    out.append("\\\\");
                    continue;
                }
                out.append("&#").append((int)c).append(';');
                continue;
            }
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String getUpdateValueInvokeCode(String formName, String stringValue, String quote, HxOp op) throws Exception {
        char newLine;
        boolean needNewLineFix = false;
        char backslash = '\\';
        char SUBSTITUTE = '\ufffd';
        String match = "\\";
        if (stringValue.indexOf(match) > -1) {
            stringValue = TextUtil.replace((String)stringValue, (String)match, (String)("" + SUBSTITUTE + "s"));
            needNewLineFix = true;
        }
        match = quote;
        if (stringValue.indexOf(quote) > -1) {
            stringValue = TextUtil.replace((String)stringValue, (String)match, (String)(backslash + quote));
        }
        if (stringValue.indexOf(newLine = '\n') > -1) {
            stringValue = TextUtil.replace((String)stringValue, (String)("" + newLine), (String)("" + SUBSTITUTE + 'n'));
            needNewLineFix = true;
        }
        if (stringValue.indexOf(newLine = '\r') > -1) {
            stringValue = TextUtil.replace((String)stringValue, (String)("" + newLine), (String)("" + SUBSTITUTE + 'r'));
            needNewLineFix = true;
        }
        StringBuilder b = new StringBuilder();
        b.append("hx.updateValue(").append(quote).append(formName).append(quote).append(",");
        b.append(quote).append(stringValue).append(quote).append(",");
        b.append(needNewLineFix).append(");");
        return b.toString();
    }

    public static void writeContextMenuListItem(BINavNode navNode, HxOp op) throws Exception {
        String quote = HxUtil.getOuterQuote(op);
        String onclick = "hx.hyperlink(" + quote + HxUtil.encodeOrdForHref(navNode.getNavOrd(), op) + quote + ");";
        String displayName = navNode.getNavDisplayName((Context)op);
        BOrd iconOrd = null;
        if (navNode.getNavIcon() != null && navNode.getNavIcon().getOrdList().size() > 0) {
            iconOrd = navNode.getNavIcon().getOrdList().get(0);
        }
        HxUtil.writeContextMenuListItem(onclick, displayName, iconOrd, op);
    }

    public static void writeContextMenuListItem(String onclick, String displayName, BOrd imageOrd, HxOp op) throws Exception {
        String quote = HxUtil.getOuterQuote(op);
        HtmlWriter out = op.getHtmlWriter();
        String cls = "class";
        out.w((Object)"<li ").attr("class", "context-menu-item");
        out.w((Object)(" onmouseover='this.setAttribute(" + quote + cls + quote + ',' + quote + "context-menu-item hover" + quote + ");'"));
        out.w((Object)(" onmouseout='this.setAttribute(" + quote + cls + quote + ',' + quote + "context-menu-item" + quote + ");'"));
        out.w((Object)" onclick='");
        out.w((Object)onclick);
        out.w((Object)"'>");
        out.w((Object)"<span class='display'><span class='icon'>");
        if (imageOrd != null && !imageOrd.isNull()) {
            HxUtil.makeImageJS(BImage.make((BOrd)imageOrd), null, displayName, op);
        }
        out.w((Object)"</span><span class='displayName'>");
        out.safe((Object)displayName);
        out.w((Object)"</span></span>");
        out.w((Object)"</li>");
    }

    public static String safe(String s) {
        return XWriter.safeToString((String)s, (boolean)true);
    }

    public static String getCsrfTokenQueryString() {
        NiagaraSuperSession session = SessionManager.getCurrentNiagaraSuperSession();
        try {
            if (session != null) {
                return "?csrfToken=" + URLEncoder.encode(session.getCsrfToken(), "UTF-8");
            }
        }
        catch (IOException ie) {
            BHxView.log.log(Level.INFO, "CSRF token encoding error", ie);
        }
        return "";
    }

    public static void addJavascriptOnload(HxOp op) throws Exception {
        String[] global;
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"/* @noSnoop */");
        BOrd[] scripts = op.getJavaScriptOrds();
        for (int i = 0; i < scripts.length; ++i) {
            if (i == 0) {
                out.w((Object)"hx.addJavaScript(['");
            } else {
                out.w((Object)"','");
            }
            String javascriptUrl = WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)scripts[i]);
            out.w((Object)javascriptUrl);
        }
        if (scripts.length > 0) {
            out.w((Object)"'], function(){");
        }
        if ((global = op.getGlobal()).length > 0) {
            for (int i = 0; i < global.length; ++i) {
                if (global[i] == null) continue;
                out.w((Object)global[i]);
            }
        }
        String[] codes = op.getOnload();
        for (int i = 0; i < codes.length; ++i) {
            if (codes[i] == null) continue;
            out.w((Object)HxUtil.unescapeJsForInvocation(codes[i]));
        }
        if (scripts.length > 0) {
            out.w((Object)"});");
        }
    }

    public static OrdTarget getMinimalOrdTarget(OrdTarget target) {
        if (!(target instanceof HxOp)) {
            return target;
        }
        OrdTarget t = target;
        while (t instanceof HxOp) {
            t = t.getBaseOrdTarget();
        }
        return OrdTarget.makeWithFacetsAndLanguage((OrdTarget)t, (BObject)target.get(), (BFacets)target.getFacets(), (String)target.getLanguage());
    }

    static {
        try {
            pollFreq = AccessController.doPrivileged(() -> Integer.getInteger("hx.poll.freq", 5000));
            spriteSheetsDisabled = AccessController.doPrivileged(() -> Boolean.getBoolean("hx.spritesheets.disabled"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

