/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import com.tridium.nre.ConsumerWithException;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.baja.util.LexiconText;

public class Dialog {
    private String key;
    private Object title;
    private Command handler;
    protected StringBuffer onload = new StringBuffer();

    public Dialog(String title, Command handler) {
        this.title = title;
        this.handler = handler;
    }

    public Dialog(LexiconText title, Command handler) {
        this.title = title;
        this.handler = handler;
    }

    public Dialog(LexiconModule lexiconModule, String key, Command handler) {
        this.title = lexiconModule;
        this.handler = handler;
        this.key = key;
    }

    public Dialog(Command handler) {
        this.handler = handler;
    }

    public boolean isSubmit(HxOp op) {
        Command[] cmds;
        for (Command cmd : cmds = this.getCommands()) {
            if (!(cmd instanceof DialogCommand) || !((DialogCommand)cmd).isSubmit(op)) continue;
            return true;
        }
        return false;
    }

    public void open(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"/* @noSnoop */");
        out.w((Object)"var body = \"");
        out.w((Object)HxUtil.escapeJsStringLiteral(HxUtil.marshal((ConsumerWithException<? super HxOp, Exception>)((ConsumerWithException)this::write), op)));
        out.w((Object)"\";");
        out.w((Object)"hx.showDialog(body);");
        if (this.onload.length() > 0) {
            out.w((Object)this.onload.toString());
        }
        if (!HxUtil.isPost(op)) {
            return;
        }
        HxUtil.addJavascriptOnload(op);
    }

    protected String getTitle(HxOp op) {
        if (this.title instanceof LexiconModule) {
            return ((LexiconModule)this.title).getText(this.key, (Context)op);
        }
        if (this.title instanceof LexiconText) {
            return ((LexiconText)this.title).getText((Context)op);
        }
        if (this.title != null) {
            return this.title.toString();
        }
        return "";
    }

    protected void writeContent(HxOp op) throws Exception {
    }

    @Deprecated
    protected void addOnload(String s) throws Exception {
        this.onload.append(s);
    }

    public Command getHandler() {
        return this.handler;
    }

    public Command[] getCommands(HxOp op) {
        return this.getCommands();
    }

    public Command[] getCommands() {
        return new Command[]{new Submit(), new Cancel()};
    }

    public Command makeSubmitCommand() {
        return new Submit("submit", LexiconText.make((String)"hx", (String)"ok"));
    }

    public Command makeSubmitCommand(String name) {
        return new Submit(name, LexiconText.make((String)"hx", (String)"ok"));
    }

    public Command makeSubmitCommand(LexiconText displayName) {
        return new Submit("submit", displayName);
    }

    public Command makeSubmitCommand(String name, LexiconText displayName) {
        return new Submit(name, displayName);
    }

    public Command makeCancelCommand() {
        return new Cancel();
    }

    public void write(HxOp op) throws Exception {
        Command[] commands = this.getCommands(op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table border='0' align='center' height='100%'>");
        out.w((Object)"<tr><td valign='middle'>");
        out.w((Object)"<div class='control-bg dialog-outerBorder'>");
        out.w((Object)"<div class='dialog-innerBorder'>");
        out.w((Object)"<div class='dialog-header'>").safe((Object)this.getTitle(op)).w((Object)"</div>");
        out.w((Object)"<div class='dialog-content'>");
        out.w((Object)"<div ");
        out.w((Object)" id='dialog-maxHeight'");
        out.w((Object)">");
        this.writeContent(op);
        out.w((Object)"</div>");
        out.w((Object)"<span style='display:none;'>");
        out.w((Object)" <input type='text' name='dialog-fix'/>");
        out.w((Object)"</span>");
        out.w((Object)"<div class='dialog-button-content-hx'>");
        for (Command command : commands) {
            out.w((Object)" <input type='submit' class='button'");
            if (command instanceof DialogCommand) {
                out.w((Object)" name='");
                out.w((Object)op.scope(((DialogCommand)command).getName()));
                out.w((Object)"'");
            }
            out.w((Object)" value='").safe((Object)command.getDisplayName(op)).w((Object)"'");
            out.w((Object)" onmousedown=' this.allowSubmit=true;' ");
            out.w((Object)" onclick=' if(this.allowSubmit == true || hx.dialogCounter == 0){").w((Object)command.getInvokeCode(op)).w((Object)"} return false;'/>");
        }
        out.w((Object)"</div>");
        out.w((Object)"</div>");
        out.w((Object)"</div>");
        out.w((Object)"</div>");
        out.w((Object)"</td></tr>");
        out.w((Object)"</table>");
    }

    protected class Cancel
    extends DialogCommand {
        public Cancel() {
            super("cancel");
        }

        @Override
        public String getDisplayName(HxOp op) {
            return Lexicon.make((String)"hx", (Context)op).getText("cancel");
        }

        @Override
        public String getInvokeCode(HxOp op) {
            return "hx.closeDialog(null,null,null);";
        }
    }

    protected class Submit
    extends DialogCommand {
        private LexiconText displayName;

        public Submit() {
            super("submit");
            this.displayName = LexiconText.make((String)"hx", (String)"ok");
        }

        public Submit(String name, LexiconText displayName) {
            super(name);
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName(HxOp op) {
            if (this.displayName == null) {
                return Lexicon.make((String)"hx", (Context)op).getText("ok");
            }
            return this.displayName.getText((Context)op);
        }

        @Override
        public String getInvokeCode(HxOp op) {
            return "hx.closeDialog(&quot;" + op.getPath() + "&quot;,&quot;" + Dialog.this.handler.getId() + "&quot;, event);";
        }

        @Override
        public boolean isSubmit(HxOp op) {
            return op.getFormValue(this.getName()) != null;
        }
    }

    public abstract class DialogCommand
    extends Command {
        private String name;

        public DialogCommand(String name) {
            super(null);
            this.name = name;
        }

        public boolean isSubmit(HxOp op) {
            return false;
        }

        public String getName() {
            return this.name;
        }
    }
}

