/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.hx.fieldeditors.BHxBajauxComplexFE;
import com.tridium.hx.fieldeditors.BHxBajauxFE;
import com.tridium.hx.fieldeditors.BHxDefaultFE;
import com.tridium.web.WebUtil;
import java.security.AccessController;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.web.BIWebProfile;
import javax.baja.workbench.BWbEditor;

public abstract class BHxFieldEditor
extends BHxView {
    public static final Type TYPE = Sys.loadType(BHxFieldEditor.class);
    private static TypeInfo uxMini = Sys.getRegistry().getType("web:IFormFactorMini");
    private static TypeInfo hxType = Sys.getRegistry().getType("hx:HxFieldEditor");
    private static TypeInfo wbType = Sys.getRegistry().getType("workbench:WbFieldEditor");
    private static AgentFilter uxMiniFilter = AgentFilter.is((TypeInfo)uxMini);
    private static AgentFilter hxFilter = AgentFilter.is((Type)TYPE);
    private static AgentFilter wbFilter = AgentFilter.is((TypeInfo)wbType);
    private static boolean BAJA_UX_EDITORS_DISABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("hx.disableBajauxEditors"));
    public static final String BAJAUX_KEY = "bajaux";
    public static final BFacets PREFER_BAJAUX = BFacets.make((String)"bajaux", (boolean)true);
    public static final String BAJAUX_COMPLEX_FALLBACK_KEY = "bajauxComplexFallback";
    public static final BFacets BAJAUX_COMPLEX_FALLBACK = BFacets.make((String)"bajauxComplexFallback", (boolean)true);

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BHxFieldEditor makeFor(BObject obj, Context cx) {
        BHxFieldEditor uxEditor;
        boolean preferBajaux;
        if (BAJA_UX_EDITORS_DISABLED) {
            return BHxFieldEditor.makeForHx(obj, cx);
        }
        boolean bl = preferBajaux = cx != null && (cx.getFacets().getb(BAJAUX_KEY, false) || cx.getFacets().get("uxFieldEditor") != null);
        if (preferBajaux && (uxEditor = BHxFieldEditor.ux(obj, cx)) != null) {
            return BHxBajauxFE.INSTANCE;
        }
        try {
            BHxFieldEditor fieldEditor = BHxFieldEditor.makeForHx(obj, cx);
            if (fieldEditor instanceof BHxDefaultFE && !preferBajaux && (uxEditor = BHxFieldEditor.ux(obj, cx)) != null) {
                return BHxBajauxFE.INSTANCE;
            }
            return fieldEditor;
        }
        catch (NoSuchAgentException e) {
            if (!preferBajaux) {
                uxEditor = BHxFieldEditor.ux(obj, cx);
                if (uxEditor != null) {
                    return BHxBajauxFE.INSTANCE;
                }
            } else if (cx.getFacets().getb(BAJAUX_COMPLEX_FALLBACK_KEY, false) && (obj instanceof BComplex || obj instanceof BIPropertyContainer)) {
                return BHxBajauxComplexFE.INSTANCE;
            }
            throw e;
        }
    }

    public static BHxFieldEditor makeForUx(BObject obj, HxOp op) {
        BHxFieldEditor editor;
        try {
            Object cx;
            if (op != null) {
                op.mergeFacets(PREFER_BAJAUX);
                op.mergeFacets(BAJAUX_COMPLEX_FALLBACK);
                cx = op;
            } else {
                cx = BFacets.make((String)BAJAUX_KEY, (BIDataValue)BBoolean.TRUE, (String)BAJAUX_COMPLEX_FALLBACK_KEY, (BIDataValue)BBoolean.TRUE);
            }
            editor = BHxFieldEditor.makeFor(obj, (Context)cx);
        }
        catch (NoSuchAgentException e) {
            editor = BHxDefaultFE.INSTANCE;
        }
        return editor;
    }

    private static BHxFieldEditor makeForHx(BObject obj, Context cx) {
        if (obj.getType().is(wbType)) {
            return BHxFieldEditor.hx(obj.getAgents(), cx);
        }
        if (cx != null && cx.getFacet("fieldEditor") != null) {
            String typeSpec = cx.getFacet("fieldEditor").toString();
            TypeInfo info = Sys.getRegistry().getType(typeSpec);
            if (info.is(hxType)) {
                return (BHxFieldEditor)info.getInstance();
            }
            return BHxFieldEditor.hx(Sys.getRegistry().getAgents(info), cx);
        }
        AgentList list = obj.getAgents().filter(BHxFieldEditor.getAgentFilter(hxFilter, cx));
        if (list.size() > 0) {
            return BHxFieldEditor.hx(list, cx);
        }
        TypeInfo info = obj.getAgents().filter(BHxFieldEditor.getAgentFilter(wbFilter, cx)).getDefault().getAgentType();
        return BHxFieldEditor.hx(Sys.getRegistry().getAgents(info), cx);
    }

    private static BHxFieldEditor ux(BObject obj, Context cx) {
        if (obj instanceof BFilterEntry || obj instanceof BPassword) {
            return null;
        }
        if (cx != null && cx.getFacets().get("uxFieldEditor") != null) {
            return BHxBajauxFE.INSTANCE;
        }
        AgentList uxList = obj.getAgents().filter(BHxFieldEditor.getAgentFilter(uxMiniFilter, cx));
        if (uxList.size() > 0) {
            return BHxBajauxFE.INSTANCE;
        }
        return null;
    }

    private static BHxFieldEditor hx(AgentList list, Context cx) {
        return (BHxFieldEditor)list.filter(BHxFieldEditor.getAgentFilter(hxFilter, cx)).getDefault().getInstance();
    }

    public final BObject fwSave(HxOp op) throws Exception {
        BObject value = this.save(op);
        this.fwValidate(value, op);
        return value;
    }

    public final BObject fwValidate(BObject value, HxOp op) throws CannotValidateException {
        BIValidator[] validators;
        for (BIValidator validator : validators = this.getValidators(op)) {
            validator.validate(value, (Context)op);
        }
        if (this instanceof BIValidator) {
            ((BIValidator)this).validate(value, (Context)op);
        }
        if (value instanceof BIValidator) {
            ((BIValidator)value).validate(value, (Context)op);
        }
        return value;
    }

    private BIValidator[] getValidators(HxOp op) {
        String[] keys;
        Array arr = new Array(BIValidator.class);
        for (String key : keys = op.getFacets().list()) {
            BObject candidate;
            if (!key.startsWith("validator")) continue;
            String spec = op.getFacets().gets(key, "");
            try {
                candidate = BTypeSpec.make((String)spec).getInstance();
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException(BWbEditor.TYPE.getModule().getModuleName(), "wbEditor.badValidatorSpec", new Object[]{key, spec}, (Throwable)e);
            }
            if (!candidate.getType().is(BIValidator.TYPE)) {
                throw new LocalizableRuntimeException(BWbEditor.TYPE.getModule().getModuleName(), "wbEditor.badValidatorType", new Object[]{key, spec});
            }
            arr.add((Object)((BIValidator)candidate));
        }
        return (BIValidator[])arr.trim();
    }

    public static AgentFilter getAgentFilter(AgentFilter filter, Context cx) {
        if (!(cx instanceof HxOp) || ((HxOp)cx).getProfile() == null) {
            return filter;
        }
        HxOp op = (HxOp)cx;
        return AgentFilter.and((AgentFilter)new WebUtil.ProfileFilter((BIWebProfile)op.getProfile(), op.get()), (AgentFilter)filter);
    }
}

