/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px.ux;

import com.tridium.ui.theme.Theme;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.security.AccessController;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.style.IStylable;
import javax.servlet.http.HttpServletRequest;

public final class UxLabelUtil {
    private static boolean LEGACY_LABEL = AccessController.doPrivileged(() -> Boolean.getBoolean("hx.label.legacy"));

    private UxLabelUtil() {
    }

    public static void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        op.addStyleSheet(BOrd.make((String)"module://bajaui/rc/bajaui.css"));
        out.w((Object)"<div ").attr("id", op.scope("label-col")).attr(" class", "ux-Label-content").w((Object)">");
        out.w((Object)"<span ").attr("id", op.scope("label-image")).attr(" class", "-t-Label-image").attr(" style", "display: none;").w((Object)">");
        HxUtil.makeImageJS(BImage.make((BOrd)BOrd.make((String)"module://hx/com/tridium/hx/images/spacer.gif")), "style='border: 0px; display: none;'", op);
        out.w((Object)"</span>");
        UxLabelUtil.writeLabelText(op);
        out.w((Object)"</div>");
    }

    public static void writeLabelText(HxOp op) throws IOException {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span ").attr("id", op.scope("label-text")).attr(" class", "-t-Label-text").w((Object)">");
        out.w((Object)"</span>");
    }

    public static void update(int width, int height, HxOp op) throws Exception {
        UxLabelUtil.update(width, height, op.getPath(), true, op);
    }

    public static void update(int width, int height, String rootScope, boolean applyBackground, HxOp op) throws Exception {
        UxLabelUtil.update(width, height, rootScope, applyBackground, null, op);
    }

    public static void update(int width, int height, String rootScope, boolean applyBackground, BInsets padding, HxOp op) throws Exception {
        PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles rootStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Styles divStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Properties divProperties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles textStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Properties textProperties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles imgStyle = new PropertiesCollection.Styles();
        BLabel label = (BLabel)op.get();
        textProperties.add("innerHTML", label.getText());
        rootStyle.add("justifyContent", UxLabelUtil.toHAlign(label.getHalign().getTag()));
        rootStyle.add("alignItems", UxLabelUtil.toVAlign(label.getValign().getTag()));
        divStyle.add("flexDirection", UxLabelUtil.toFlexDirection(label.getTextToIconAlign().getTag()));
        textStyle.add("textAlign", UxLabelUtil.toHAlignForText(label.getHalign().getTag()));
        BFont font = label.getFont();
        BBrush foreground = label.getForeground();
        if (!label.getEnabled()) {
            foreground = Theme.label().getTextDisabled((IStylable)label);
            properties.append("className", "bajaux-disabled");
        }
        boolean wordWrapEnabled = label.getWordWrapEnabled();
        if (!label.getLabelLayout().requiresMultipleLines()) {
            wordWrapEnabled = false;
        }
        HxUtil.makeFont(foreground, font, textStyle, properties, wordWrapEnabled, op);
        if (applyBackground) {
            if (label.getParentWidget() instanceof BBorderPane && label == ((BBorderPane)label.getParentWidget()).getLabel()) {
                HxUtil.makeBackground(label.getBackground(), BBrush.makeSolid((BColor)BColor.white), rootStyle, op);
            } else {
                HxUtil.makeBackground(label.getBackground(), null, rootStyle, op);
            }
        }
        properties.append("className", "ux-Label");
        boolean isCentered = label.getTextToIconAlign().getTag() == "center";
        boolean setCenterImage = false;
        BImage image = label.getImage();
        if (!image.isNull()) {
            if (!label.getText().isEmpty() && isCentered) {
                divProperties.append("className", "-t-Label-textToIconAlignCenter");
                image.syncDimensions();
                divStyle.setSnoopEnabled(false);
                divStyle.add("backgroundImage", "url(" + HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)image.getOrdList().get(0))) + ") ");
                divStyle.add("minWidth", image.getWidth() + "px");
                divStyle.add("minHeight", image.getHeight() + "px");
                setCenterImage = true;
                imgStyle.add("display", "none");
            } else {
                if (!label.getText().isEmpty()) {
                    UxLabelUtil.toTextAlignMargin(imgStyle, label.getTextToIconAlign().getTag(), label.getTextIconGap());
                }
                imgStyle.add("display", "");
                HxUtil.changeImageJS(op.scope("label-image"), image, "style='display:block;'", op);
            }
        } else {
            imgStyle.add("display", "none");
            HxUtil.changeImageJS(op.scope("label-image"), BImage.make((BOrd)BOrd.make((String)"module://hx/com/tridium/hx/images/spacer.gif")), "style='display:none;'", op);
        }
        if (!setCenterImage) {
            divStyle.add("backgroundImage", "");
            divStyle.add("minWidth", "");
            divStyle.add("minHeight", "");
        }
        op.getHtmlWriter().w((Object)("px.toggleBlink([document.getElementById('" + op.getPath() + "')], " + (label.getBlink() && HxUtil.isWidgetEffectivelyVisible((BWidget)label, width, height)) + ");"));
        if (padding != null) {
            HxUtil.makeMargin(padding, divStyle);
        }
        properties.write(rootScope, op);
        ((PropertiesCollection)rootStyle).write(rootScope, op);
        textProperties.write(op.scope("label-text"), op);
        ((PropertiesCollection)textStyle).write(op.scope("label-text"), op);
        ((PropertiesCollection)imgStyle).write(op.scope("label-image"), op);
        ((PropertiesCollection)divStyle).write(op.scope("label-col"), op);
        divProperties.write(op.scope("label-col"), op);
    }

    public static boolean hasLegacyLabel(HxOp op) {
        String param = UxLabelUtil.getLegacyLabelParam(op);
        if ("true".equals(param)) {
            return true;
        }
        if ("false".equals(param)) {
            return false;
        }
        return LEGACY_LABEL;
    }

    private static String getLegacyLabelParam(HxOp op) {
        ViewQuery query = op.getViewQuery();
        return query != null ? query.getParameter("legacyLabel", null) : null;
    }

    private static String toFlexDirection(String tag) {
        switch (tag) {
            case "top": {
                return "column-reverse";
            }
            case "left": {
                return "row-reverse";
            }
            case "bottom": {
                return "column";
            }
            case "right": {
                return "row";
            }
            case "center": {
                return "";
            }
        }
        return "";
    }

    private static String toHAlign(String tag) {
        switch (tag) {
            case "center": 
            case "fill": {
                return "center";
            }
            case "left": {
                return "flex-start";
            }
            case "right": {
                return "flex-end";
            }
        }
        return "";
    }

    private static String toVAlign(String tag) {
        switch (tag) {
            case "fill": 
            case "center": {
                return "center";
            }
            case "top": {
                return "flex-start";
            }
            case "bottom": {
                return "flex-end";
            }
        }
        return "";
    }

    private static String toHAlignForText(String tag) {
        switch (tag) {
            case "center": 
            case "fill": {
                return "center";
            }
            case "left": 
            case "right": {
                return tag;
            }
        }
        return "";
    }

    private static void toTextAlignMargin(PropertiesCollection style, String tag, double textIconGap) {
        switch (tag) {
            case "top": {
                style.append("marginTop", textIconGap + "px");
                return;
            }
            case "left": {
                style.append("marginLeft", textIconGap + "px");
                return;
            }
            case "bottom": {
                style.append("marginBottom", textIconGap + "px");
                return;
            }
            case "right": {
                style.append("marginRight", textIconGap + "px");
            }
        }
    }
}

