/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BSlider;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BSliderEvent;

public class BHxPxSlider
extends BHxPxWidget {
    public static final BHxPxSlider INSTANCE = new BHxPxSlider();
    public static final Type TYPE = Sys.loadType(BHxPxSlider.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxPxSlider() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div onmousedown='px.splitPane.doStartDrag(event, \"").w((Object)op.scope("slider")).w((Object)"\", \"").w((Object)op.scope("staticSlider")).w((Object)"\")' ").attr("id", op.scope("slider"));
        out.w((Object)"ontouchstart='px.splitPane.doStartDrag(event, \"").w((Object)op.scope("slider")).w((Object)"\", \"").w((Object)op.scope("staticSlider")).w((Object)"\")' ").attr("id", op.scope("slider"));
        out.w((Object)"></div>");
        out.w((Object)"<div ").attr("id", op.scope("staticSlider")).w((Object)"></div>");
        out.w((Object)"<div ").attr("id", op.scope("track")).w((Object)"></div>");
        BSlider slider = (BSlider)op.get();
        out.w((Object)"<input type='hidden' id='").w((Object)op.scope("slider.position")).w((Object)"' value=''>");
        op.addOnload(" hx.addFormElementToPoll(\"" + op.scope("slider.position") + "\");");
    }

    @Override
    public boolean needsUpdate(BAbsTime lastUpdate, BAbsTime lastModified) {
        return true;
    }

    @Override
    public void update(int width, int height, boolean forcedUpdate, HxOp op) throws Exception {
        int trackWidth;
        int trackHeight;
        int trackLeft;
        int trackTop;
        int divLeft;
        int divTop;
        int divWidth;
        int divHeight;
        String newPositionString;
        BSlider slider = (BSlider)op.get();
        HtmlWriter out = op.getHtmlWriter();
        PropertiesCollection.Styles dividerStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Styles staticDividerStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Styles trackStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Properties divider = new PropertiesCollection.Properties();
        PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
        if (!this.isMouseEnabled(op)) {
            op.setReadonly(true);
        }
        properties.append("className", "hxpx-slider");
        if (!op.canWrite()) {
            properties.append("className", "pxDisabled");
        }
        if (op.isUpdate() && (newPositionString = op.getFormValue("slider.position")) != null && newPositionString.length() > 0) {
            double newPosition = Double.parseDouble(newPositionString);
            newPosition = slider.getMin() + newPosition / 100.0 * (slider.getMax() - slider.getMin());
            if (newPosition != slider.getValue() && op.canWrite()) {
                slider.set(BSlider.value, (BValue)BDouble.make((double)newPosition), (Context)op);
                slider.fire(BSlider.actionPerformed, (BValue)new BSliderEvent(602, (BWidget)slider, newPosition), (Context)op);
                slider.doLayout(this.getChildWidgets((BWidget)slider, (Context)op));
            }
            out.w((Object)("hx.setFormValue('" + op.scope("slider.position") + "','');"));
        }
        dividerStyle.add("border", "1px solid black");
        dividerStyle.add("overflow", "hidden");
        staticDividerStyle.add("overflow", "hidden");
        staticDividerStyle.add("border", "1px solid black");
        dividerStyle.add("padding", "-1px");
        trackStyle.add("border", "1px solid black");
        trackStyle.add("overflow", "hidden");
        int thumbWidth = (int)Theme.slider().getThumbWidth(slider) - 2;
        if (slider.getOrientation().equals((Object)BOrientation.horizontal)) {
            divHeight = height - 2;
            divWidth = thumbWidth;
            divTop = 0;
            divLeft = (int)((double)(width - divWidth - 2) * (slider.getValue() - slider.getMin()) / (slider.getMax() - slider.getMin()));
            divider.add("dividerOrient", "horiz");
            divider.add("dividerMax", "" + (width - divWidth - 2));
            dividerStyle.add("cursor", "e-resize");
            trackTop = 4;
            trackLeft = 0;
            trackHeight = 5;
            trackWidth = width - 2;
        } else {
            trackTop = 0;
            trackLeft = 4;
            trackHeight = height - 2;
            trackWidth = 5;
            divHeight = thumbWidth;
            divWidth = width - 2;
            int initialDivHeight = height - divHeight - 2;
            divTop = initialDivHeight - (int)((double)initialDivHeight * (slider.getValue() - slider.getMin()) / (slider.getMax() - slider.getMin()));
            divLeft = 0;
            divider.add("dividerOrient", "vert");
            divider.add("dividerMax", "" + initialDivHeight);
            dividerStyle.add("cursor", "n-resize");
        }
        divider.add("title", Double.toString(slider.getValue()));
        dividerStyle.add("position", "absolute");
        dividerStyle.add("top", divTop + "px");
        dividerStyle.add("left", divLeft + "px");
        dividerStyle.add("height", divHeight + "px");
        dividerStyle.add("width", divWidth + "px");
        dividerStyle.add("zIndex", "99");
        HxUtil.makeBackground(slider.getThumbBrush(), BBrush.makeSolid((BColor)BColor.make((int)211, (int)211, (int)211, (int)191)), dividerStyle, op);
        staticDividerStyle.add("position", "absolute");
        staticDividerStyle.add("top", divTop + "px");
        staticDividerStyle.add("left", divLeft + "px");
        staticDividerStyle.add("height", divHeight + "px");
        staticDividerStyle.add("width", divWidth + "px");
        HxUtil.makeBackground(slider.getThumbBrush(), BBrush.makeSolid((BColor)BColor.lightGray), staticDividerStyle, op);
        staticDividerStyle.add("zIndex", "98");
        trackStyle.add("position", "absolute");
        trackStyle.add("top", trackTop + "px");
        trackStyle.add("left", trackLeft + "px");
        trackStyle.add("height", trackHeight + "px");
        trackStyle.add("width", trackWidth + "px");
        HxUtil.makeBackground(slider.getTrackBrush(), BBrush.makeSolid((BColor)BColor.gray), trackStyle, op);
        out.write("if(px.splitPane.dragObj.elNode==null) {");
        ((PropertiesCollection)dividerStyle).write(op.scope("slider"), op);
        out.write("};");
        ((PropertiesCollection)trackStyle).write(op.scope("track"), op);
        ((PropertiesCollection)staticDividerStyle).write(op.scope("staticSlider"), op);
        divider.write(op.scope("slider"), op);
        properties.write(op);
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        String newPositionString;
        BSlider slider = (BSlider)op.get();
        if (op.isUpdate() && (newPositionString = op.getFormValue("slider.position")) != null && newPositionString.length() > 0) {
            double newPosition = Double.parseDouble(newPositionString);
            double newValue = newPosition / 100.0 * (slider.getMax() - slider.getMin()) + slider.getMin();
            if (!this.isMouseEnabled(op)) {
                op.setReadonly(true);
            }
            if (newValue != slider.getValue() && op.canWrite()) {
                slider.set(BSlider.value, (BValue)BDouble.make((double)newValue), (Context)op);
                slider.fire(BSlider.actionPerformed, (BValue)new BSliderEvent(602, (BWidget)slider, newPosition), (Context)op);
                slider.doLayout(this.getChildWidgets((BWidget)slider, (Context)op));
                return BDouble.make((double)newValue);
            }
        }
        return BDouble.make((double)slider.getValue());
    }
}

