/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.hx.px.ux.UxLabelUtil;
import com.tridium.ui.theme.Theme;
import java.io.IOException;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.RectGeom;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.style.IStylable;

public class BHxPxLabel
extends BHxPxWidget {
    public static final BHxPxLabel INSTANCE = new BHxPxLabel();
    public static final Type TYPE = Sys.loadType(BHxPxLabel.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxPxLabel() {
    }

    @Override
    public boolean needsOverflowVisible(HxOp op) {
        return !UxLabelUtil.hasLegacyLabel(op);
    }

    @Override
    public void write(HxOp op) throws Exception {
        if (!UxLabelUtil.hasLegacyLabel(op)) {
            UxLabelUtil.write(op);
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div ").attr("id", op.scope("background")).attr("class", "hxpx-background").w((Object)">");
        out.w((Object)"</div>");
        out.w((Object)"<div ").attr("id", op.scope("backgroundImage")).attr("class", "hxpx-background-image").w((Object)">");
        out.w((Object)"</div>");
        out.w((Object)"<table ").attr("id", op.scope("border")).attr("class", "hxpx-border").w((Object)">");
        out.w((Object)"</table>");
        out.w((Object)"<a ").attr("id", op.scope("aImage")).w((Object)">");
        HxUtil.makeImageJS(BImage.make((BOrd)BOrd.make((String)"module://hx/com/tridium/hx/images/spacer.gif")), "style='border: 0px; display: none;'", op);
        out.w((Object)"</a>");
        this.writeLabelText(op);
        String quote = HxUtil.getOuterQuote(op);
        op.addOnload("px.activeFix(" + quote + op.getPath() + quote + ");");
    }

    protected void writeLabelText(HxOp op) throws IOException {
        if (!UxLabelUtil.hasLegacyLabel(op)) {
            UxLabelUtil.writeLabelText(op);
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<a ").attr("id", op.scope("aText")).w((Object)">");
        out.w((Object)"<span ").attr("id", op.scope("left")).attr("style", "float: left").w((Object)">");
        out.w((Object)"</span>");
        out.w((Object)"<span ").attr("id", op.scope("text")).attr("class", "ux-select-none").w((Object)">");
        out.w((Object)"</span>");
        out.w((Object)"<span ").attr("id", op.scope("right")).attr("style", "float: right").w((Object)">");
        out.w((Object)"</span>");
        out.w((Object)"</a>");
    }

    @Override
    public void update(int width, int height, boolean forcedUpdate, HxOp op) throws Exception {
        if (!UxLabelUtil.hasLegacyLabel(op)) {
            UxLabelUtil.update(width, height, op);
            return;
        }
        BLabel label = (BLabel)op.get();
        BLabel.Layout labelLayout = label.getLabelLayout();
        RectGeom iGeom = labelLayout.getImageGeom();
        RectGeom tGeom = labelLayout.getTextGeom();
        HtmlWriter out = op.getHtmlWriter();
        PropertiesCollection.Styles style = new PropertiesCollection.Styles();
        PropertiesCollection.Styles spanStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Properties spanProperties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles anchorStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Styles imgAnchorStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles backgroundStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Styles textIconAlignStyle = new PropertiesCollection.Styles();
        PropertiesCollection.Styles textAlignProperties = new PropertiesCollection.Styles();
        PropertiesCollection.Styles floatStyle = new PropertiesCollection.Styles();
        properties.append("className", "hxpx-label");
        boolean floatImage = false;
        if (!label.getText().isEmpty() && label.getTextToIconAlign().equals((Object)BAlign.right) && label.getHalign().equals((Object)BHalign.right)) {
            floatImage = true;
            out.w((Object)"px.move('").w((Object)op.scope("aImage")).w((Object)"','").w((Object)op.scope("left")).w((Object)"');");
            floatStyle.add("padding-right", label.getTextIconGap() + "px");
            ((PropertiesCollection)floatStyle).write(op.scope("left"), op);
        } else if (!label.getText().isEmpty() && (label.getTextToIconAlign().equals((Object)BAlign.left) && label.getHalign().equals((Object)BHalign.center) || label.getTextToIconAlign().equals((Object)BAlign.left) && label.getHalign().equals((Object)BHalign.left))) {
            floatImage = true;
            out.w((Object)"px.move('").w((Object)op.scope("aImage")).w((Object)"','").w((Object)op.scope("right")).w((Object)"');");
            floatStyle.add("padding-left", label.getTextIconGap() + "px");
            ((PropertiesCollection)floatStyle).write(op.scope("right"), op);
        } else {
            imgAnchorStyle.add("left", (int)(iGeom.x() + labelLayout.getAlignmentOffsets().x()) + "px");
        }
        if (!floatImage) {
            imgAnchorStyle.add("top", iGeom.y() + labelLayout.getAlignmentOffsets().y() + "px");
            imgAnchorStyle.add("position", "absolute");
        }
        double spanTop = tGeom.y() + labelLayout.getAlignmentOffsets().y() - labelLayout.getLineHeight() + labelLayout.getLayoutFont().getDescent();
        anchorStyle.add("top", spanTop + "px");
        if (!label.getHalign().equals((Object)BHalign.right)) {
            anchorStyle.add("left", tGeom.x() + labelLayout.getAlignmentOffsets().x() + "px");
        } else {
            anchorStyle.add("right", label.getWidth() - (tGeom.width() + tGeom.x() + labelLayout.getAlignmentOffsets().x()) + "px");
        }
        anchorStyle.add("position", "absolute");
        BAlign textIconAlign = label.getTextToIconAlign();
        spanProperties.add("innerHTML", label.getText());
        BOrd image = BOrd.NULL;
        if (label.getImage().getOrdList().size() != 0) {
            image = label.getImage().getOrdList().get(0);
        }
        if (image.isNull()) {
            HxUtil.changeImageJS(op.scope("aImage"), BImage.make((BOrd)BOrd.make((String)"module://hx/com/tridium/hx/images/spacer.gif")), "style='display:none;'", op);
        } else {
            HxUtil.changeImageJS(op.scope("aImage"), BImage.make((BOrd)image), "style='display:block;'", op);
        }
        BBrush foreground = label.getForeground();
        if (!label.getEnabled()) {
            foreground = Theme.label().getTextDisabled((IStylable)label);
            properties.append("className", "pxDisabled");
        }
        BFont font = label.getFont();
        HxUtil.makeFont(foreground, font, spanStyle, properties, label.getWordWrapEnabled(), op);
        if (label.getParentWidget() instanceof BBorderPane && label == ((BBorderPane)label.getParentWidget()).getLabel()) {
            HxUtil.makeBackground(label.getBackground(), BBrush.makeSolid((BColor)BColor.white), backgroundStyle, op);
        } else {
            HxUtil.makeBackground(label.getBackground(), null, backgroundStyle, op);
        }
        HxUtil.makeAlignment(label.getHalign(), label.getValign(), style);
        HxUtil.makeAlignment(label.getHalign(), label.getValign(), textAlignProperties);
        if (!textIconAlign.equals((Object)BAlign.center)) {
            HxUtil.makeAlignment(null, label.getValign(), textIconAlignStyle);
        }
        style.add("cursor", "default");
        out.w((Object)("px.toggleBlink([document.getElementById('" + op.getPath() + "')], " + (label.getBlink() && HxUtil.isWidgetEffectivelyVisible((BWidget)label, width, height)) + ");"));
        properties.write(op);
        ((PropertiesCollection)spanStyle).write(op.scope("text"), op);
        spanProperties.write(op.scope("text"), op);
        style.write(op);
        ((PropertiesCollection)imgAnchorStyle).write(op.scope("aImage"), op);
        ((PropertiesCollection)anchorStyle).write(op.scope("aText"), op);
        ((PropertiesCollection)backgroundStyle).write(op.scope("background"), op);
        ((PropertiesCollection)textIconAlignStyle).write(op.scope(textIconAlign.getTag()), op);
        ((PropertiesCollection)textAlignProperties).write(op.scope("center"), op);
    }
}

