/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.hx.gx.HxGraphics;
import com.tridium.hx.gx.HxSvgGraphics;
import com.tridium.hx.gx.IHxGraphics;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.hx.HxOp;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.shape.BShape;

public class BHxPxGraphics
extends BHxPxWidget {
    public static final BHxPxGraphics INSTANCE = new BHxPxGraphics();
    public static final Type TYPE = Sys.loadType(BHxPxGraphics.class);
    private static final double INVERSE_TANGENT_MITER_LIMIT = 5.6713;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxPxGraphics() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        if (this.hasSvgGraphics(op)) {
            out.w((Object)"<svg ").attr("class", "hxpx-graphics").attr(" id", op.scope("canvas")).w((Object)"></svg>");
        } else {
            out.w((Object)"<canvas ").attr("class", "hxpx-graphics").attr(" width", 0).attr(" height", 0).attr(" id", op.scope("canvas")).w((Object)"></canvas>");
        }
    }

    protected void updateStyle(HxOp op) throws Exception {
        PropertiesCollection.Styles styles = new PropertiesCollection.Styles();
        styles.add("overflow", "visible");
        if (this.hasSvgGraphics(op)) {
            styles.add("pointerEvents", "none");
        }
        styles.write(op);
    }

    @Override
    public void update(int width, int height, boolean forceUpdate, HxOp op) throws Exception {
        BWidget widget = (BWidget)op.get();
        int penOffset = BHxPxGraphics.getPenOffset((BObject)widget);
        height = Math.max(0, height) + penOffset * 2;
        width = Math.max(0, width) + penOffset * 2;
        PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
        PropertiesCollection.Styles canvasStyles = new PropertiesCollection.Styles();
        if (this.hasSvgGraphics(op)) {
            op.getHtmlWriter().w((Object)"px.setSvgDimensions('").w((Object)op.scope("canvas")).w((Object)"',").w(width).w((Object)",").w(height).w((Object)");");
        } else {
            properties.add("height", String.valueOf(height));
            properties.add("width", String.valueOf(width));
            properties.write(op.scope("canvas"), op);
        }
        this.updateStyle(op);
        canvasStyles.add("top", -penOffset + "px");
        canvasStyles.add("left", -penOffset + "px");
        ((PropertiesCollection)canvasStyles).write(op.scope("canvas"), op);
        HxGraphics g = this.hasSvgGraphics(op) ? HxSvgGraphics.makeSvg(op, op.scope("canvas"), Math.max(0, width), Math.max(0, height)) : HxGraphics.make(op, op.scope("canvas"), Math.max(0, width), Math.max(0, height));
        g.push();
        g.clear(width, height);
        g.transform(BTransform.makeTranslate((double)penOffset, (double)penOffset));
        g.transform(this.getTransformations(op));
        this.paint(g, op);
        g.pop();
        g.dispose();
    }

    private void dump(BWidget widget, IHxGraphics g) {
        widget.layout();
        g.push();
        g.translate(widget.getX(), widget.getY());
        g.clip(0.0, 0.0, widget.getWidth(), widget.getHeight());
        g.strokeRect(-1.0, -1.0, widget.getWidth() - 2.0, widget.getHeight() - 2.0);
        g.drawString(widget.getTypeDisplayName(null), 0.0, 0.0);
        BWidget[] widgets = widget.getChildWidgets();
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i].isNull() || !widgets[i].isVisible() || widgets[i].getHeight() == 0.0 && widgets[i].getWidth() == 0.0) continue;
            this.dump(widgets[i], g);
        }
        g.pop();
    }

    public BTransform getTransformations(HxOp op) {
        return null;
    }

    public void paint(IHxGraphics g, HxOp op) {
        BWidget widget = (BWidget)op.get();
        widget.paint((Graphics)g);
    }

    public static int getPenOffset(BObject widget) {
        if (widget instanceof BShape) {
            return Math.max((int)Math.ceil(((BShape)widget).getPen().getWidth() * 5.6713), 0);
        }
        return 0;
    }

    public boolean hasSvgGraphics(HxOp op) {
        String svgParam = BHxPxGraphics.getSvgParam(op);
        if ("true".equals(svgParam)) {
            return true;
        }
        if ("false".equals(svgParam)) {
            return false;
        }
        return false;
    }

    protected static String getSvgParam(HxOp op) {
        ViewQuery query = op.getViewQuery();
        return query != null ? query.getParameter("svg", null) : null;
    }
}

