/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.hx.px.BHxPxWbView;
import com.tridium.hx.px.BHxWidgetShell;
import com.tridium.ui.theme.Theme;
import java.io.Writer;
import java.security.AccessController;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.gx.IRectGeom;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxView;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.hx.px.MouseEventCommand;
import javax.baja.hx.px.binding.BHxPxBinding;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.web.BIWebProfile;
import javax.baja.workbench.view.BWbView;

public class BHxHtmlPxView
extends BHxPxView {
    public static final BHxHtmlPxView INSTANCE = new BHxHtmlPxView();
    public static final Type TYPE = Sys.loadType(BHxHtmlPxView.class);
    private static boolean warnedMismatchTheme = false;
    public static boolean USE_SESSION_GEOM = AccessController.doPrivileged(() -> Boolean.getBoolean("hx.sessionGeom"));

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxHtmlPxView() {
    }

    public BHxHtmlPxView(BAbstractPxView pxView) {
        super(pxView);
    }

    @Override
    protected void doWrite(BWidget root, HxOp op) throws Exception {
        op.addJavaScript(BOrd.make((String)"module://hx/com/tridium/hx/px/hxPx.js"));
        op.jQuery();
        BDynamicEnum theme = (BDynamicEnum)op.getProfileConfig().get("selectedHxTheme");
        String userThemeName = Objects.toString(theme != null ? theme.getTag() : null, "");
        if (!(warnedMismatchTheme || userThemeName.isEmpty() || userThemeName.equals(Theme.getInstalledThemeName()))) {
            BHxPxView.log.log(Level.WARNING, "Station Theme differs from Selected Hx Theme for " + op.getUser().getUsername() + ": " + Theme.getInstalledThemeName() + " != " + userThemeName);
            warnedMismatchTheme = true;
        }
        HtmlWriter out = op.getHtmlWriter();
        IRectGeom geom = this.getContentGeom(op);
        try {
            HxOp hxpxOp = op.make("root", (BObject)root, op.getFacets());
            if (geom == null) {
                out.w((Object)"<div ").attr("id", op.scope("hxPx")).attr(" class", "hxPx").attr(" style", "width:0px;height:0px;").w((Object)">");
            } else {
                root.setBounds(geom.x(), geom.y(), geom.width(), geom.height());
                String style = "width:" + (int)geom.width() + "px;height:" + (int)geom.height() + "px;visibility:inherit;overflow:hidden;";
                out.w((Object)"<div").attr(" id", op.scope("hxPx")).attr(" class", "hxPx").attr(" style", style).w((Object)">");
            }
            try {
                this.doWriteWidget(hxpxOp);
            }
            catch (Exception e) {
                op.sendError(e);
            }
            out.w((Object)"</div>");
            if (geom != null) {
                op.addOnload("hx.setFormValue(\"" + op.scope("_lastUpdated") + "\", " + Clock.time().getMillis() + "); hx.addFormElementToPoll(\"" + op.scope("_lastUpdated") + "\");");
            } else {
                op.addOnload("hx.setFormValue(\"" + op.scope("_lastUpdated") + "\", 0); hx.addFormElementToPoll(\"" + op.scope("_lastUpdated") + "\");");
            }
            String resizeArguments = "\"" + op.scope("_lastUpdated") + "\"";
            if (geom != null) {
                resizeArguments = resizeArguments + "," + (geom.width() + geom.x()) + "," + (geom.height() + geom.y());
            }
            op.addOnresize("px.resize(" + resizeArguments + ");");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWriteWidget(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BWidget widget = (BWidget)op.get();
        if (widget instanceof BNullWidget) {
            return;
        }
        BHxPxWidget hxPxWidget = null;
        try {
            hxPxWidget = BHxPxWidget.makeFor((BObject)widget, (Context)op);
        }
        catch (NoSuchAgentException e) {
            log.warning("No BHxPxWidget for " + widget.getTypeDisplayName((Context)op) + " (" + widget.getType() + ")");
        }
        BWidget[] children = hxPxWidget != null ? hxPxWidget.getChildWidgets(widget, (Context)op) : new BWidget[]{};
        if (log.isLoggable(Level.FINE)) {
            out.w((Object)"\n\n");
            out.w((Object)"<!-- path: ").w((Object)op.getPath()).w((Object)" -->\n");
            if (hxPxWidget != null) {
                out.w((Object)"<!-- view: ").w((Object)hxPxWidget.getType()).w((Object)" -->\n");
            }
            out.w((Object)"<!-- widget: ").w((Object)widget.getType()).w((Object)" -->\n");
        }
        if (!(widget instanceof BLabelPane)) {
            out.w((Object)"<div style='visibility:hidden;' ").attr(" id", op.getPath()).w((Object)">");
            if (widget instanceof BCanvasPane) {
                out.w((Object)"<div ").attr(" id", op.scope("scale")).w((Object)">");
            }
        }
        for (BBinding binding : widget.getBindings()) {
            HxOp bindingOp = op.make(new OrdTarget((OrdTarget)op, (BObject)binding));
            if (log.isLoggable(Level.FINE)) {
                out.w((Object)"\n\n");
                out.w((Object)"<!-- binding:").w((Object)binding.getType()).w((Object)" -->\n");
                out.w((Object)"<!-- binding.path:").w((Object)bindingOp.getPath()).w((Object)" -->\n");
            }
            try {
                BHxPxBinding hxBinding = BHxPxBinding.makeFor(binding, (Context)bindingOp);
                if (log.isLoggable(Level.FINE)) {
                    out.w((Object)"<!-- binding.agent:").w((Object)hxBinding.getType()).w((Object)" -->\n");
                }
                hxBinding.write(bindingOp);
            }
            catch (NoSuchAgentException nsae) {
                if (!log.isLoggable(Level.FINE)) continue;
                out.w((Object)"<!-- binding.agent: none -->\n");
            }
        }
        if (hxPxWidget != null) {
            hxPxWidget.write(op);
            out.w((Object)"\n");
            Writer writer = HxUtil.startOnloadWriter(op);
            try {
                MouseEventCommand mouseHandler = hxPxWidget.getMouseEventHandler();
                PropertiesCollection.Events events = new PropertiesCollection.Events();
                if (mouseHandler != null) {
                    hxPxWidget.registerEvent(hxPxWidget.getMouseEventHandler(), "mouseEventHandler");
                    if (hxPxWidget.isEventRegistered(hxPxWidget.mouseEventCommand)) {
                        events.add("onmousedown", mouseHandler.getInvokeCode(501, op));
                    }
                } else {
                    events.add("onmousedown", "hx.stopEventPropagation(event);");
                }
                events.add("oncontextmenu", "return hx.stopEventPropagation(event);");
                events.write(op);
            }
            finally {
                HxUtil.finishOnloadWriter(writer, op);
            }
        }
        for (BWidget kid : children) {
            HxOp childOp = op.make(new OrdTarget((OrdTarget)op, (BObject)kid));
            this.doWriteWidget(childOp);
        }
        if (!(widget instanceof BLabelPane)) {
            out.w((Object)"</div>");
            if (widget instanceof BCanvasPane) {
                out.w((Object)"</div>");
            }
        }
        out.w((Object)"\n");
        Writer writer = HxUtil.startOnloadWriter(op);
        try {
            if (widget.getParentWidget() instanceof BWidgetShell) {
                this.doUpdateWidget(op.getHtmlWriter(), true, true, true, BAbsTime.NULL, op);
            }
        }
        finally {
            HxUtil.finishOnloadWriter(writer, op);
        }
    }

    private boolean needsOverflowAuto(HxOp op) {
        if (op.get() instanceof BWbView) {
            BWbView wbView = (BWbView)op.get();
            BHxView hxView = BHxPxWbView.getAgent(wbView, (BIWebProfile)op.getProfile(), (Context)op);
            return !(hxView instanceof BHxPxWbView);
        }
        return false;
    }

    private BAbsTime getLastUpdate(HxOp op) {
        String lastUpdateStr;
        BAbsTime lastUpdate = BAbsTime.NULL;
        if (op.isUpdate() && (lastUpdateStr = op.getFormValue("_lastUpdated")) != null) {
            lastUpdate = BAbsTime.make((long)Long.parseLong(lastUpdateStr));
        }
        return lastUpdate;
    }

    @Override
    protected void doUpdate(BWidget widget, HxOp op) throws Exception {
        BAbsTime lastUpdate = this.getLastUpdate(op);
        boolean forceUpdate = lastUpdate.isNull();
        IRectGeom geom = this.getContentGeom(op);
        if (geom == null) {
            return;
        }
        int width = (int)geom.width();
        int height = (int)geom.height();
        int left = (int)geom.x();
        int top = (int)geom.y();
        widget.setBounds((double)left, (double)top, (double)width, (double)height);
        if (forceUpdate) {
            PropertiesCollection.Styles style = new PropertiesCollection.Styles();
            style.add("width", width + "px");
            style.add("height", height + "px");
            if (!HxUtil.isWidgetEffectivelyVisible(widget, width, height)) {
                style.add("visibility", "hidden");
            } else {
                style.add("visibility", "inherit");
            }
            style.add("overflow", "hidden");
            ((PropertiesCollection)style).write(op.scope("hxPx"), op);
        }
        HxOp hxpxOp = op.make("root", (BObject)widget, op.getFacets());
        HtmlWriter out = op.getHtmlWriter();
        this.doUpdateWidget(out, forceUpdate, true, false, lastUpdate, hxpxOp);
        BHxHtmlPxView.getShell(widget).ifSyncRequired(() -> {
            log.fine("syncRequired");
            this.doUpdateWidget(out, true, true, false, lastUpdate, hxpxOp);
        });
        out.w((Object)"hx.setFormValue('").w((Object)op.scope("_lastUpdated")).w((Object)("', " + Clock.time().getMillis() + ");"));
        out.w((Object)"px.fixResize();");
    }

    void doUpdateWidget(HtmlWriter out, boolean forceUpdate, boolean updateChildren, boolean fromWrite, BAbsTime lastUpdate, HxOp op) {
        BWidget widget = (BWidget)op.get();
        try {
            BHxPxWidget hxPxWidget;
            try {
                hxPxWidget = BHxPxWidget.makeFor((BObject)widget, (Context)op);
            }
            catch (NoSuchAgentException e) {
                return;
            }
            BWidget[] children = hxPxWidget != null ? hxPxWidget.getChildWidgets(widget, (Context)op) : new BWidget[]{};
            boolean requestsUpdate = true;
            BAbsTime widgetLastModified = BHxHtmlPxView.getShell(widget).getLastModified(widget);
            if (hxPxWidget != null) {
                requestsUpdate = hxPxWidget.needsUpdate(lastUpdate, widgetLastModified);
            }
            if (!requestsUpdate && !forceUpdate) {
                if (log.isLoggable(Level.FINE)) {
                    out.w((Object)"\n");
                    out.w((Object)"// [not updated]\n");
                    out.w((Object)"// path:").w((Object)op.getPath()).w((Object)"\n");
                    out.w((Object)"// widget:").w((Object)widget.getType()).w((Object)"\n");
                    out.w((Object)"\n");
                }
            } else {
                IRectGeom contentGeom = this.getContentGeom(op);
                if (contentGeom != null) {
                    try {
                        if (widget.getParentWidget() instanceof BWidgetShell) {
                            widget.computePreferredSize();
                        }
                        widget.doLayout(children);
                    }
                    catch (Exception e) {
                        log.log(Level.FINE, "HxPx Layout Exception", e);
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Restarting update, Context Geom is required");
                    }
                    if (!fromWrite) {
                        out.w((Object)"hx.poll();");
                    }
                    return;
                }
                IRectGeom geom = hxPxWidget.getGeom(widget, op);
                if (log.isLoggable(Level.FINE)) {
                    StringBuilder b = new StringBuilder();
                    b.append("\n");
                    b.append("// path:").append(op.getPath()).append("\n");
                    b.append("// view:").append(hxPxWidget.getType()).append("\n");
                    b.append("// widget:").append(widget.getType()).append("\n");
                    b.append("// geom:").append(geom).append("\n");
                    out.w((Object)b.toString());
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(b.toString());
                    }
                }
                int width = (int)(geom.width() + 0.5);
                int height = (int)(geom.height() + 0.5);
                int left = (int)(geom.x() + 0.5);
                int top = (int)(geom.y() + 0.5);
                if (!(widget instanceof BLabelPane)) {
                    String overflow;
                    PropertiesCollection.Styles style = new PropertiesCollection.Styles();
                    style.add("width", geom.width() + "px");
                    style.add("height", geom.height() + "px");
                    if (widget.getParentWidget() instanceof BWidgetShell) {
                        style.add("position", "relative");
                    } else {
                        style.add("top", geom.y() + "px");
                        style.add("left", geom.x() + "px");
                        style.add("position", "absolute");
                    }
                    if (!HxUtil.isWidgetEffectivelyVisible(widget, width, height)) {
                        style.add("visibility", "hidden");
                    } else {
                        style.add("visibility", "inherit");
                    }
                    String string = overflow = this.needsOverflowAuto(op) || hxPxWidget.needsOverflowAuto(op) ? "auto" : "hidden";
                    if (hxPxWidget.needsOverflowVisible(op)) {
                        overflow = "";
                    }
                    style.add("overflow", overflow);
                    style.write(op);
                }
                if (log.isLoggable(Level.FINE)) {
                    out.w((Object)"try {");
                }
                hxPxWidget.update(width, height, forceUpdate, op);
                for (BBinding binding : widget.getBindings()) {
                    HxOp bindingOp = op.make(new OrdTarget((OrdTarget)op, (BObject)binding));
                    if (log.isLoggable(Level.FINE)) {
                        out.w((Object)"// binding:").w((Object)binding.getType()).w((Object)"\n");
                        out.w((Object)"// binding.path:").w((Object)bindingOp.getPath()).w((Object)"\n");
                    }
                    try {
                        BHxPxBinding hxBinding = BHxPxBinding.makeFor(binding, (Context)bindingOp);
                        if (log.isLoggable(Level.FINE)) {
                            out.w((Object)"// binding.agent:").w((Object)hxBinding.getType()).w((Object)"\n");
                        }
                        hxBinding.update((int)geom.width(), (int)geom.height(), forceUpdate, bindingOp);
                    }
                    catch (NoSuchAgentException nsae) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        out.w((Object)"// binding.agent: none\n");
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    out.w((Object)"} catch(err) {");
                    out.w((Object)("err.description='" + op.getPath() + " '+err.description;"));
                    out.w((Object)"alert(err.description);");
                    out.w((Object)"}");
                }
            }
            if (updateChildren) {
                for (BWidget kid : children) {
                    HxOp childOp = op.make(new OrdTarget((OrdTarget)op, (BObject)kid));
                    this.doUpdateWidget(op.getHtmlWriter(), forceUpdate, updateChildren, false, lastUpdate, childOp);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error styling widget " + widget.getType(), e);
        }
    }

    @Override
    public boolean doProcess(BWidget root, HxOp op) throws Exception {
        return this.doProcess(op.make("root", (BObject)root, op.getFacets()));
    }

    public boolean doProcess(HxOp op) throws Exception {
        BHxPxWidget hxPxWidget;
        BWidget widget = (BWidget)op.get();
        try {
            hxPxWidget = BHxPxWidget.makeFor((BObject)widget, (Context)op);
        }
        catch (NoSuchAgentException e) {
            return false;
        }
        if (hxPxWidget.process(op)) {
            return true;
        }
        for (BBinding bBinding : widget.getBindings()) {
            HxOp bindingOp = op.make(new OrdTarget((OrdTarget)op, (BObject)bBinding));
            try {
                BHxPxBinding binding = BHxPxBinding.makeFor(bBinding, (Context)bindingOp);
                if (!binding.process(bindingOp)) continue;
                return true;
            }
            catch (NoSuchAgentException noSuchAgentException) {
                // empty catch block
            }
        }
        for (BBinding bBinding : hxPxWidget.getChildWidgets(widget, (Context)op)) {
            HxOp childOp = op.make(new OrdTarget((OrdTarget)op, (BObject)bBinding));
            if (!this.doProcess(childOp)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BObject doSave(BWidget root, HxOp op) throws Exception {
        return this.doSave(op.make("root", (BObject)root, op.getFacets()));
    }

    public BObject doSave(HxOp op) throws Exception {
        BWidget[] children;
        BHxPxWidget hxPxWidget;
        BWidget widget = (BWidget)op.get();
        try {
            hxPxWidget = BHxPxWidget.makeFor((BObject)widget, (Context)op);
        }
        catch (NoSuchAgentException e) {
            return null;
        }
        BObject saved = hxPxWidget.save(op);
        for (BBinding binding : widget.getBindings()) {
            HxOp bindingOp = op.make(new OrdTarget((OrdTarget)op, (BObject)binding));
            try {
                BHxPxBinding hxBinding = BHxPxBinding.makeFor(binding, (Context)bindingOp);
                hxBinding.save(saved, bindingOp);
            }
            catch (NoSuchAgentException hxBinding) {
                // empty catch block
            }
        }
        for (BWidget kid : children = hxPxWidget.getChildWidgets(widget, (Context)op)) {
            HxOp childOp = op.make(new OrdTarget((OrdTarget)op, (BObject)kid));
            this.doSave(childOp);
        }
        return saved;
    }

    private static BHxWidgetShell getShell(BWidget widget) {
        return (BHxWidgetShell)widget.getShell();
    }
}

