/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.hx.fieldeditors.BHxAbsTimeFE;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import java.io.Writer;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public class BHxDynamicTimeRangeFE
extends BHxFieldEditor {
    private static final LexiconModule lex = LexiconModule.make((String)"bql");
    public static final BHxDynamicTimeRangeFE INSTANCE = new BHxDynamicTimeRangeFE();
    public static final Type TYPE = Sys.loadType(BHxDynamicTimeRangeFE.class);
    ChangeCommand changeCommand = new ChangeCommand(this);
    RangeDialogCommand rangeDialogCommand;
    DialogChangeCommand dialogChangeCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxDynamicTimeRangeFE() {
        this.registerEvent(this.changeCommand);
        this.rangeDialogCommand = new RangeDialogCommand(this);
        this.registerEvent(this.rangeDialogCommand);
        this.dialogChangeCommand = new DialogChangeCommand(this);
        this.registerEvent(this.dialogChangeCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(HxOp op) throws Exception {
        BDynamicTimeRange range = (BDynamicTimeRange)op.get();
        BDynamicTimeRangeType rangeType = range.getRangeType();
        HtmlWriter out = op.getHtmlWriter();
        String timeRangeEditorKey = op.scope("timeRangeEditor");
        out.w((Object)"<table cellspacing='0' cellpadding='0' width='100%' height='100%' valign='middle'><tr><td>");
        out.w((Object)"<select id='").w((Object)timeRangeEditorKey).w((Object)"'");
        out.w((Object)" name='").w((Object)timeRangeEditorKey).w((Object)"'");
        if (!op.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)" onchange='").w((Object)this.changeCommand.getInvokeCode(op)).w((Object)"'");
        out.w((Object)">");
        BEnumRange enumrange = BDynamicTimeRangeType.timeRange.getRange();
        int[] ords = enumrange.getOrdinals();
        for (int i = 0; i < ords.length; ++i) {
            out.w((Object)"<option");
            out.w((Object)" value='").w((Object)enumrange.getTag(ords[i])).w((Object)"'");
            if (ords[i] == rangeType.getOrdinal()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">");
            out.safe((Object)String.valueOf(enumrange.getDisplayTag(ords[i], (Context)op)));
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
        out.w((Object)"<span id='").w((Object)op.scope("timeRangeStr")).w((Object)"' style='padding-left: 10px;'>");
        BAbsTime startTime = range.getStartTime(BAbsTime.now());
        BAbsTime stopTime = range.getEndTime(BAbsTime.now());
        if (startTime.isNull()) {
            out.w((Object)"?");
        } else {
            out.safe((Object)startTime.toString((Context)op));
        }
        out.w((Object)" ").safe((Object)lex.getText("dynamicTimeRangeFE.to", (Context)op)).w((Object)" ");
        if (stopTime.isNull()) {
            out.safe((Object)"?");
        } else {
            out.safe((Object)stopTime.toString((Context)op));
        }
        out.w((Object)"</span>");
        out.w((Object)"<a style='margin-left: 10px;' id='").w((Object)op.scope("timeRangeIcon")).w((Object)"' href='javascript: ").w((Object)this.rangeDialogCommand.getInvokeCode(op)).w((Object)"'>");
        HxUtil.makeImageJS(BImage.make((BIcon)BIcon.std((String)"clock.png")), "style='border: 0px;'", null, null, op);
        out.w((Object)"</a>");
        out.w((Object)"<input type='hidden' value='").w(range.getFixedStartTime().getMillis()).w((Object)"' id='").w((Object)op.scope("rangeStart")).w((Object)"' name='").w((Object)op.scope("rangeStart")).w((Object)"'/>");
        out.w((Object)"<input type='hidden' value='").w(range.getFixedEndTime().getMillis()).w((Object)"' id='").w((Object)op.scope("rangeStop")).w((Object)"' name='").w((Object)op.scope("rangeStop")).w((Object)"'/>");
        out.w((Object)"</td></tr></table>");
        Writer writer = HxUtil.startOnloadWriter(op);
        try {
            out = op.getHtmlWriter();
            out.w((Object)("hx.addFormElementToPoll('" + op.scope("rangeStart") + "');"));
            out.w((Object)("hx.addFormElementToPoll('" + op.scope("rangeStop") + "');"));
            out.w((Object)("hx.addFormElementToPoll('" + op.scope("timeRangeEditor") + "');"));
        }
        finally {
            HxUtil.finishOnloadWriter(writer, op);
        }
    }

    @Override
    public void update(HxOp op) throws Exception {
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BDynamicTimeRange timeRange;
        BDynamicTimeRangeType rangeType = BDynamicTimeRangeType.make((String)op.getFormValue("timeRangeEditor"));
        if (rangeType.equals((Object)BDynamicTimeRangeType.timeRange)) {
            BAbsTime start = op.getFormValue("rangeStart") != null ? BAbsTime.make((long)Long.parseLong(op.getFormValue("rangeStart"))) : BAbsTime.NULL;
            BAbsTime stop = op.getFormValue("rangeStop") != null ? BAbsTime.make((long)Long.parseLong(op.getFormValue("rangeStop"))) : BAbsTime.NULL;
            timeRange = BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)stop);
        } else {
            timeRange = BDynamicTimeRange.make((BDynamicTimeRangeType)rangeType);
        }
        return timeRange;
    }

    protected BValue saveContent(HxOp op) throws Exception {
        BAbsTime start = BAbsTime.NULL;
        BAbsTime end = BAbsTime.NULL;
        if (!"null".equals(op.getFormValue("startTimeNull"))) {
            HxOp startOp = op.make("startRange", new OrdTarget((OrdTarget)op, (BObject)start));
            start = (BAbsTime)BHxAbsTimeFE.INSTANCE.fwSave(startOp);
        }
        if (!"null".equals(op.getFormValue("endTimeNull"))) {
            HxOp endOp = op.make("endRange", new OrdTarget((OrdTarget)op, (BObject)end));
            end = (BAbsTime)BHxAbsTimeFE.INSTANCE.fwSave(endOp);
        }
        BDynamicTimeRange range = BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)end);
        return range;
    }

    private class DialogChangeCommand
    extends Command {
        public DialogChangeCommand(BHxView view) {
            super(view);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            HxOp startOp = op.make("startRange", new OrdTarget((OrdTarget)op, (BObject)Clock.time()));
            startOp.setReadonly("null".equals(op.getFormValue("startTimeNull")));
            BHxAbsTimeFE.INSTANCE.update(startOp);
            HxOp endOp = op.make("endRange", new OrdTarget((OrdTarget)op, (BObject)Clock.time()));
            endOp.setReadonly("null".equals(op.getFormValue("endTimeNull")));
            BHxAbsTimeFE.INSTANCE.update(endOp);
        }
    }

    public class TimeRangeDialog
    extends Dialog {
        public TimeRangeDialog(Command command) {
            super(lex, "dynamicTimeRangeFE.editTimeRange", command);
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BDynamicTimeRange range = (BDynamicTimeRange)op.get();
            out.w((Object)"<table>");
            BAbsTime start = range.getFixedStartTime().isNull() ? Clock.time() : range.getFixedStartTime();
            HxOp startOp = op.make("startRange", new OrdTarget((OrdTarget)op, (BObject)start));
            out.w((Object)"<tr>");
            out.w((Object)"<td>").safe((Object)lex.getText("dynamicTimeRangeFE.startTime", (Context)op)).w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<select");
            out.w((Object)" onChange='").w((Object)BHxDynamicTimeRangeFE.this.dialogChangeCommand.getInvokeCode(op)).w((Object)"'");
            out.w((Object)" id='").w((Object)op.scope("startTimeNull")).w((Object)"'");
            if (!op.canWrite()) {
                out.w((Object)" disabled='disabled'");
            }
            out.w((Object)" name='").w((Object)op.scope("startTimeNull")).w((Object)"'>");
            startOp.setReadonly(range.getFixedStartTime().isNull());
            if (range.getFixedStartTime().isNull()) {
                out.w((Object)"<option value='null' selected='selected'>").safe((Object)lex.getText("dynamicTimeRangeFE.none", (Context)op)).w((Object)"</option>");
                out.w((Object)"<option>").safe((Object)lex.getText("dynamicTimeRangeFE.fixed", (Context)op)).w((Object)"</option>");
            } else {
                out.w((Object)"<option value='null'>").safe((Object)lex.getText("dynamicTimeRangeFE.none", (Context)op)).w((Object)"</option>");
                out.w((Object)"<option selected='selected'>").safe((Object)lex.getText("dynamicTimeRangeFE.fixed", (Context)op)).w((Object)"</option>");
            }
            out.w((Object)"</select></td>");
            out.w((Object)"<td>");
            BHxAbsTimeFE.INSTANCE.write(startOp);
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            BAbsTime end = range.getFixedEndTime().isNull() ? Clock.time() : range.getFixedEndTime();
            HxOp endOp = op.make("endRange", new OrdTarget((OrdTarget)op, (BObject)end));
            out.w((Object)"<tr>");
            out.w((Object)"<td>").safe((Object)lex.getText("dynamicTimeRangeFE.endTime", (Context)op)).w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<select");
            out.w((Object)" onChange='").w((Object)BHxDynamicTimeRangeFE.this.dialogChangeCommand.getInvokeCode(op)).w((Object)"'");
            out.w((Object)" id='").w((Object)op.scope("endTimeNull")).w((Object)"'");
            if (!op.canWrite()) {
                out.w((Object)" disabled='disabled'");
            }
            out.w((Object)" name='").w((Object)op.scope("endTimeNull")).w((Object)"'>");
            endOp.setReadonly(range.getFixedEndTime().isNull());
            if (range.getFixedEndTime().isNull()) {
                out.w((Object)"<option value='null' selected='selected'>").safe((Object)lex.getText("dynamicTimeRangeFE.none", (Context)op)).w((Object)"</option>");
                out.w((Object)"<option>").safe((Object)lex.getText("dynamicTimeRangeFE.fixed", (Context)op)).w((Object)"</option>");
            } else {
                out.w((Object)"<option value='null'>").safe((Object)lex.getText("dynamicTimeRangeFE.none", (Context)op)).w((Object)"</option>");
                out.w((Object)"<option selected='selected'>").safe((Object)lex.getText("dynamicTimeRangeFE.fixed", (Context)op)).w((Object)"</option>");
            }
            out.w((Object)"</select></td>");
            out.w((Object)"<td>");
            BHxAbsTimeFE.INSTANCE.write(endOp);
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    private class RangeDialogCommand
    extends Command {
        Dialog dlg;

        public RangeDialogCommand(BHxView view) {
            super(view);
            this.dlg = new TimeRangeDialog((Command)this);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            if (!op.canWrite()) {
                return;
            }
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BDynamicTimeRange range = null;
            try {
                range = (BDynamicTimeRange)BHxDynamicTimeRangeFE.this.saveContent(op);
            }
            catch (IllegalArgumentException iae) {
                op.sendError(iae);
            }
            if (range != null) {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"document.getElementById('").w((Object)op.scope("rangeStart")).w((Object)"').value=").w(range.getFixedStartTime().getMillis()).w((Object)";");
                out.w((Object)"document.getElementById('").w((Object)op.scope("rangeStop")).w((Object)"').value=").w(range.getFixedEndTime().getMillis()).w((Object)";");
                StringBuffer buf = new StringBuffer();
                BAbsTime startTime = range.getStartTime(BAbsTime.now());
                BAbsTime stopTime = range.getEndTime(BAbsTime.now());
                if (startTime.isNull()) {
                    buf.append("?");
                } else {
                    buf.append(range.getStartTime(BAbsTime.now()));
                }
                buf.append(" ").append(lex.getText("dynamicTimeRangeFE.to", (Context)op)).append(" ");
                if (stopTime.isNull()) {
                    buf.append("?");
                } else {
                    buf.append(stopTime);
                }
                out.w((Object)"document.getElementById('").w((Object)op.scope("timeRangeStr")).w((Object)"').textContent='").w((Object)HxUtil.escapeJsStringLiteral(buf.toString())).w((Object)"';");
                try {
                    BDynamicTimeRangeFE fieldEditor = (BDynamicTimeRangeFE)((OrdTarget)op.getBase().getBase()).get();
                    fieldEditor.doLoadValue((BObject)range, (Context)op);
                    fieldEditor.setModified();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                out.w((Object)"hx.poll();");
            }
        }
    }

    private class ChangeCommand
    extends Command {
        public ChangeCommand(BHxView view) {
            super(view);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            BDynamicTimeRangeType rangeType = BDynamicTimeRangeType.make((String)op.getFormValue("timeRangeEditor"));
            HtmlWriter out = op.getHtmlWriter();
            if (rangeType.equals((Object)BDynamicTimeRangeType.timeRange)) {
                out.w((Object)"document.getElementById('").w((Object)op.scope("timeRangeStr")).w((Object)"').style.display='';");
                out.w((Object)"document.getElementById('").w((Object)op.scope("timeRangeIcon")).w((Object)"').style.display='';");
            } else {
                out.w((Object)"document.getElementById('").w((Object)op.scope("timeRangeStr")).w((Object)"').style.display='none';");
                out.w((Object)"document.getElementById('").w((Object)op.scope("timeRangeIcon")).w((Object)"').style.display='none';");
            }
            try {
                BDynamicTimeRange range = (BDynamicTimeRange)BHxDynamicTimeRangeFE.this.save(op);
                BDynamicTimeRangeFE fieldEditor = (BDynamicTimeRangeFE)((OrdTarget)op.getBase().getBase()).get();
                fieldEditor.doLoadValue((BObject)range, (Context)op);
                fieldEditor.setModified();
            }
            catch (Exception exception) {
                // empty catch block
            }
            out.w((Object)"hx.poll();");
        }
    }
}

