/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BHxBooleanFE
extends BHxFieldEditor {
    public static final BHxBooleanFE INSTANCE = new BHxBooleanFE();
    public static final Type TYPE = Sys.loadType(BHxBooleanFE.class);
    static final String trueTextDef = BBoolean.toString((boolean)true, null);
    static final String falseTextDef = BBoolean.toString((boolean)false, null);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxBooleanFE() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        BBoolean value = (BBoolean)op.get();
        HtmlWriter out = op.getHtmlWriter();
        String falseText = falseTextDef;
        String trueText = trueTextDef;
        BObject t = op.getFacet("trueText");
        BObject f = op.getFacet("falseText");
        if (t != null) {
            trueText = BFormat.format((String)t.toString(), null, (Context)op);
        }
        if (f != null) {
            falseText = BFormat.format((String)f.toString(), null, (Context)op);
        }
        out.w((Object)"<select ").attr("name", op.scope("value")).attr(" id", op.scope("value"));
        if (!op.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        out.w((Object)"<option value='false'");
        if (!value.getBoolean()) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)falseText).w((Object)"</option>");
        out.w((Object)"<option value='true'");
        if (value.getBoolean()) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)trueText).w((Object)"</option>");
        out.w((Object)"</select>");
    }

    @Override
    public void update(HxOp op) throws Exception {
        if (!op.canWrite()) {
            BBoolean value = (BBoolean)op.get();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var editor_value=").w((Object)value.encodeToString()).w((Object)";");
            out.w((Object)"if(document.getElementById('").w((Object)op.scope("value")).w((Object)"').value!=editor_value) {");
            if (value.getBoolean()) {
                out.w((Object)"document.getElementById('").w((Object)op.scope("value")).w((Object)"').selectedIndex=1;}");
            } else {
                out.w((Object)"document.getElementById('").w((Object)op.scope("value")).w((Object)"').selectedIndex=0;}");
            }
        }
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        String value = op.getFormValue("value");
        if (value == null) {
            return op.get();
        }
        return value.equals("true") ? BBoolean.TRUE : BBoolean.FALSE;
    }
}

