/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.baja.gx.BImage;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;

public class ErrorDialog
extends Dialog {
    Throwable e;
    String msg;
    String details;
    private static BIcon errIcon = BIcon.std((String)"error.png");
    public static final String FORCE_DETAILS = "forceDetails";
    public static BFacets forceDetailsFacets = BFacets.make((String)"forceDetails", (boolean)true);

    public ErrorDialog(String title, String msg, Command handler) {
        this(title, msg, null, handler);
    }

    public ErrorDialog(String title, String msg, String details, Command handler) {
        super(title, handler);
        this.msg = msg;
        this.details = details;
    }

    public ErrorDialog(String title, String msg, String details) {
        super(title, null);
        this.msg = msg;
        this.details = details;
    }

    public ErrorDialog(String title, Command handler, Throwable e) {
        this(title, handler, e, null);
    }

    public ErrorDialog(String title, Throwable e) {
        this(title, null, e, null);
    }

    public ErrorDialog(String title, String msg, Throwable e) {
        this(title, null, e, msg);
    }

    public ErrorDialog(String title, Command handler, Throwable e, String niceMessage) {
        super(title, handler);
        this.msg = niceMessage != null ? niceMessage : (e.getMessage() != null ? e.getMessage() : e.getClass().getName());
        if (((BWebService)Sys.getService((Type)BWebService.TYPE)).getShowStackTrace()) {
            StringWriter result = new StringWriter();
            HtmlWriter printWriter = new HtmlWriter((Writer)result);
            e.printStackTrace((PrintWriter)printWriter);
            this.details = ((Object)result).toString();
        } else {
            this.details = e.toString();
        }
    }

    public String getMessage(HxOp op) {
        if (this.msg != null) {
            this.msg = TextUtil.replace((String)this.msg, (String)"&semi:", (String)";");
        }
        return this.msg;
    }

    @Override
    public Command[] getCommands() {
        return new Command[]{new Dialog.Cancel(this)};
    }

    public BImage getIcon(HxOp op) {
        return BImage.make((BIcon)errIcon);
    }

    @Override
    protected void writeContent(HxOp op) throws Exception {
        this.writeContent(true, op);
    }

    public void writeContent(boolean scrollable, HxOp op) throws Exception {
        Lexicon lex = Lexicon.make((String)"hx", (Context)op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table>");
        out.w((Object)"<tr>");
        out.w((Object)"<td valign='top' >");
        HxUtil.makeImageJS(this.getIcon(op), null, null, null, op);
        out.w((Object)"</td>");
        out.w((Object)"<td valign='top'>");
        if (this.msg != null) {
            this.msg = TextUtil.replace((String)this.msg, (String)"&semi:", (String)";");
            out.w((Object)"<b>").safe((Object)this.msg).w((Object)"</b>");
        }
        if (this.details != null) {
            out.w((Object)"<br/>");
            boolean forceDetails = op.getFacets().getb(FORCE_DETAILS, false);
            if (!forceDetails) {
                out.w((Object)"<span class='error-show-details' id='hx-dialog-error-expand'");
                out.w((Object)"onclick='var details = document.getElementById(&quot;hx-dialog-error-details&quot;);");
                out.w((Object)"var expand = document.getElementById(&quot;hx-dialog-error-expand&quot;);");
                out.w((Object)"if(details.style.display == &quot;none&quot;)");
                out.w((Object)"{details.style.display=&quot;block&quot;; expand.textContent=&quot;");
                out.safe((Object)lex.getText("hideDetails")).w((Object)"&quot;;}else{ ");
                out.w((Object)"expand.textContent=&quot;");
                out.safe((Object)lex.getText("showDetails")).w((Object)"&quot;;");
                out.w((Object)"details.style.display=&quot;none&quot;;}hx.resizeCurrentDialog();'");
                out.w((Object)">");
                out.safe((Object)lex.getText("showDetails")).w((Object)"</span>");
            }
            out.w((Object)"<div id='hx-dialog-error-details'");
            if (!forceDetails) {
                out.w((Object)" style='display:none;'");
            }
            out.w((Object)">");
            StringWriter w = new StringWriter();
            HtmlWriter h = new HtmlWriter((Writer)w);
            h.w((Object)"<pre><code>");
            h.safe((Object)this.details);
            h.w((Object)"</code></pre>");
            String ex = TextUtil.replace((String)w.toString(), (String)"\n", (String)"<br/>");
            ex = TextUtil.replace((String)ex, (String)"\r", (String)"");
            out.w((Object)ex);
            out.w((Object)"</div>");
        }
        out.w((Object)"</td></tr></table>");
    }

    public static class ErrorRefreshDialog
    extends ErrorDialog {
        public ErrorRefreshDialog(String title, Command command, String message) {
            super(title, message, null, command);
        }

        public ErrorRefreshDialog(String title, Command command, String message, String details) {
            super(title, message, details, command);
        }

        public ErrorRefreshDialog(String title, Command command, Exception e) {
            super(title, command, (Throwable)e);
        }

        public ErrorRefreshDialog(String title, Command command, Throwable e, String niceMessage) {
            super(title, command, e, niceMessage);
        }

        @Override
        public Command[] getCommands() {
            return new Command[]{new DoneRefresh()};
        }

        protected class DoneRefresh
        extends Dialog.Cancel {
            public DoneRefresh() {
                super(ErrorRefreshDialog.this);
            }

            @Override
            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                b.append("hx.closeDialog(null,null,null);");
                b.append("window.location.reload(true);");
                return b.toString();
            }
        }
    }

    public static class SuccessRefreshDialog
    extends SuccessDialog {
        private BOrd redirect;

        public SuccessRefreshDialog(String title, Command command, String message, String details) {
            super(title, command, message, details);
        }

        public SuccessRefreshDialog(String title, Command command, String message, String details, BOrd redirect) {
            super(title, command, message, details);
            this.redirect = redirect;
        }

        @Override
        public Command[] getCommands() {
            return new Command[]{new DoneRefresh()};
        }

        protected class DoneRefresh
        extends Dialog.Cancel {
            public DoneRefresh() {
                super(SuccessRefreshDialog.this);
            }

            @Override
            public String getDisplayName(HxOp op) {
                return Lexicon.make(this.getClass()).getText("done");
            }

            @Override
            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                b.append("hx.closeDialog(null,null,null);");
                if (SuccessRefreshDialog.this.redirect == null) {
                    b.append("window.location.reload(true);");
                } else {
                    b.append("window.location=&quot;").append(op.toUri(SuccessRefreshDialog.this.redirect)).append("&quot;;");
                }
                return b.toString();
            }
        }
    }

    public static class SuccessDialog
    extends ErrorDialog {
        public SuccessDialog(String title, Command command, String message, String details) {
            super(title, message, details, command);
        }

        @Override
        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)BIcon.std((String)"job/success.png"));
        }

        @Override
        public Command[] getCommands() {
            return new Command[]{new Done()};
        }

        protected class Done
        extends Dialog.Cancel {
            public Done() {
                super(SuccessDialog.this);
            }

            @Override
            public String getDisplayName(HxOp op) {
                return Lexicon.make(this.getClass()).getText("done");
            }
        }
    }
}

