/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.ui;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.maxpro.BMaxproNetwork;
import com.tridium.maxpro.camera.BMaxproCamera;
import com.tridium.maxpro.enums.BMaxproNormalSpeedEnum;
import com.tridium.maxpro.nvr.BMaxproNvr;
import com.tridium.maxpro.util.Helper;
import com.tridium.maxpro.util.MaxproHttpUtil;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpMessage;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIRemoteVideoSource;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpsConnection;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.baja.ffmpeg.enums.BCodecIdEnum;
import org.baja.ffmpeg.videoDriver.FfmpegVideoDecoder;

public class MaxproFfmpegH264Decoder
extends FfmpegVideoDecoder {
    BPlaybackParams playbackParams;
    String streamId = "";
    String strLiveXmlPath = "";
    int prevFileNo = 0;
    int nmediafile = 0;
    public static final Logger dataLog = Logger.getLogger("maxpro.h264Decoder");
    byte[] buf1 = new byte[51200];
    ByteBuffer videoFrameBuffer = new ByteBuffer();
    int state = -1;
    static final int INIT = -1;
    static final int LAST_READ_SEGMENT = 1;
    static final int LAST_READ_FRAME = 2;
    InputStream inputStream;
    public Logger maxpro_stream_log = Logger.getLogger("Maxpro_Video_Stream");
    boolean isPaint = false;
    protected int bgAlpha = 180;
    protected int fgAlpha = 250;

    public MaxproFfmpegH264Decoder(BCodecIdEnum codecSelected, BPlaybackParams playbackParams) {
        super(codecSelected);
        this.playbackParams = playbackParams;
    }

    public void readFrameData(VidFrame vf) throws Exception {
        try {
            this.isPaint = false;
            this.videoFrameBuffer.reset();
            vf.rawData = this.videoFrameBuffer;
            BAbsTime ct = vf.timeIndex;
            if (this.inputStream == null || this.inputStream.available() <= 0) {
                try {
                    this.inputStream = this.helpGetInputStream();
                }
                catch (RuntimeException re) {
                    this.isPaint = true;
                }
                this.state = -1;
            }
            if (this.state == -1 && (this.inputStream == null || this.inputStream.available() <= 0)) {
                return;
            }
            if (this.state == -1) {
                if (this.maxpro_stream_log.isLoggable(Level.FINE)) {
                    this.maxpro_stream_log.fine("H264 Decoder. A new media file. Reading segment header now.");
                }
                this.readSegmentHeader(vf);
            }
            if (this.state == 1) {
                this.readFrame(vf);
            } else if (this.state == 2 && this.inputStream.available() > 0) {
                this.readFrame(vf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private InputStream helpGetInputStream() throws Exception {
        InputStream is;
        block21: {
            BMaxproCamera camera = (BMaxproCamera)this.getVideoSource(this.videoSource);
            BMaxproNvr nvr = camera.getMaxproDvr();
            is = null;
            if (this.strLiveXmlPath.equalsIgnoreCase("")) {
                try {
                    if (this.maxpro_stream_log.isLoggable(Level.FINE)) {
                        this.maxpro_stream_log.fine("H264 Decoder -> Creating a video stream.");
                    }
                    JSONObject createStreamRsp = MaxproHttpUtil.createStream((HttpComm)camera.hcomm(), (BIpAddress)camera.httpAddress(), (BMaxproNvr)nvr, (int)camera.getCameraNbr(camera), (BPlaybackParams)this.playbackParams);
                    this.streamId = JSONUtil.getString((JSONObject)createStreamRsp, (String)"id");
                    if (this.playbackParams.getPlaybackType() == BPlaybackTypeEnum.slowFwd || this.playbackParams.getPlaybackType() == BPlaybackTypeEnum.slowRew || this.playbackParams.getPlaybackType() == BPlaybackTypeEnum.fastFwd || this.playbackParams.getPlaybackType() == BPlaybackTypeEnum.fastRew) {
                        MaxproHttpUtil.configureFwdRwdSettings((HttpComm)camera.hcomm(), (BIpAddress)camera.httpAddress(), (BMaxproNvr)nvr, (int)camera.getCameraNbr(camera), (BPlaybackParams)this.playbackParams, (String)this.streamId, (BMaxproNormalSpeedEnum)camera.getNormalSpeed(), (int)camera.getFastSpeed());
                    }
                    JSONArray extnObj = createStreamRsp.getJSONArray("extension");
                    this.strLiveXmlPath = JSONUtil.getString((JSONObject)extnObj.getJSONObject(0), (String)"streamURL");
                    String string = camera.httpAddress().getIpAddress();
                }
                catch (Exception e) {
                    this.maxpro_stream_log.severe("Error creating Video Stream with NVR. " + e.getLocalizedMessage());
                }
            }
            try {
                int retryCount = 0;
                while (this.nmediafile == this.prevFileNo && retryCount < 20) {
                    String strLiveXmlPathRandom = this.strLiveXmlPath + "?unused=" + new Random().nextLong();
                    NHttpRequest rqst1 = new NHttpRequest(camera.httpAddress(), "GET", strLiveXmlPathRandom);
                    rqst1.addBasicAuthorization(nvr.getCredentials().getUsername(), Helper.getPasswordString((BMaxproNvr)nvr, (String)"getPasswordRpc"));
                    HttpConnection httpConn1 = null;
                    try {
                        BMaxproNetwork network = (BMaxproNetwork)camera.vnetwork();
                        network.lease(2);
                        if (network.getHttpConfig().getUseTls()) {
                            SSLSocketFactory defaultFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                            httpConn1 = new HttpsConnection((BHost)new BIpHost(camera.httpAddress().getIpAddress()), camera.httpAddress().getPort(), null, (SocketFactory)defaultFactory);
                        } else {
                            httpConn1 = new HttpConnection((BHost)new BIpHost(camera.httpAddress().getIpAddress()), camera.httpAddress().getPort());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    httpConn1.setTimeout(rqst1.getResponseTimeOut());
                    httpConn1.setRequestMethod("GET");
                    NHttpMessage.NVPair[] a1 = rqst1.getHeaders();
                    for (int i1 = 0; i1 < a1.length; ++i1) {
                        httpConn1.setRequestHeader(a1[i1].name, a1[i1].value);
                    }
                    int rc1 = httpConn1.newRequest(strLiveXmlPathRandom);
                    NHttpResponse resp1 = new NHttpResponse(camera.httpAddress(), httpConn1);
                    httpConn1.close();
                    httpConn1 = null;
                    String strLiversp = new String(resp1.getData());
                    XParser p = XParser.make((String)strLiversp);
                    XElem rootElem = p.parse();
                    String mediafile_sno = rootElem.elem("mediafile").elem("mediafile_sno").text().toString();
                    this.nmediafile = Integer.parseInt(mediafile_sno);
                    if (this.nmediafile == 0 || this.nmediafile == this.prevFileNo) {
                        Thread.sleep(500L);
                    }
                    if (++retryCount != 20) continue;
                    this.maxpro_stream_log.severe("Recording Not Available");
                    throw new RuntimeException("Recording Not available");
                }
                if (this.nmediafile == this.prevFileNo || this.nmediafile == 0) break block21;
                String strLiveReq = this.strLiveXmlPath.substring(0, this.strLiveXmlPath.indexOf("playlist.xml")) + this.nmediafile;
                String meth = "GET";
                NHttpRequest rqst = new NHttpRequest(camera.httpAddress(), meth, strLiveReq);
                rqst.addBasicAuthorization(nvr.getCredentials().getUsername(), Helper.getPasswordString((BMaxproNvr)nvr, (String)"getPasswordRpc"));
                HttpConnection httpConn = null;
                try {
                    BMaxproNetwork network = (BMaxproNetwork)camera.vnetwork();
                    network.lease(2);
                    if (network.getHttpConfig().getUseTls()) {
                        SSLSocketFactory defaultFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                        httpConn = new HttpsConnection((BHost)new BIpHost(camera.httpAddress().getIpAddress()), camera.httpAddress().getPort(), null, (SocketFactory)defaultFactory);
                    } else {
                        httpConn = new HttpConnection((BHost)new BIpHost(camera.httpAddress().getIpAddress()), camera.httpAddress().getPort());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                httpConn.setTimeout(rqst.getResponseTimeOut());
                httpConn.setRequestMethod(meth);
                NHttpMessage.NVPair[] a = rqst.getHeaders();
                for (int i = 0; i < a.length; ++i) {
                    httpConn.setRequestHeader(a[i].name, a[i].value);
                }
                int rc = httpConn.newRequest(strLiveReq);
                NHttpResponse resp = new NHttpResponse(camera.httpAddress(), httpConn);
                httpConn.close();
                httpConn = null;
                String strLivePacketsRsp = new String(resp.getData());
                if (this.maxpro_stream_log.isLoggable(Level.FINE)) {
                    this.maxpro_stream_log.fine("H264 Decoder-> Video stream packets received for  " + this.nmediafile + " are : " + strLivePacketsRsp.length());
                }
                this.prevFileNo = this.nmediafile;
                return new ByteArrayInputStream(resp.getData());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return is;
    }

    public void stopDecoding(WaitForStopDecoding stopMonitor) {
        super.stopDecoding(stopMonitor);
        if (!this.streamId.equalsIgnoreCase("")) {
            BMaxproCamera camera = (BMaxproCamera)this.getVideoSource(this.videoSource);
            camera.closeStream(this.streamId);
        }
    }

    public BIVideoSource getVideoSource(BIVideoSource videoSource) {
        if (videoSource instanceof BMaxproCamera) {
            return (BMaxproCamera)videoSource;
        }
        if (videoSource instanceof BIRemoteVideoCamera) {
            try {
                BIRemoteVideoCamera remoteCamera = (BIRemoteVideoCamera)videoSource;
                BIRemoteVideoSource remoteVideoSource = (BIRemoteVideoSource)remoteCamera.getRemoteVideoOrd().get((BObject)videoSource);
                return remoteVideoSource.getVideoSource();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        if (videoSource instanceof BIRemoteVideoSource) {
            BIRemoteVideoSource remoteVideoSource = (BIRemoteVideoSource)videoSource;
            return remoteVideoSource.getVideoSource();
        }
        throw new BajaRuntimeException("uknown source:" + videoSource.getType());
    }

    void readSegmentHeader(VidFrame vf) throws IOException {
        BAbsTime time;
        int segmentSize = 42;
        ByteBuffer segmentBuffer = new ByteBuffer();
        FfmpegVideoDecoder.readBytesFromInputStream((Logger)dataLog, (InputStream)this.inputStream, (byte[])this.buf1, (int)segmentSize, (Object)segmentBuffer);
        byte[] segmentHeaderBytes = segmentBuffer.toByteArray();
        byte[] vidStartTimeBytes = new byte[]{segmentHeaderBytes[6], segmentHeaderBytes[5], segmentHeaderBytes[4], segmentHeaderBytes[3]};
        long timeindex = this.byteArraytoLong(vidStartTimeBytes);
        BAbsTime time1 = BAbsTime.now();
        vf.timeIndex = time = BAbsTime.make((long)(timeindex * 1000L), (BTimeZone)time1.getTimeZone());
        this.state = 1;
    }

    void readFrame(VidFrame vf) throws IOException {
        try {
            BAbsTime ftime;
            int frameheaderSize = 30;
            ByteBuffer frameheaderBuffer = new ByteBuffer();
            FfmpegVideoDecoder.readBytesFromInputStream((Logger)dataLog, (InputStream)this.inputStream, (byte[])this.buf1, (int)frameheaderSize, (Object)frameheaderBuffer);
            byte[] frameHeaderBytes = frameheaderBuffer.toByteArray();
            byte[] frameSizeBytes = new byte[]{frameHeaderBytes[4], frameHeaderBytes[3], frameHeaderBytes[2], frameHeaderBytes[1]};
            int frameSize = (int)this.byteArraytoLong(frameSizeBytes);
            byte[] frameDelayBytes = new byte[]{frameHeaderBytes[8], frameHeaderBytes[7], frameHeaderBytes[6], frameHeaderBytes[5]};
            int framedelay = (int)this.byteArraytoLong(frameDelayBytes);
            byte[] frameTimeBytes = new byte[]{frameHeaderBytes[13], frameHeaderBytes[12], frameHeaderBytes[11], frameHeaderBytes[10]};
            long ftimeindex = this.byteArraytoLong(frameTimeBytes);
            byte[] frameTimeMillsBytes = new byte[]{frameHeaderBytes[17], frameHeaderBytes[16], frameHeaderBytes[15], frameHeaderBytes[14]};
            long ftimemillis = this.byteArraytoLong(frameTimeMillsBytes);
            BAbsTime ftime1 = BAbsTime.now();
            vf.timeIndex = ftime = BAbsTime.make((long)(ftimeindex * 1000L + ftimemillis), (BTimeZone)ftime1.getTimeZone());
            FfmpegVideoDecoder.readBytesFromInputStream((Logger)dataLog, (InputStream)this.inputStream, (byte[])this.buf1, (int)frameSize, (Object)this.videoFrameBuffer);
            this.state = 2;
            if (framedelay > -1) {
                Thread.sleep(framedelay);
            }
        }
        catch (Exception e) {
            this.maxpro_stream_log.severe("Exception in H264 decoder. " + e.getLocalizedMessage());
        }
    }

    long byteArraytoLong(byte[] bytevalue) {
        long lvalue = 0L;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            lvalue += (long)((bytevalue[i] & 0xFF) << shift);
        }
        return lvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintImage(Graphics g, BWidget vp) {
        if (this.isPaint) {
            String message = "Recording Not Available";
            try {
                g.push();
                int fontSize = 24;
                if (vp.getWidth() < 200.0) {
                    fontSize = 2;
                } else if (vp.getWidth() < 250.0) {
                    fontSize = 4;
                } else if (vp.getWidth() < 500.0) {
                    fontSize = 10;
                } else if (vp.getWidth() < 800.0) {
                    fontSize = 12;
                }
                BBrush background = BBrush.makeSolid((BColor)BColor.make((int)20, (int)50, (int)50, (int)this.bgAlpha));
                BBrush foreground = BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)255, (int)this.fgAlpha));
                BFont font = BFont.make((String)Theme.label().getTextFont().getName(), (double)fontSize, (int)1);
                BLabel messageLabel = new BLabel();
                BBorderPane borderPane = new BBorderPane((BWidget)messageLabel, BBorder.dashed);
                messageLabel.setHalign(BHalign.left);
                messageLabel.setValign(BValign.bottom);
                messageLabel.setText(message);
                messageLabel.setBackground(background);
                messageLabel.setForeground(foreground);
                messageLabel.setFont(font);
                messageLabel.computePreferredSize();
                messageLabel.setBounds(2.0, 2.0, messageLabel.getPreferredWidth(), messageLabel.getPreferredHeight());
                messageLabel.doLayout(null);
                double fromLeft = vp.getWidth() / 2.0 - messageLabel.getPreferredWidth() / 2.0;
                double fromBottom = vp.getHeight() - messageLabel.getPreferredHeight() - 10.0;
                g.transform(BTransform.makeTranslate((double)fromLeft, (double)fromBottom));
                borderPane.paint(g);
                g.setBrush(background);
                g.setPen(BPen.make((double)8.0, (int)103, (int)202, null));
                g.strokeRect(0.0, 0.0, messageLabel.getPreferredWidth() + 4.0, messageLabel.getPreferredHeight() + 4.0);
            }
            catch (Exception exception) {
            }
            finally {
                g.pop();
            }
        }
        super.paintImage(g, vp);
    }
}

