/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.utils;

import com.tridium.saml.SAMLException;
import com.tridium.saml.authnScheme.BSAMLAuthenticationScheme;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.baja.util.Lexicon;
import javax.servlet.http.HttpServletRequest;

public class SAMLUtils {
    public static Logger log = Logger.getLogger("saml");

    public static String getEntityId(BSAMLAuthenticationScheme samlScheme, HttpServletRequest request) {
        String entityId = samlScheme.getEntityId();
        if (entityId == null || entityId.isEmpty()) {
            entityId = String.format("%s://%s:%s/saml/", request.getScheme(), request.getServerName(), request.getServerPort());
        }
        if (!entityId.endsWith("/")) {
            entityId = entityId + "/";
        }
        return entityId;
    }

    public static String getAssertionConsumerURL(BSAMLAuthenticationScheme samlScheme, HttpServletRequest request) {
        return SAMLUtils.getAssertionConsumerURL(SAMLUtils.getEntityId(samlScheme, request));
    }

    public static String getAssertionConsumerURL(String baseUrl) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        return baseUrl + "assertionConsumerService";
    }

    public static String getIssuerURL(BSAMLAuthenticationScheme samlScheme, HttpServletRequest request) {
        return SAMLUtils.getEntityId(samlScheme, request);
    }

    public static String processRawSAMLMessage(String rawMessage, boolean inflate, boolean urlDecode) throws SAMLException {
        try {
            String urlDecodedResponse = urlDecode ? URLDecoder.decode(rawMessage, "UTF-8") : rawMessage;
            urlDecodedResponse = urlDecodedResponse.replaceAll("\\r|\\n", "");
            byte[] decodedBytes = Base64.getDecoder().decode(urlDecodedResponse);
            if (inflate) {
                int numBytesRead;
                Inflater inflater = new Inflater(true);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decodedBytes);
                InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, inflater);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inflaterInputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((numBytesRead = bufferedInputStream.read(buffer, 0, 1024)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, numBytesRead);
                }
                decodedBytes = byteArrayOutputStream.toByteArray();
            }
            return new String(decodedBytes, "UTF-8");
        }
        catch (IOException e) {
            Lexicon lex = Lexicon.make((String)"saml");
            throw new SAMLException(lex.get("saml.exception.decodeMessage"), e);
        }
    }

    public static String encodeSAMLMessageXML(String authnRequestXML, boolean deflate, boolean urlEncode) throws SAMLException {
        Base64.Encoder base64Encoder = Base64.getEncoder();
        try {
            byte[] bytesToEncode;
            if (deflate) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Deflater deflater = new Deflater(-1, true);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                deflaterOutputStream.write(authnRequestXML.getBytes());
                deflaterOutputStream.close();
                byteArrayOutputStream.close();
                bytesToEncode = byteArrayOutputStream.toByteArray();
            } else {
                bytesToEncode = authnRequestXML.getBytes();
            }
            String deflatedRequest = new String(base64Encoder.encode(bytesToEncode)).trim();
            if (urlEncode) {
                deflatedRequest = URLEncoder.encode(deflatedRequest, "UTF-8");
            }
            return deflatedRequest;
        }
        catch (IOException e) {
            throw new SAMLException(e.getMessage(), e);
        }
    }

    public static void log(Level level, String message, Throwable e) {
        if (log.isLoggable(Level.FINE)) {
            log.log(level, message, e);
        } else {
            log.log(level, message);
        }
    }

    public static void log(Level level, String message) {
        log.log(level, message);
    }

    public static void log(Level level, Supplier<String> message) {
        log.log(level, message);
    }

    public static boolean isLoggable(Level level) {
        return log.isLoggable(level);
    }
}

