/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.saml.SAMLAuthnRequestException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLIdPConfigurationException;
import com.tridium.saml.SAMLLoginException;
import com.tridium.saml.idp.BCircleOfTrust;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.saml.idp.BStationServiceProvider;
import com.tridium.saml.idp.BStationServiceProviderFolder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.servlet.http.HttpServletRequest;

public class SAMLIdPServletUtil {
    static BCircleOfTrust getCircleOfTrust(HttpServletRequest httpRequest) throws SAMLException {
        BSAMLIdPService idpService = (BSAMLIdPService)((Object)Sys.findService((Type)BSAMLIdPService.TYPE).orElseThrow(() -> new SAMLIdPConfigurationException("No SAML IdP Service configured. Cannot validate Circle of Trust")));
        String[] urlParts = httpRequest.getRequestURI().split("/");
        String requestedUuid = urlParts[urlParts.length - 1];
        try {
            BCircleOfTrust circleOfTrust = idpService.getCircleOfTrust(BUuid.make((String)requestedUuid));
            if (circleOfTrust == null) {
                throw new SAMLAuthnRequestException("Could not find requested circle of trust <" + requestedUuid + ">");
            }
            if (!circleOfTrust.getEnabled()) {
                throw new SAMLAuthnRequestException("Requested circle of trust <" + requestedUuid + "> is disabled");
            }
            return circleOfTrust;
        }
        catch (Exception e) {
            throw new SAMLException("Could not parse requested circle of trust <" + requestedUuid + ">", e);
        }
    }

    static BStationServiceProvider getStationServiceProvider(BCircleOfTrust circleOfTrust, String issuerUrl) throws SAMLLoginException {
        BStationServiceProviderFolder serviceProviderFolder = circleOfTrust.getServiceProviders();
        BStationServiceProvider provider = serviceProviderFolder.getStationServiceProviderByAddress(issuerUrl);
        if (provider == null) {
            throw new SAMLLoginException("The given issuer URL <" + issuerUrl + "> is not part of the requested circle of trust <" + circleOfTrust.getName() + ">");
        }
        return provider;
    }
}

