/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.saml.SAMLAuthnRequestException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLIdPConfigurationException;
import com.tridium.saml.idp.BCircleOfTrust;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.saml.idp.BStationServiceProvider;
import com.tridium.saml.idp.SAMLIdPServletUtil;
import com.tridium.saml.rp.AuthnRequest;
import com.tridium.saml.rp.servlet.SAMLUuidMap;
import com.tridium.saml.utils.SAMLUtils;
import com.tridium.session.SessionManager;
import com.tridium.web.CookieUtil;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLIdPAuthnRequestServlet
extends UnauthenticatedServlet {
    private static final String AUTHN_REQUEST_URI_START = "/saml/idp/auth/httpredirect/cot/";
    private static final String PROCESS_LOGIN_URI_START = "/saml/idp/auth/processLogin/cot/";
    private static final String ID_QUERY_PARAM_START = "?id=";
    private static final String SAML_REQUEST_NAME = "SAMLRequest";
    private static final int MAX_SAML_REQUEST_LENGTH = 4096;
    private static final Map<UUID, ZonedDateTime> SUCCESSFUL_LOGIN_MAP = new ConcurrentHashMap<UUID, ZonedDateTime>();
    private static final long serialVersionUID = -12742408196162545L;
    private static final Map<String, String> ALGORITHM_MAPPING = new HashMap<String, String>();

    public SAMLIdPAuthnRequestServlet() {
        ALGORITHM_MAPPING.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1withRSA");
    }

    public void init() {
        AccessController.doPrivileged(() -> {
            SAMLUuidMap.UUID_TO_AUTHN_REQUEST_MAP.init();
            return null;
        });
    }

    public void destroy() {
        AccessController.doPrivileged(() -> {
            SAMLUuidMap.UUID_TO_AUTHN_REQUEST_MAP.destroy();
            return null;
        });
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (!this.isIdpServiceOperational()) {
                throw new SAMLIdPConfigurationException("SAML IdP is not enabled");
            }
            String uri = request.getRequestURI();
            if (uri.startsWith(AUTHN_REQUEST_URI_START)) {
                this.handleAuthnRequest(request, response);
            } else {
                response.sendError(404);
            }
        }
        catch (SAMLIdPConfigurationException e) {
            SAMLUtils.log(Level.WARNING, e.getGenericErrorMessage(), e);
            response.sendError(403, e.getGenericErrorMessage());
        }
        catch (SAMLException e) {
            SAMLUtils.log(Level.WARNING, e.getGenericErrorMessage(), e);
            response.sendError(400, e.getGenericErrorMessage());
        }
    }

    private boolean isIdpServiceOperational() {
        Optional idpService = Sys.findService((Type)BSAMLIdPService.TYPE);
        return idpService.isPresent() && ((BSAMLIdPService)((Object)idpService.get())).isOperational();
    }

    private void handleAuthnRequest(HttpServletRequest request, HttpServletResponse response) throws SAMLException {
        try {
            AuthnRequest authnRequest;
            BCircleOfTrust circleOfTrust = SAMLIdPServletUtil.getCircleOfTrust(request);
            String rawSAMLRequest = this.getSAMLRequestFromQuery(request);
            if (rawSAMLRequest.length() > 4096) {
                throw new SAMLAuthnRequestException(String.format("SAMLRequest exceeds maximum allowed length: %d>%d", rawSAMLRequest.length(), 4096));
            }
            if (SAMLUtils.log.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "Received raw SAMLRequest:\n" + rawSAMLRequest);
            }
            String samlRequestXml = SAMLUtils.processRawSAMLMessage(rawSAMLRequest, true, false);
            if (SAMLUtils.log.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "Processed SAMLRequest XML:\n" + samlRequestXml);
            }
            try {
                authnRequest = AccessController.doPrivileged(() -> AuthnRequest.parseAuthnRequest(samlRequestXml));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            if (SAMLUtils.log.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "Parsed AuthnRequest:\n" + authnRequest.toString());
            }
            this.validateRequest(request, authnRequest, circleOfTrust);
            AccessController.doPrivileged(() -> {
                SAMLUuidMap.UUID_TO_AUTHN_REQUEST_MAP.put(authnRequest.getId(), authnRequest, 0L);
                return null;
            });
            String redirectUrl = PROCESS_LOGIN_URI_START + circleOfTrust.getUniqueId().toString() + ID_QUERY_PARAM_START + authnRequest.getId().toString();
            NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)request, (boolean)false);
            if (session != null && SessionManager.isAuthenticated((String)session.getSuperId())) {
                response.sendRedirect(redirectUrl);
            } else {
                response.addCookie(CookieUtil.createCookie((String)"niagara_origin_uri", (String)redirectUrl, (int)-1, (boolean)false));
                response.sendRedirect("/login");
            }
        }
        catch (Exception e) {
            throw new SAMLAuthnRequestException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateRequest(HttpServletRequest httpRequest, AuthnRequest authnRequest, BCircleOfTrust circleOfTrust) throws Exception {
        BStationServiceProvider serviceProvider = SAMLIdPServletUtil.getStationServiceProvider(circleOfTrust, authnRequest.getIssuerURL());
        this.validateSignature(httpRequest, serviceProvider);
        this.validateAssertionConsumerServiceUrl(serviceProvider, authnRequest);
        this.validateDestination(circleOfTrust, authnRequest);
        this.validateProtocolBinding(authnRequest);
        this.validateTimeConstraints(authnRequest);
        Map<UUID, ZonedDateTime> map = SUCCESSFUL_LOGIN_MAP;
        synchronized (map) {
            if (SUCCESSFUL_LOGIN_MAP.put(authnRequest.getId(), this.getExpirationTime(authnRequest.getIssueInstant())) != null) {
                throw new SAMLAuthnRequestException("This request has already been used.");
            }
            SUCCESSFUL_LOGIN_MAP.values().removeIf(value -> ZonedDateTime.now().isAfter((ChronoZonedDateTime<?>)value));
        }
    }

    private void validateSignature(HttpServletRequest httpRequest, BStationServiceProvider serviceProvider) throws Exception {
        String samlrequest = httpRequest.getParameter(SAML_REQUEST_NAME);
        String sigalg = httpRequest.getParameter("SigAlg");
        String signature = httpRequest.getParameter("Signature");
        if (sigalg == null || signature == null) {
            throw new SAMLAuthnRequestException("The signature is missing.");
        }
        byte[] sigBytes = Base64.getDecoder().decode(signature);
        String signedData = "SAMLRequest=" + URLEncoder.encode(samlrequest, "UTF-8") + "&SigAlg=" + URLEncoder.encode(sigalg, "UTF-8");
        if (serviceProvider.getCertificate().isNull()) {
            throw new SAMLIdPConfigurationException("The signing certificate in the Service Provider (" + serviceProvider.getName() + ") is not correctly configured");
        }
        X509Certificate signingCertificate = serviceProvider.getCertificate().getX509Certificate();
        PublicKey publicKey = signingCertificate.getPublicKey();
        try {
            Signature signatureObject = Signature.getInstance(ALGORITHM_MAPPING.get(sigalg));
            signatureObject.initVerify(publicKey);
            signatureObject.update(signedData.getBytes());
            if (!signatureObject.verify(sigBytes)) {
                throw new SAMLAuthnRequestException("Signature was invalid.");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SAMLAuthnRequestException("Signature was invalid.", e);
        }
    }

    private void validateAssertionConsumerServiceUrl(BStationServiceProvider serviceProvider, AuthnRequest authnRequest) throws SAMLAuthnRequestException {
        if (!serviceProvider.getAcsUrl().equals(authnRequest.getAssertionConsumerServiceURL())) {
            throw new SAMLAuthnRequestException("Expected <" + serviceProvider.getAcsUrl() + "> but found <" + authnRequest.getAssertionConsumerServiceURL() + ">");
        }
    }

    private void validateDestination(BCircleOfTrust circleOfTrust, AuthnRequest authnRequest) throws SAMLAuthnRequestException {
        String destination = authnRequest.getDestination();
        if (!destination.equals(circleOfTrust.getHttpRedirectEndpoint())) {
            throw new SAMLAuthnRequestException("The given destination <" + destination + "> does not match <" + circleOfTrust.getHttpRedirectEndpoint() + ">.");
        }
    }

    private void validateProtocolBinding(AuthnRequest authnRequest) throws SAMLAuthnRequestException {
        if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(authnRequest.getProtocolBinding())) {
            throw new SAMLAuthnRequestException("Expected <urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST> but found <" + authnRequest.getProtocolBinding() + ">.");
        }
    }

    private void validateTimeConstraints(AuthnRequest authnRequest) throws SAMLAuthnRequestException {
        ZonedDateTime now;
        BSAMLIdPService idPService;
        String issueInstant = authnRequest.getIssueInstant();
        ZonedDateTime myIssuerInstant = ZonedDateTime.parse(issueInstant).withZoneSameInstant(ZoneOffset.UTC);
        ZonedDateTime notBefore = myIssuerInstant.minus((idPService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE)).getTimeSkew().getMillis(), ChronoUnit.MILLIS);
        if (notBefore.isAfter(now = ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC))) {
            throw new SAMLAuthnRequestException("AuthnRequest is not valid yet.");
        }
        ZonedDateTime notAfter = myIssuerInstant.plus(idPService.getTimeSkew().getMillis(), ChronoUnit.MILLIS);
        if (notAfter.isBefore(now)) {
            throw new SAMLAuthnRequestException("AuthnRequest has expired.");
        }
    }

    private ZonedDateTime getExpirationTime(String issueInstant) {
        ZonedDateTime myIssuerInstant = ZonedDateTime.parse(issueInstant).withZoneSameInstant(ZoneOffset.UTC);
        BSAMLIdPService idPService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE);
        return myIssuerInstant.plus(idPService.getTimeSkew().getMillis(), ChronoUnit.MILLIS);
    }

    private String getSAMLRequestFromQuery(HttpServletRequest httpRequest) throws SAMLException {
        String samlRequest = httpRequest.getParameter(SAML_REQUEST_NAME);
        if (samlRequest != null) {
            return samlRequest;
        }
        throw new SAMLAuthnRequestException("SAMLRequest expected in query string");
    }
}

