/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.saml.idp.BStationServiceProviderFolder;
import java.security.cert.X509Certificate;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="certificate", type="BX509Certificate", defaultValue="BX509Certificate.DEFAULT"), @NiagaraProperty(name="encryptionCertificate", type="BX509Certificate", defaultValue="UNINITIALIZED"), @NiagaraProperty(name="issuerUrl", type="String", defaultValue="https://jace.domain.com:443/saml/"), @NiagaraProperty(name="useEncryption", type="boolean", defaultValue="true"), @NiagaraProperty(name="fromNiagaraNetwork", type="boolean", defaultValue="true")})
public class BStationServiceProvider
extends BComponent {
    private static final BX509Certificate UNINITIALIZED = BX509Certificate.make((X509Certificate)null);
    public static final Property certificate = BStationServiceProvider.newProperty((int)0, (BValue)BX509Certificate.DEFAULT, null);
    public static final Property encryptionCertificate = BStationServiceProvider.newProperty((int)0, (BValue)UNINITIALIZED, null);
    public static final Property issuerUrl = BStationServiceProvider.newProperty((int)0, (String)"https://jace.domain.com:443/saml/", null);
    public static final Property useEncryption = BStationServiceProvider.newProperty((int)0, (boolean)true, null);
    public static final Property fromNiagaraNetwork = BStationServiceProvider.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BStationServiceProvider.class);

    public BX509Certificate getCertificate() {
        return (BX509Certificate)this.get(certificate);
    }

    public void setCertificate(BX509Certificate v) {
        this.set(certificate, (BValue)v, null);
    }

    public BX509Certificate getEncryptionCertificate() {
        return (BX509Certificate)this.get(encryptionCertificate);
    }

    public void setEncryptionCertificate(BX509Certificate v) {
        this.set(encryptionCertificate, (BValue)v, null);
    }

    public String getIssuerUrl() {
        return this.getString(issuerUrl);
    }

    public void setIssuerUrl(String v) {
        this.setString(issuerUrl, v, null);
    }

    public boolean getUseEncryption() {
        return this.getBoolean(useEncryption);
    }

    public void setUseEncryption(boolean v) {
        this.setBoolean(useEncryption, v, null);
    }

    public boolean getFromNiagaraNetwork() {
        return this.getBoolean(fromNiagaraNetwork);
    }

    public void setFromNiagaraNetwork(boolean v) {
        this.setBoolean(fromNiagaraNetwork, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BStationServiceProviderFolder.TYPE);
    }

    public void started() throws Exception {
        if (this.getEncryptionCertificate() == UNINITIALIZED) {
            this.setEncryptionCertificate(this.getCertificate());
        }
        super.started();
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (certificate.equals(slot)) {
            return Lexicon.make((String)"saml").getText("StationServiceProvider.certificate.displayName");
        }
        return super.getDisplayName(slot, cx);
    }

    public String getAcsUrl() {
        return this.getIssuerUrl() + "assertionConsumerService";
    }
}

