/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.saml.idp.BCircleOfTrust;
import com.tridium.saml.idp.BCircleOfTrustFolder;
import com.tridium.saml.idp.BPrototypesFolder;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototype;
import javax.baja.user.BUserPrototypeProperty;
import javax.baja.util.BNameMap;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"baja:User", "baja:UserPrototype"})})
public class BSAMLCoTPrototypesMixIn
extends BComponent
implements BIMixIn,
ServiceListener {
    public static final Type TYPE = Sys.loadType(BSAMLCoTPrototypesMixIn.class);
    private static final LexiconModule SAML_LEX = LexiconModule.make((String)"saml");
    private static final Context RENAME_CONTEXT = new BasicContext();
    public static final String PROTOTYPE_DELIMITER = ",";
    public static final String CIRCLE_OF_TRUST_NAME = "circleOfTrustName";

    public Type getType() {
        return TYPE;
    }

    public void stationStarted() throws Exception {
        Nre.getServiceManager().addServiceListener((ServiceListener)this);
        this.init();
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            Nre.getServiceManager().addServiceListener((ServiceListener)this);
            this.init();
        }
    }

    public void stopped() throws Exception {
        BSAMLIdPService idpService;
        Nre.getServiceManager().removeServiceListener((ServiceListener)this);
        if (this.getParent() instanceof BUser && (idpService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE)) != null) {
            idpService.getUserSubscriber().unsubscribe((BComponent)this.getParent());
        }
    }

    public String getDisplayNameInParent(Context cx) {
        return SAML_LEX.getText("samlPrototypes", cx);
    }

    public void checkRename(Property property, String newName, Context context) {
        if (Sys.isStation() && this.get(property) instanceof BString && context != RENAME_CONTEXT) {
            throw new IllegalNameException("saml", "saml.mixin.cot.rename", new Object[0]);
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BNameMap) {
            throw new LocalizableRuntimeException("saml", "saml.mixin.cot.changeDisplayName");
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BUser || parent instanceof BUserPrototype || parent instanceof BUserPrototypeProperty;
    }

    public BCategoryMask getAppliedCategoryMask() {
        try {
            BSAMLIdPService idpService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE);
            return idpService.getAppliedCategoryMask();
        }
        catch (ServiceNotFoundException e) {
            return BCategoryMask.NULL;
        }
    }

    public void serviceEvent(BServiceEvent event) {
        if (event.getServiceType().is(BSAMLIdPService.TYPE)) {
            switch (event.getId()) {
                case 0: {
                    this.init();
                    break;
                }
                case 1: {
                    BSAMLIdPService samlIdPService = (BSAMLIdPService)event.getService();
                    for (BCircleOfTrust circleOfTrust : (BCircleOfTrust[])samlIdPService.getCircleOfTrustFolder().getChildren(BCircleOfTrust.class)) {
                        this.removeConfiguration(circleOfTrust.getName());
                    }
                    break;
                }
            }
        }
    }

    private void subscribeToCoTFolder() {
        BSAMLIdPService samlIdPService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE);
        Subscriber cotSubscriber = Subscriber.make((Consumer)new CircleOfTrustFolderEventConsumer());
        cotSubscriber.subscribe((BComponent)samlIdPService.getCircleOfTrustFolder(), 1);
    }

    private void subscribeToUserAuthenticationSchemeModified() {
        BSAMLIdPService idpService;
        if (this.getParent() instanceof BUser && (idpService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE)) != null) {
            idpService.getUserSubscriber().subscribe((BComponent)this.getParent());
        }
    }

    private void subscribeToCoT(BCircleOfTrust circleOfTrust) {
        Subscriber cotSubscriber = Subscriber.make((Consumer)new CircleOfTrustEventConsumer());
        cotSubscriber.subscribe((BComponent)circleOfTrust, 1);
    }

    private void init() {
        BCircleOfTrust[] circlesOfTrust;
        BSAMLIdPService samlIdPService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE);
        BCircleOfTrustFolder cotFolder = samlIdPService.getCircleOfTrustFolder();
        for (BCircleOfTrust bCircleOfTrust : circlesOfTrust = (BCircleOfTrust[])cotFolder.getChildren(BCircleOfTrust.class)) {
            if (this.get(bCircleOfTrust.getName()) == null) {
                this.addConfigurationFor(bCircleOfTrust);
            } else {
                this.updateConfigurationFor(bCircleOfTrust);
            }
            this.subscribeToCoT(bCircleOfTrust);
        }
        for (BCircleOfTrust bCircleOfTrust : this.getSlotsArray()) {
            String configurationName = bCircleOfTrust.getName();
            if (cotFolder.get(configurationName) != null) continue;
            this.removeConfiguration(configurationName);
        }
        this.subscribeToCoTFolder();
        this.subscribeToUserAuthenticationSchemeModified();
    }

    private void addConfigurationFor(BCircleOfTrust circleOfTrust) {
        boolean isMemberOfCircle = true;
        if (this.getParent() instanceof BUser) {
            isMemberOfCircle = circleOfTrust.isUserMember((BUser)this.getParent());
        }
        String cotName = circleOfTrust.getName();
        this.add(cotName, (BValue)BString.make((String)""), isMemberOfCircle ? 0 : 4, BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"saml:UserCOTPrototypesEditor"), (String)"fieldEditor", (BIDataValue)BString.make((String)"saml:UserCOTPrototypesFE"), (String)CIRCLE_OF_TRUST_NAME, (BIDataValue)BString.make((String)cotName)), null);
        this.subscribeToCoT(circleOfTrust);
    }

    void updateConfigurationFor(BCircleOfTrust circleOfTrust) {
        boolean isMemberOfCircle = true;
        if (this.getParent() instanceof BUser) {
            isMemberOfCircle = circleOfTrust.isUserMember((BUser)this.getParent());
        }
        String slotName = circleOfTrust.getName();
        if (isMemberOfCircle) {
            this.setFlags(this.getSlot(slotName), this.getFlags(this.getSlot(slotName)) & 0xFFFFFFFB);
        } else {
            this.setFlags(this.getSlot(slotName), this.getFlags(this.getSlot(slotName)) | 4);
        }
    }

    private void removeConfiguration(String configurationName) {
        if (this.getSlot(configurationName) != null) {
            this.remove(configurationName);
        }
    }

    public static Set<String> splitPrototypes(String prototypes, boolean unescape) {
        String[] prototypeArray;
        if (prototypes != null && (prototypeArray = prototypes.split(PROTOTYPE_DELIMITER)).length > 0) {
            TreeSet<String> set = new TreeSet<String>();
            for (String prototype : prototypeArray) {
                if (prototype == null || prototype.isEmpty()) continue;
                String prototypeName = unescape ? SlotPath.unescape((String)prototype) : prototype;
                set.add(prototypeName);
            }
            return set;
        }
        return Collections.emptySet();
    }

    private class CircleOfTrustEventConsumer
    implements Consumer<BComponentEvent> {
        private CircleOfTrustEventConsumer() {
        }

        @Override
        public void accept(BComponentEvent event) {
            switch (event.getId()) {
                case 3: {
                    if (!(event.getSourceComponent() instanceof BPrototypesFolder)) break;
                    String oldPrototypeName = ((BString)event.getValue()).getString();
                    String circleOfTrustName = event.getSourceComponent().getParent().getName();
                    CharSequence[] prototypes = BSAMLCoTPrototypesMixIn.this.get(circleOfTrustName).toString().split(BSAMLCoTPrototypesMixIn.PROTOTYPE_DELIMITER);
                    for (int i = 0; i < prototypes.length; ++i) {
                        if (!prototypes[i].equals(oldPrototypeName)) continue;
                        prototypes[i] = event.getSourceComponent().getString(event.getSourceComponent().getProperty(event.getSlotName()));
                    }
                    BSAMLCoTPrototypesMixIn.this.set(circleOfTrustName, (BValue)BString.make((String)String.join((CharSequence)BSAMLCoTPrototypesMixIn.PROTOTYPE_DELIMITER, prototypes)));
                    break;
                }
                case 2: {
                    if (!(event.getSourceComponent() instanceof BPrototypesFolder)) break;
                    String oldPrototypeName = ((BString)event.getValue()).getString();
                    String circleOfTrustName = event.getSourceComponent().getParent().getName();
                    String[] prototypes = BSAMLCoTPrototypesMixIn.this.get(circleOfTrustName).toString().split(BSAMLCoTPrototypesMixIn.PROTOTYPE_DELIMITER);
                    ArrayList<String> prototypesList = new ArrayList<String>(Arrays.asList(prototypes));
                    prototypesList.remove(oldPrototypeName);
                    BSAMLCoTPrototypesMixIn.this.set(circleOfTrustName, (BValue)BString.make((String)String.join((CharSequence)BSAMLCoTPrototypesMixIn.PROTOTYPE_DELIMITER, prototypesList)));
                    break;
                }
                case 0: {
                    if (!event.getSlotName().equals("users") && !event.getSlotName().equals("authenticationSchemes")) break;
                    BCircleOfTrust circleOfTrust = (BCircleOfTrust)event.getSourceComponent();
                    BSAMLCoTPrototypesMixIn.this.updateConfigurationFor(circleOfTrust);
                }
            }
        }
    }

    private class CircleOfTrustFolderEventConsumer
    implements Consumer<BComponentEvent> {
        private CircleOfTrustFolderEventConsumer() {
        }

        @Override
        public void accept(BComponentEvent event) {
            switch (event.getId()) {
                case 3: {
                    if (!(event.getSourceComponent() instanceof BCircleOfTrustFolder)) break;
                    String oldCircleOfTrustName = ((BString)event.getValue()).getString();
                    BSAMLCoTPrototypesMixIn.this.rename(BSAMLCoTPrototypesMixIn.this.getProperty(oldCircleOfTrustName), event.getSlotName(), RENAME_CONTEXT);
                    break;
                }
                case 2: {
                    if (!(event.getValue() instanceof BCircleOfTrust)) break;
                    String circleOfTrustName = event.getSlotName();
                    BSAMLCoTPrototypesMixIn.this.removeConfiguration(circleOfTrustName);
                    break;
                }
                case 1: {
                    if (!(event.getValue() instanceof BCircleOfTrust)) break;
                    BSAMLCoTPrototypesMixIn.this.addConfigurationFor((BCircleOfTrust)event.getValue());
                }
            }
        }
    }
}

