/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.authnScheme;

import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.authn.NiagaraLoginModule;
import com.tridium.saml.authnScheme.SAMLCallback;
import com.tridium.saml.rp.servlet.SAMLAuthenticationInfo;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.util.Lexicon;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public final class SAMLLoginModule
extends NiagaraLoginModule {
    public boolean login() throws LoginException {
        FailedLoginException e;
        SAMLAuthenticationInfo authenticationInfo;
        if (this.callbackHandler == null) {
            throw new LoginException("CallbackHandler cannot be null for username and password login");
        }
        Callback[] callbacks = new Callback[]{new SAMLCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            authenticationInfo = ((SAMLCallback)callbacks[0]).getAuthenticationInfo();
            if (authenticationInfo == null) {
                return false;
            }
        }
        catch (UnsupportedCallbackException e2) {
            String msg = "Provided callback handler could not handle: " + e2.getCallback().toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e2);
            throw new LoginException(msg);
        }
        catch (Exception e3) {
            String msg = "Error handling callbacks:" + e3.toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e3);
            throw new LoginException(msg);
        }
        String username = authenticationInfo.getUsername();
        this.user = this.getUserService().getUser(username);
        if (this.user != null && this.getUserService().canLogin(this.user)) {
            this.succeeded = true;
            return true;
        }
        if (this.user != null && !this.getUserService().canLogin(this.user)) {
            e = new NiagaraFailedLoginException(this.user.getName(), Lexicon.make((String)"saml").get("saml.exception.login.lockedOut"));
            this.user = null;
        } else if (this.user != null) {
            e = new NiagaraFailedLoginException(this.user.getName(), "Login failed: Invalid username or password.");
            this.user = null;
        } else {
            e = new FailedLoginException("Login failed: Invalid username or password.");
        }
        throw e;
    }
}

