/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.authnScheme;

import com.tridium.authn.NiagaraLoginConfiguration;
import com.tridium.saml.attributes.BSAMLAttributeMapper;
import com.tridium.saml.attributes.BSAMLAttributeMapping;
import com.tridium.saml.authnScheme.SAMLLoginModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BBlankAuthenticator;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="entityId", type="String", defaultValue=""), @NiagaraProperty(name="idpHostURL", type="String", defaultValue="https://idp.domain.com", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:HTTPHostnameFE\")")}), @NiagaraProperty(name="idpHostPort", type="int", defaultValue="443", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="65535"), @Facet(name="BFacets.RADIX", value="10")}), @NiagaraProperty(name="idpLoginPath", type="String", defaultValue="/path/to/login"), @NiagaraProperty(name="idpCert", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:UserTrustCertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(name="\"storeId\"", value="BString.make(\"USER_TRUST_STORE\")"), @Facet(name="\"purposeId\"", value="BString.make(\"\")")}), @NiagaraProperty(name="samlServerCert", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")")}), @NiagaraProperty(name="timeSkew", type="BRelTime", defaultValue="BRelTime.makeMinutes(3)")})
public final class BSAMLAuthenticationScheme
extends BSSOAuthenticationScheme {
    public static final Property entityId = BSAMLAuthenticationScheme.newProperty((int)0, (String)"", null);
    public static final Property idpHostURL = BSAMLAuthenticationScheme.newProperty((int)0, (String)"https://idp.domain.com", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:HTTPHostnameFE")));
    public static final Property idpHostPort = BSAMLAuthenticationScheme.newProperty((int)0, (int)443, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)65535)), (BFacets)BFacets.make((String)"radix", (int)10)));
    public static final Property idpLoginPath = BSAMLAuthenticationScheme.newProperty((int)0, (String)"/path/to/login", null);
    public static final Property idpCert = BSAMLAuthenticationScheme.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:UserTrustCertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"storeId", (BIDataValue)BString.make((String)"USER_TRUST_STORE"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)""))));
    public static final Property samlServerCert = BSAMLAuthenticationScheme.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))));
    public static final Property timeSkew = BSAMLAuthenticationScheme.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)3), null);
    public static final Type TYPE = Sys.loadType(BSAMLAuthenticationScheme.class);
    public static final String SCHEME_NAME = "n4saml";
    private Configuration configuration = null;

    public String getEntityId() {
        return this.getString(entityId);
    }

    public void setEntityId(String v) {
        this.setString(entityId, v, null);
    }

    public String getIdpHostURL() {
        return this.getString(idpHostURL);
    }

    public void setIdpHostURL(String v) {
        this.setString(idpHostURL, v, null);
    }

    public int getIdpHostPort() {
        return this.getInt(idpHostPort);
    }

    public void setIdpHostPort(int v) {
        this.setInt(idpHostPort, v, null);
    }

    public String getIdpLoginPath() {
        return this.getString(idpLoginPath);
    }

    public void setIdpLoginPath(String v) {
        this.setString(idpLoginPath, v, null);
    }

    public String getIdpCert() {
        return this.getString(idpCert);
    }

    public void setIdpCert(String v) {
        this.setString(idpCert, v, null);
    }

    public String getSamlServerCert() {
        return this.getString(samlServerCert);
    }

    public void setSamlServerCert(String v) {
        this.setString(samlServerCert, v, null);
    }

    public BRelTime getTimeSkew() {
        return (BRelTime)this.get(timeSkew);
    }

    public void setTimeSkew(BRelTime v) {
        this.set(timeSkew, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public Configuration getLoginConfiguration() {
        if (this.configuration == null) {
            this.configuration = new NiagaraLoginConfiguration(SAMLLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
        }
        return this.configuration;
    }

    public BAbstractAuthenticator getDefaultAuthenticator() {
        return new BBlankAuthenticator();
    }

    public boolean supportsRemoteUsers() {
        return true;
    }

    public String getLoginRedirectURL() {
        return "/saml/samlrp";
    }

    public Set<BSAMLAttributeMapping> getAttributeMappings() {
        BSAMLAttributeMapper[] mappers = (BSAMLAttributeMapper[])this.getChildren(BSAMLAttributeMapper.class);
        HashSet<BSAMLAttributeMapping> mappings = new HashSet<BSAMLAttributeMapping>();
        for (BSAMLAttributeMapper mapper : mappers) {
            Collections.addAll(mappings, mapper.getChildren(BSAMLAttributeMapping.class));
        }
        return mappings;
    }
}

