/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.attributes;

import com.tridium.saml.attributes.BSAMLExpirationUserProperty;
import com.tridium.saml.attributes.BSAMLPrototypeUserProperty;
import com.tridium.saml.attributes.BSAMLStandardUserProperty;
import com.tridium.saml.attributes.BSAMLUserProperty;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(ordinal=1, value="fullName"), @Range(ordinal=2, value="expiration"), @Range(ordinal=3, value="language"), @Range(ordinal=4, value="email"), @Range(ordinal=5, value="prototypeName"), @Range(ordinal=6, value="cellPhoneNumber"), @Range(ordinal=7, value="username")}, defaultValue="email")
public final class BSAMLUserPropertyType
extends BFrozenEnum {
    public static final int FULL_NAME = 1;
    public static final int EXPIRATION = 2;
    public static final int LANGUAGE = 3;
    public static final int EMAIL = 4;
    public static final int PROTOTYPE_NAME = 5;
    public static final int CELL_PHONE_NUMBER = 6;
    public static final int USERNAME = 7;
    public static final BSAMLUserPropertyType fullName = new BSAMLUserPropertyType(1);
    public static final BSAMLUserPropertyType expiration = new BSAMLUserPropertyType(2);
    public static final BSAMLUserPropertyType language = new BSAMLUserPropertyType(3);
    public static final BSAMLUserPropertyType email = new BSAMLUserPropertyType(4);
    public static final BSAMLUserPropertyType prototypeName = new BSAMLUserPropertyType(5);
    public static final BSAMLUserPropertyType cellPhoneNumber = new BSAMLUserPropertyType(6);
    public static final BSAMLUserPropertyType username = new BSAMLUserPropertyType(7);
    public static final BSAMLUserPropertyType DEFAULT = email;
    public static final Type TYPE = Sys.loadType(BSAMLUserPropertyType.class);

    public static BSAMLUserPropertyType make(int ordinal) {
        return (BSAMLUserPropertyType)fullName.getRange().get(ordinal, false);
    }

    public static BSAMLUserPropertyType make(String tag) {
        return (BSAMLUserPropertyType)fullName.getRange().get(tag);
    }

    private BSAMLUserPropertyType(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public static BSAMLUserProperty generateSAMLUserProperty(BSAMLUserPropertyType type) {
        BSAMLUserProperty userProperty;
        switch (type.getOrdinal()) {
            case 2: {
                userProperty = new BSAMLExpirationUserProperty();
                break;
            }
            case 5: {
                userProperty = new BSAMLPrototypeUserProperty();
                break;
            }
            default: {
                userProperty = new BSAMLStandardUserProperty();
                userProperty.setUserPropertyType(type);
            }
        }
        return userProperty;
    }
}

