/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml;

import com.onelogin.saml.XMLErrorHandler;
import com.tridium.saml.SAMLException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class.getName());

    public static NodeList query(Document dom, String query, Node context) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                String result = null;
                switch (prefix) {
                    case "samlp": 
                    case "samlp2": {
                        result = "urn:oasis:names:tc:SAML:2.0:protocol";
                        break;
                    }
                    case "saml": 
                    case "saml2": {
                        result = "urn:oasis:names:tc:SAML:2.0:assertion";
                        break;
                    }
                    case "ds": {
                        result = "http://www.w3.org/2000/09/xmldsig#";
                        break;
                    }
                    case "xenc": {
                        result = "http://www.w3.org/2001/04/xmlenc#";
                        break;
                    }
                    case "md": {
                        result = "urn:oasis:names:tc:SAML:2.0:metadata";
                    }
                }
                return result;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
        NodeList nodeList = context == null ? (NodeList)xpath.evaluate(query, dom, XPathConstants.NODESET) : (NodeList)xpath.evaluate(query, context, XPathConstants.NODESET);
        return nodeList;
    }

    public static NodeList query(Document dom, String query) throws XPathExpressionException {
        return Utils.query(dom, query, null);
    }

    public static Map<String, String> getStatus(Document dom) throws Error {
        HashMap<String, String> status = new HashMap<String, String>();
        try {
            NodeList statusEntry = Utils.query(dom, "/samlp:Response/samlp:Status", null);
            if (statusEntry.getLength() == 0) {
                throw new Error("Missing Status on response");
            }
            NodeList codeEntry = Utils.query(dom, "/samlp:Response/samlp:Status/samlp:StatusCode", statusEntry.item(0));
            if (codeEntry.getLength() == 0) {
                throw new Error("Missing Status Code on response");
            }
            status.put("code", codeEntry.item(0).getAttributes().getNamedItem("Value").getNodeValue());
            NodeList messageEntry = Utils.query(dom, "/samlp:Response/samlp:Status/samlp:StatusMessage", statusEntry.item(0));
            if (messageEntry.getLength() == 0) {
                status.put("msg", "");
            } else {
                status.put("msg", messageEntry.item(0).getNodeValue());
            }
        }
        catch (Error e) {
            log.severe("Error executing getStatus: " + e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            log.severe("Error executing getStatus: " + ex.getMessage());
        }
        return status;
    }

    public static Document loadXML(String xml) throws SAMLException {
        if (xml.contains("<!ENTITY")) {
            throw new SAMLException("Detected use of ENTITY in XML, disabled to prevent XXE/XEE attacks");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.setAttribute("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("//*[@ID]");
            NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                Attr attr = (Attr)elem.getAttributes().getNamedItem("ID");
                elem.setIdAttributeNode(attr, true);
            }
            return doc;
        }
        catch (Exception e) {
            log.severe("Error executing loadXML: " + e.getMessage());
            return null;
        }
    }

    public static Document validateXML(Document xml, String schemaName) throws Exception {
        return Utils.validateXML(Utils.getStringFromDocument(xml), schemaName);
    }

    public static Document validateXML(String xmlString, String schemaName) throws Exception {
        try {
            String schemaFullPath = "schemas/" + schemaName;
            ClassLoader classLoader = Utils.class.getClassLoader();
            URL schemaFile = classLoader.getResource(schemaFullPath);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            XMLErrorHandler errorHandler = new XMLErrorHandler();
            validator.setErrorHandler(errorHandler);
            validator.validate(new StreamSource(new StringReader(xmlString)));
            if (errorHandler.getErrorXML().size() > 0) {
                throw new Error("Invalid XML. See the log");
            }
        }
        catch (Exception ex) {
            log.severe("Error executing validateXML: " + ex.getMessage());
            throw ex;
        }
        return Utils.convertStringToDocument(xmlString);
    }

    public static boolean validateSign(Node signatureElement, Certificate cert) throws Exception {
        boolean res;
        DOMValidateContext ctx = new DOMValidateContext(cert.getPublicKey(), signatureElement);
        XMLSignatureFactory sigF = XMLSignatureFactory.getInstance("DOM");
        try {
            try {
                res = AccessController.doPrivileged(() -> {
                    XMLSignature xmlSignature = sigF.unmarshalXMLSignature(ctx);
                    return xmlSignature.validate(ctx);
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        catch (MarshalException e) {
            log.severe("Cannot locate Signature Node " + e.getMessage());
            throw e;
        }
        catch (NullPointerException e) {
            log.severe("Context can't be validated" + e.getMessage());
            throw e;
        }
        return res;
    }

    public static Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xmlStr)));
        }
        catch (Exception ex) {
            log.severe("Error executing convertStringToDocument: " + ex.getMessage());
            return null;
        }
    }

    public static String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            writer.flush();
            return writer.toString();
        }
        catch (TransformerException ex) {
            log.severe("Error executing getStringFromDocument: " + ex.getMessage());
            return null;
        }
    }

    public static void signRequestDocument(Document doc, String keyStoreFilePath, String keyStorePassword, String keyEntryAlias, String keyEntryPassword, String elementID) throws Exception {
        Element rootEl = doc.getDocumentElement();
        rootEl.setIdAttribute("ID", true);
        NodeList nl = doc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        Element assertionEl = (Element)nl.item(0);
        assertionEl.setIdAttribute("ID", true);
        Element signedElement = rootEl;
        nl = doc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Status");
        Element status = (Element)nl.item(0);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        Reference ref = fac.newReference("#" + elementID, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        KeyStore.PrivateKeyEntry keyEntry = Utils.getPrivateKeyEntry(keyStoreFilePath, keyStorePassword, keyEntryAlias, keyEntryPassword);
        X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(cert.getSubjectX500Principal().getName());
        x509Content.add(cert);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        DOMSignContext dsc = new DOMSignContext(keyEntry.getPrivateKey(), (Node)signedElement, (Node)status);
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
    }

    public static void signResponseDocument(Document doc, String keyStoreFilePath, String keyStorePassword, String keyEntryAlias, String keyEntryPassword, String elementID) throws Exception {
        Element rootEl = doc.getDocumentElement();
        rootEl.setIdAttribute("ID", true);
        NodeList nl = doc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        Element assertionEl = (Element)nl.item(0);
        assertionEl.setIdAttribute("ID", true);
        Element signedElement = rootEl;
        nl = doc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Status");
        Element status = (Element)nl.item(0);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        Reference ref = fac.newReference("#" + elementID, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        KeyStore.PrivateKeyEntry keyEntry = Utils.getPrivateKeyEntry(keyStoreFilePath, keyStorePassword, keyEntryAlias, keyEntryPassword);
        X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(cert.getSubjectX500Principal().getName());
        x509Content.add(cert);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        DOMSignContext dsc = new DOMSignContext(keyEntry.getPrivateKey(), (Node)signedElement, (Node)status);
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
    }

    public static KeyStore.PrivateKeyEntry getPrivateKeyEntry(String keyStoreFilePath, String keyStorePassword, String keyEntryAlias, String keyEntryPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableEntryException {
        KeyStore ks = KeyStore.getInstance("BCFKS");
        ks.load(new FileInputStream(keyStoreFilePath), keyStorePassword.toCharArray());
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(keyEntryAlias, new KeyStore.PasswordProtection(keyEntryPassword.toCharArray()));
        return keyEntry;
    }

    public static Document loadXMLFromString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(xml.getBytes()));
    }

    public static Document copyDocument(Document source) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Element originalRoot = source.getDocumentElement();
        Document copiedDocument = db.newDocument();
        Node copiedRoot = copiedDocument.importNode(originalRoot, true);
        copiedDocument.appendChild(copiedRoot);
        return copiedDocument;
    }

    public static String getPrettyPrintedString(String xml) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        return Utils.getPrettyPrintedString(doc);
    }

    public static String getPrettyPrintedString(Document doc) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter out = new StringWriter();
        tf.transform(new DOMSource(doc), new StreamResult(out));
        return ((Object)out).toString();
    }

    public static String toStringUtf8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

